/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.certificatetransparency;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.keys.util.KeyTools;

public final class CTLogInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int logId;
    private final byte[] publicKeyBytes;
    private final String url;
    private int timeout = 5000;
    private transient PublicKey publicKey;

    public CTLogInfo(String url, byte[] publicKeyBytes) {
        this.logId = url.hashCode();
        this.url = url;
        if (publicKeyBytes == null) {
            throw new IllegalArgumentException("publicKeyBytes is null");
        }
        this.publicKeyBytes = (byte[])publicKeyBytes.clone();
    }

    private void ensureParsed() {
        if (this.publicKey == null) {
            this.publicKey = KeyTools.getPublicKeyFromBytes(this.publicKeyBytes);
            if (this.publicKey == null) {
                throw new IllegalStateException("Failed to parse key");
            }
        }
    }

    public int getLogId() {
        return this.logId;
    }

    public PublicKey getLogPublicKey() {
        this.ensureParsed();
        return this.publicKey;
    }

    public String getLogKeyIdString() {
        try {
            this.ensureParsed();
            MessageDigest md = MessageDigest.getInstance("SHA256");
            byte[] keyId = md.digest(this.publicKey.getEncoded());
            return new String(Hex.encode((byte[])keyId)).substring(0, 8).toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

