/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.crl;

import java.util.HashMap;
import java.util.Map;

public enum RevocationReasons {
    NOT_REVOKED(-1, "NOT_REVOKED", "the certificate is not revoked"),
    UNSPECIFIED(0, "UNSPECIFIED", "unspecified"),
    KEYCOMPROMISE(1, "KEY_COMPROMISE", "key compromise"),
    CACOMPROMISE(2, "CA_COMPROMISE", "CA compromise"),
    AFFILIATIONCHANGED(3, "AFFILIATION_CHANGED", "affiliation changed"),
    SUPERSEDED(4, "SUPERSEDED", "superseded"),
    CESSATIONOFOPERATION(5, "CESSATION_OF_OPERATION", "cessation of operation"),
    CERTIFICATEHOLD(6, "CERTIFICATE_HOLD", "certificate hold"),
    REMOVEFROMCRL(8, "REMOVE_FROM_CRL", "remove from CRL"),
    PRIVILEGESWITHDRAWN(9, "PRIVILEGES_WITHDRAWN", "privileges withdrawn"),
    AACOMPROMISE(10, "AA_COMPROMISE", "AA compromise");

    private final int databaseValue;
    private final String stringValue;
    private final String humanReadable;
    private static final Map<Integer, RevocationReasons> databaseLookupMap;
    private static final Map<String, RevocationReasons> cliLookupMap;

    private RevocationReasons(int databaseValue, String stringValue, String humanReadable) {
        this.databaseValue = databaseValue;
        this.stringValue = stringValue;
        this.humanReadable = humanReadable;
    }

    public int getDatabaseValue() {
        return this.databaseValue;
    }

    public String getHumanReadable() {
        return this.humanReadable;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public static RevocationReasons getFromDatabaseValue(int databaseValue) {
        return databaseLookupMap.get(databaseValue);
    }

    public static RevocationReasons getFromCliValue(String cliValue) {
        if (cliValue == null) {
            return null;
        }
        return cliLookupMap.get(cliValue);
    }

    static {
        databaseLookupMap = new HashMap<Integer, RevocationReasons>();
        cliLookupMap = new HashMap<String, RevocationReasons>();
        for (RevocationReasons reason : RevocationReasons.values()) {
            databaseLookupMap.put(reason.getDatabaseValue(), reason);
            cliLookupMap.put(reason.getStringValue(), reason);
        }
    }
}

