/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.crl;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import org.cesecore.certificates.crl.RevocationReasons;

public class RevokedCertInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NOT_REVOKED = RevocationReasons.NOT_REVOKED.getDatabaseValue();
    public static final int REVOCATION_REASON_UNSPECIFIED = RevocationReasons.UNSPECIFIED.getDatabaseValue();
    public static final int REVOCATION_REASON_KEYCOMPROMISE = RevocationReasons.KEYCOMPROMISE.getDatabaseValue();
    public static final int REVOCATION_REASON_CACOMPROMISE = RevocationReasons.CACOMPROMISE.getDatabaseValue();
    public static final int REVOCATION_REASON_AFFILIATIONCHANGED = RevocationReasons.AFFILIATIONCHANGED.getDatabaseValue();
    public static final int REVOCATION_REASON_SUPERSEDED = RevocationReasons.SUPERSEDED.getDatabaseValue();
    public static final int REVOCATION_REASON_CESSATIONOFOPERATION = RevocationReasons.CESSATIONOFOPERATION.getDatabaseValue();
    public static final int REVOCATION_REASON_CERTIFICATEHOLD = RevocationReasons.CERTIFICATEHOLD.getDatabaseValue();
    public static final int REVOCATION_REASON_REMOVEFROMCRL = RevocationReasons.REMOVEFROMCRL.getDatabaseValue();
    public static final int REVOCATION_REASON_PRIVILEGESWITHDRAWN = RevocationReasons.PRIVILEGESWITHDRAWN.getDatabaseValue();
    public static final int REVOCATION_REASON_AACOMPROMISE = RevocationReasons.AACOMPROMISE.getDatabaseValue();
    private byte[] userCertificate;
    private long revocationDate;
    private long expireDate;
    private int reason;
    private byte[] fingerprint;

    public RevokedCertInfo() {
        this.fingerprint = null;
        this.userCertificate = null;
        this.revocationDate = 0L;
        this.expireDate = 0L;
        this.reason = REVOCATION_REASON_UNSPECIFIED;
    }

    public RevokedCertInfo(byte[] fingerprint, byte[] sernoBigIntegerArray, long revdate, int reason, long expdate) {
        this.fingerprint = fingerprint;
        this.userCertificate = sernoBigIntegerArray;
        this.revocationDate = revdate;
        this.reason = reason;
        this.expireDate = expdate;
    }

    public String getCertificateFingerprint() {
        return this.fingerprint == null ? null : new String(this.fingerprint);
    }

    public void setCertificateFingerprint(String fp) {
        this.fingerprint = fp == null ? null : fp.getBytes();
    }

    public BigInteger getUserCertificate() {
        return this.userCertificate == null ? null : new BigInteger(this.userCertificate);
    }

    public void setUserCertificate(BigInteger serno) {
        this.userCertificate = serno == null ? null : serno.toByteArray();
    }

    public Date getRevocationDate() {
        return this.revocationDate == 0L ? null : new Date(this.revocationDate);
    }

    public void setRevocationDate(Date date) {
        this.revocationDate = date == null ? 0L : date.getTime();
    }

    public Date getExpireDate() {
        return this.expireDate == 0L ? null : new Date(this.expireDate);
    }

    public void setExpireDate(Date date) {
        this.expireDate = date == null ? 0L : date.getTime();
    }

    public int getReason() {
        return this.reason;
    }

    public void setReason(int reason) {
        this.reason = reason;
    }

    public String toString() {
        return this.userCertificate == null ? "null" : new BigInteger(this.userCertificate).toString();
    }

    public boolean isRevoked() {
        return this.reason != NOT_REVOKED;
    }

    public String getHumanReadableReason() {
        RevocationReasons revocationReason = RevocationReasons.getFromDatabaseValue(this.reason);
        if (revocationReason != null) {
            return revocationReason.getHumanReadable();
        }
        return "unknown";
    }
}

