/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.endentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public final class EndEntityConstants {
    public static final int STATUS_NEW = 10;
    public static final int STATUS_FAILED = 11;
    public static final int STATUS_INITIALIZED = 20;
    public static final int STATUS_INPROCESS = 30;
    public static final int STATUS_GENERATED = 40;
    public static final int STATUS_REVOKED = 50;
    public static final int STATUS_HISTORICAL = 60;
    public static final int STATUS_KEYRECOVERY = 70;
    public static final int TOKEN_USERGEN = 1;
    public static final int TOKEN_SOFT_P12 = 2;
    public static final int TOKEN_SOFT_JKS = 3;
    public static final int TOKEN_SOFT_PEM = 4;
    public static final int TOKEN_SOFT = 100;
    private static final HashMap<Integer, String> STATUS_TEXT_TRANS = new HashMap();
    private static final HashMap<Integer, String> STATUS_TEXT;

    public static String getTranslatableStatusText(int status) {
        String ret = null;
        String o = STATUS_TEXT_TRANS.get(status);
        if (o != null) {
            ret = o;
        }
        return ret;
    }

    public static String getStatusText(int status) {
        String ret = null;
        String o = STATUS_TEXT.get(status);
        if (o != null) {
            ret = o;
        }
        return ret;
    }

    public static Collection<Integer> getAllStatusCodes() {
        ArrayList<Integer> statuses = new ArrayList<Integer>(STATUS_TEXT.keySet());
        Collections.sort(statuses);
        return statuses;
    }

    static {
        STATUS_TEXT_TRANS.put(10, "STATUSNEW");
        STATUS_TEXT_TRANS.put(11, "STATUSFAILED");
        STATUS_TEXT_TRANS.put(20, "STATUSINITIALIZED");
        STATUS_TEXT_TRANS.put(30, "STATUSINPROCESS");
        STATUS_TEXT_TRANS.put(40, "STATUSGENERATED");
        STATUS_TEXT_TRANS.put(50, "STATUSREVOKED");
        STATUS_TEXT_TRANS.put(60, "STATUSHISTORICAL");
        STATUS_TEXT_TRANS.put(70, "STATUSKEYRECOVERY");
        STATUS_TEXT = new HashMap();
        STATUS_TEXT.put(10, "NEW");
        STATUS_TEXT.put(11, "FAILED");
        STATUS_TEXT.put(20, "INITIALIZED");
        STATUS_TEXT.put(30, "INPROCESS");
        STATUS_TEXT.put(40, "GENERATED");
        STATUS_TEXT.put(50, "REVOKED");
        STATUS_TEXT.put(60, "HISTORICAL");
        STATUS_TEXT.put(70, "KEYRECOVERY");
    }
}

