/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.endentity;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.cesecore.certificates.endentity.EndEntityType;
import org.cesecore.certificates.endentity.EndEntityTypes;
import org.cesecore.certificates.endentity.ExtendedInformation;
import org.cesecore.certificates.util.dn.DNFieldsUtil;
import org.cesecore.util.Base64GetHashMap;
import org.cesecore.util.Base64PutHashMap;
import org.cesecore.util.StringTools;

public class EndEntityInformation
implements Serializable {
    private static final long serialVersionUID = 3837505643343885941L;
    public static final int NO_ENDENTITYPROFILE = 0;
    public static final int NO_CERTIFICATEPROFILE = 0;
    private String username;
    private String subjectDN;
    private transient String subjectDNClean = null;
    private int caid;
    private String subjectAltName;
    private String subjectEmail;
    private String password;
    private String cardNumber;
    private int status;
    private int type;
    private int endentityprofileid;
    private int certificateprofileid;
    private Date timecreated;
    private Date timemodified;
    private int tokentype;
    private int hardtokenissuerid;
    private ExtendedInformation extendedinformation;

    public EndEntityInformation() {
    }

    public EndEntityInformation(String user, String dn, int caid, String subjectaltname, String email, int status, EndEntityType type, int endentityprofileid, int certificateprofileid, Date timecreated, Date timemodified, int tokentype, int hardtokenissuerid, ExtendedInformation extendedinfo) {
        this.setUsername(user);
        this.setPassword(null);
        this.setCardNumber(null);
        this.setDN(dn);
        this.setCAId(caid);
        this.setSubjectAltName(subjectaltname);
        this.setEmail(email);
        this.setStatus(status);
        this.setType(type);
        this.setEndEntityProfileId(endentityprofileid);
        this.setCertificateProfileId(certificateprofileid);
        this.setTimeCreated(timecreated);
        this.setTimeModified(timemodified);
        this.setTokenType(tokentype);
        this.setHardTokenIssuerId(hardtokenissuerid);
        this.setExtendedinformation(extendedinfo);
        this.setCardNumber(null);
    }

    public EndEntityInformation(String username, String dn, int caid, String subjectaltname, String email, EndEntityType type, int endentityprofileid, int certificateprofileid, int tokentype, int hardtokenissuerid, ExtendedInformation extendedinfo) {
        this.setUsername(username);
        this.setPassword(null);
        this.setDN(dn);
        this.setCAId(caid);
        this.setSubjectAltName(subjectaltname);
        this.setEmail(email);
        this.setType(type);
        this.setEndEntityProfileId(endentityprofileid);
        this.setCertificateProfileId(certificateprofileid);
        this.setTokenType(tokentype);
        this.setHardTokenIssuerId(hardtokenissuerid);
        this.setExtendedinformation(extendedinfo);
        this.setCardNumber(null);
    }

    public void setUsername(String user) {
        this.username = StringTools.putBase64String(StringTools.stripUsername(user));
    }

    public String getUsername() {
        return StringTools.getBase64String(this.username);
    }

    public void setDN(String dn) {
        StringBuilder removedAllEmpties = new StringBuilder(dn.length());
        StringBuilder removedTrailingEmpties = DNFieldsUtil.removeEmpties(dn, removedAllEmpties, true);
        if (removedTrailingEmpties == null) {
            this.subjectDN = this.subjectDNClean = StringTools.putBase64String(removedAllEmpties.toString());
        } else {
            this.subjectDNClean = StringTools.putBase64String(removedAllEmpties.toString());
            this.subjectDN = StringTools.putBase64String(removedTrailingEmpties.toString());
        }
    }

    public String getDN() {
        return StringTools.getBase64String(this.subjectDN);
    }

    public int getCAId() {
        return this.caid;
    }

    public void setCAId(int caid) {
        this.caid = caid;
    }

    public void setSubjectAltName(String subjectaltname) {
        this.subjectAltName = StringTools.putBase64String(subjectaltname);
    }

    public String getSubjectAltName() {
        return StringTools.getBase64String(this.subjectAltName);
    }

    public void setEmail(String email) {
        this.subjectEmail = StringTools.putBase64String(email);
    }

    public String getEmail() {
        return StringTools.getBase64String(this.subjectEmail);
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = StringTools.putBase64String(cardNumber);
    }

    public String getCardNumber() {
        return StringTools.getBase64String(this.cardNumber);
    }

    public void setPassword(String pwd) {
        this.password = StringTools.putBase64String(pwd);
    }

    public String getPassword() {
        return StringTools.getBase64String(this.password);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setType(EndEntityType type) {
        this.type = type.getHexValue();
    }

    public EndEntityType getType() {
        return new EndEntityType(this.type);
    }

    public void setEndEntityProfileId(int endentityprofileid) {
        this.endentityprofileid = endentityprofileid;
    }

    public int getEndEntityProfileId() {
        return this.endentityprofileid;
    }

    public void setCertificateProfileId(int certificateprofileid) {
        this.certificateprofileid = certificateprofileid;
    }

    public int getCertificateProfileId() {
        return this.certificateprofileid;
    }

    public void setTimeCreated(Date timecreated) {
        this.timecreated = timecreated;
    }

    public Date getTimeCreated() {
        return this.timecreated;
    }

    public void setTimeModified(Date timemodified) {
        this.timemodified = timemodified;
    }

    public Date getTimeModified() {
        return this.timemodified;
    }

    public int getTokenType() {
        return this.tokentype;
    }

    public void setTokenType(int tokentype) {
        this.tokentype = tokentype;
    }

    public int getHardTokenIssuerId() {
        return this.hardtokenissuerid;
    }

    public void setHardTokenIssuerId(int hardtokenissuerid) {
        this.hardtokenissuerid = hardtokenissuerid;
    }

    public boolean getAdministrator() {
        return this.getType().contains(EndEntityTypes.ADMINISTRATOR);
    }

    public void setAdministrator(boolean administrator) {
        EndEntityType type = this.getType();
        if (administrator) {
            type.addType(EndEntityTypes.ADMINISTRATOR);
        } else {
            type.removeType(EndEntityTypes.ADMINISTRATOR);
        }
        this.setType(type);
    }

    public boolean getKeyRecoverable() {
        return this.getType().contains(EndEntityTypes.KEYRECOVERABLE);
    }

    public void setKeyRecoverable(boolean keyrecoverable) {
        EndEntityType type = this.getType();
        if (keyrecoverable) {
            type.addType(EndEntityTypes.KEYRECOVERABLE);
        } else {
            type.removeType(EndEntityTypes.KEYRECOVERABLE);
        }
        this.setType(type);
    }

    public boolean getSendNotification() {
        return this.getType().contains(EndEntityTypes.SENDNOTIFICATION);
    }

    public void setSendNotification(boolean sendnotification) {
        EndEntityType type = this.getType();
        if (sendnotification) {
            type.addType(EndEntityTypes.SENDNOTIFICATION);
        } else {
            type.removeType(EndEntityTypes.SENDNOTIFICATION);
        }
        this.setType(type);
    }

    public boolean getPrintUserData() {
        return this.getType().contains(EndEntityTypes.PRINT);
    }

    public void setPrintUserData(boolean printUserData) {
        EndEntityType type = this.getType();
        if (printUserData) {
            type.addType(EndEntityTypes.PRINT);
        } else {
            type.removeType(EndEntityTypes.PRINT);
        }
        this.setType(type);
    }

    public ExtendedInformation getExtendedinformation() {
        return this.extendedinformation;
    }

    public void setExtendedinformation(ExtendedInformation extendedinformation) {
        this.extendedinformation = extendedinformation;
    }

    public static ExtendedInformation getExtendedInformation(String extendedinfostring) {
        ExtendedInformation returnval = null;
        if (extendedinfostring != null && extendedinfostring.length() > 0) {
            try {
                XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(extendedinfostring.getBytes("UTF8")));
                HashMap h = (HashMap)decoder.readObject();
                decoder.close();
                Base64GetHashMap data = new Base64GetHashMap((Map<?, ?>)h);
                int type = (Integer)((HashMap)data).get("type");
                switch (type) {
                    case 0: {
                        returnval = new ExtendedInformation();
                        returnval.loadData(data);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Problems generating extended information from String", e);
            }
        }
        return returnval;
    }

    public static String extendedInformationToStringData(ExtendedInformation extendedinformation) throws UnsupportedEncodingException {
        String ret = null;
        if (extendedinformation != null) {
            Base64PutHashMap a = new Base64PutHashMap();
            a.putAll((Map)extendedinformation.saveData());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(baos);
            encoder.writeObject(a);
            encoder.close();
            ret = baos.toString("UTF8");
        }
        return ret;
    }

    public String getCertificateDN() {
        if (this.subjectDNClean == null) {
            return DNFieldsUtil.removeAllEmpties(this.getDN());
        }
        return StringTools.getBase64String(this.subjectDNClean);
    }
}

