/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.endentity;

import java.io.Serializable;
import java.security.InvalidParameterException;
import org.cesecore.certificates.endentity.EndEntityTypes;

public class EndEntityType
implements Serializable {
    private static final long serialVersionUID = 730921129476820912L;
    private int type = EndEntityTypes.INVALID.hexValue();

    public EndEntityType() {
        this.type = EndEntityTypes.INVALID.hexValue();
    }

    public EndEntityType(EndEntityTypes type) {
        if (type == null) {
            throw new InvalidParameterException("Cannot create an EndEntityType with input parameter null");
        }
        this.type = type.hexValue();
    }

    public EndEntityType(int type) {
        this.type = type;
    }

    public EndEntityType(EndEntityTypes ... types) {
        if (types.length == 0) {
            throw new InvalidParameterException("Cannot create an EndEntityType with input parameter null");
        }
        this.type = 0;
        for (EndEntityTypes endEntityType : types) {
            this.type = endEntityType.addTo(this.type);
        }
    }

    public boolean isType(EndEntityTypes endEntityTypes) {
        return this.type == endEntityTypes.hexValue();
    }

    public boolean contains(EndEntityTypes endEntityType) {
        return endEntityType.isContainedInType(this.type);
    }

    public void addType(EndEntityTypes endEntityType) {
        this.type = endEntityType.addTo(this.type);
    }

    public void removeType(EndEntityTypes endEntityType) {
        this.type = endEntityType.removeFromType(this.type);
    }

    public int getHexValue() {
        return this.type;
    }
}

