/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.endentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.cesecore.certificates.endentity.EndEntityType;

public enum EndEntityTypes {
    INVALID(0, "Dummy type."),
    ENDUSER(1, "This is an end user certificate (default)."),
    ADMINISTRATOR(64, "This user is an administrator."),
    KEYRECOVERABLE(128, "This users keystores are key recoverable."),
    SENDNOTIFICATION(256, "Notification will be sent to this users emailaddress"),
    PRINT(512, "Registration data will be printed for this user");

    private static final Map<Integer, EndEntityTypes> lookupTable;
    private int hexCode;
    private String description;

    private EndEntityTypes(int hexCode, String description) {
        this.hexCode = hexCode;
        this.description = description;
    }

    public int hexValue() {
        return this.hexCode;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(EndEntityTypes endEntityType) {
        return this.hexCode == endEntityType.hexValue();
    }

    public static EndEntityTypes[] getTypesFromHexCode(int hexCode) {
        ArrayList<EndEntityTypes> result = new ArrayList<EndEntityTypes>();
        for (EndEntityTypes type : EndEntityTypes.values()) {
            if (!type.isContainedInType(hexCode)) continue;
            result.add(type);
        }
        return result.toArray(new EndEntityTypes[result.size()]);
    }

    public static int combineAll(EndEntityTypes[] types) {
        int result = 0;
        for (EndEntityTypes type : types) {
            result = type.addTo(result);
        }
        return result;
    }

    public boolean isContainedInType(int otherHexCode) {
        return (this.hexCode & otherHexCode) == this.hexCode;
    }

    public int addTo(int otherHexCode) {
        return this.hexCode | otherHexCode;
    }

    public int removeFromType(int otherHexCode) {
        return otherHexCode & ~this.hexCode;
    }

    public EndEntityType toEndEntityType() {
        return new EndEntityType(this);
    }

    static {
        lookupTable = new HashMap<Integer, EndEntityTypes>();
        for (EndEntityTypes type : EndEntityTypes.values()) {
            lookupTable.put(type.hexValue(), type);
        }
    }
}

