/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.endentity;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.cesecore.certificates.crl.RevokedCertInfo;
import org.cesecore.internal.InternalResources;
import org.cesecore.internal.UpgradeableDataHashMap;
import org.cesecore.util.ValidityDate;

public class ExtendedInformation
extends UpgradeableDataHashMap
implements Serializable {
    public static final String TYPE = "type";
    public static final int TYPE_BASIC = 0;
    private static final Logger log = Logger.getLogger(ExtendedInformation.class);
    private static final InternalResources intres = InternalResources.getInstance();
    private static final long serialVersionUID = 3981761824188420320L;
    private static final float LATEST_VERSION = 4.0f;
    public static final String SUBJECTDIRATTRIBUTES = "subjectdirattributes";
    public static final String CUSTOMDATA = "customdata_";
    public static final String EXTENSIONDATA = "extensiondata_";
    public static final String CUSTOM_STARTTIME = "STARTTIME";
    public static final String CUSTOM_ENDTIME = "ENDTIME";
    public static final String CUSTOM_REVOCATIONREASON = "REVOCATIONREASON";
    public static final String RAWSUBJECTDN = "RAWSUBJECTDN";
    private static final String REMAININGLOGINATTEMPTS = "remainingloginattempts";
    private static final String MAXFAILEDLOGINATTEMPTS = "maxfailedloginattempts";
    public static final int DEFAULT_MAXLOGINATTEMPTS = -1;
    public static final int DEFAULT_REMAININGLOGINATTEMPTS = -1;
    private static final String CERTIFICATESERIALNUMBER = "CERTIFICATESERIALNUMBER";
    private static final Object NAMECONSTRAINTS_PERMITTED = "nameconstraints_permitted";
    private static final Object NAMECONSTRAINTS_EXCLUDED = "nameconstraints_excluded";

    public ExtendedInformation() {
        this.setType(0);
        this.data.put(SUBJECTDIRATTRIBUTES, "");
        this.setMaxLoginAttempts(-1);
        this.setRemainingLoginAttempts(-1);
    }

    public String getSubjectDirectoryAttributes() {
        String ret = (String)this.data.get(SUBJECTDIRATTRIBUTES);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public void setSubjectDirectoryAttributes(String subjdirattr) {
        if (subjdirattr == null) {
            this.data.put(SUBJECTDIRATTRIBUTES, "");
        } else {
            this.data.put(SUBJECTDIRATTRIBUTES, subjdirattr);
        }
    }

    public int getRemainingLoginAttempts() {
        return (Integer)this.data.get(REMAININGLOGINATTEMPTS);
    }

    public void setRemainingLoginAttempts(int remainingLoginAttempts) {
        this.data.put(REMAININGLOGINATTEMPTS, remainingLoginAttempts);
    }

    public int getMaxLoginAttempts() {
        return (Integer)this.data.get(MAXFAILEDLOGINATTEMPTS);
    }

    public void setMaxLoginAttempts(int maxLoginAttempts) {
        this.data.put(MAXFAILEDLOGINATTEMPTS, maxLoginAttempts);
    }

    public BigInteger certificateSerialNumber() {
        String s = (String)this.data.get(CERTIFICATESERIALNUMBER);
        if (s == null) {
            return null;
        }
        return new BigInteger(Base64.decode((String)s));
    }

    public void setCertificateSerialNumber(BigInteger sn) {
        if (sn == null) {
            this.data.remove(CERTIFICATESERIALNUMBER);
            return;
        }
        String s = new String(Base64.encode((byte[])sn.toByteArray()));
        this.data.put(CERTIFICATESERIALNUMBER, s);
    }

    public int getIssuanceRevocationReason() {
        int ret = RevokedCertInfo.NOT_REVOKED;
        String revocationReason = this.getCustomData(CUSTOM_REVOCATIONREASON);
        if (revocationReason != null) {
            ret = Integer.valueOf(revocationReason);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User issuance revocation reason is " + ret));
        }
        return ret;
    }

    public void setIssuanceRevocationReason(int reason) {
        this.setCustomData(CUSTOM_REVOCATIONREASON, "" + reason);
    }

    public List<String> getNameConstraintsPermitted() {
        String value = (String)this.data.get(NAMECONSTRAINTS_PERMITTED);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(value.split(";")));
    }

    public void setNameConstraintsPermitted(List<String> encodedNames) {
        if (encodedNames == null) {
            this.data.remove(NAMECONSTRAINTS_PERMITTED);
        } else {
            this.data.put(NAMECONSTRAINTS_PERMITTED, StringUtils.join(encodedNames, (char)';'));
        }
    }

    public List<String> getNameConstraintsExcluded() {
        String value = (String)this.data.get(NAMECONSTRAINTS_EXCLUDED);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(value.split(";")));
    }

    public void setNameConstraintsExcluded(List<String> encodedNames) {
        if (encodedNames == null) {
            this.data.remove(NAMECONSTRAINTS_EXCLUDED);
        } else {
            this.data.put(NAMECONSTRAINTS_EXCLUDED, StringUtils.join(encodedNames, (char)';'));
        }
    }

    public String getRawSubjectDn() {
        String value = (String)this.data.get(RAWSUBJECTDN);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    public String getMapData(String key) {
        String ret = null;
        Object o = this.data.get(key);
        if (o instanceof String) {
            ret = (String)o;
        }
        return ret;
    }

    public void setMapData(String key, String value) {
        this.data.put(key, value);
    }

    public String getCustomData(String key) {
        String retval = (String)this.data.get(CUSTOMDATA + key);
        return retval;
    }

    public void setExtensionData(String key, String value) {
        this.data.put(EXTENSIONDATA + key, value);
    }

    public String getExtensionData(String key) {
        String retval = (String)this.data.get(EXTENSIONDATA + key);
        return retval;
    }

    public void setCustomData(String key, String value) {
        this.data.put(CUSTOMDATA + key, value);
    }

    public void setData(Object hmData) {
        this.loadData(hmData);
    }

    public Object getData() {
        return this.saveData();
    }

    @Override
    public float getLatestVersion() {
        return 4.0f;
    }

    @Override
    public void upgrade() {
        if (Float.compare(4.0f, this.getVersion()) != 0) {
            String msg = intres.getLocalizedMessage("endentity.extendedinfoupgrade", new Float(this.getVersion()));
            log.info((Object)msg);
            if (this.data.get(SUBJECTDIRATTRIBUTES) == null) {
                this.data.put(SUBJECTDIRATTRIBUTES, "");
            }
            if (this.data.get(MAXFAILEDLOGINATTEMPTS) == null) {
                this.setMaxLoginAttempts(-1);
            }
            if (this.data.get(REMAININGLOGINATTEMPTS) == null) {
                this.setRemainingLoginAttempts(-1);
            }
            if (this.getVersion() < 3.0f) {
                DateFormat oldDateFormat = DateFormat.getDateTimeInstance(2, 3, Locale.US);
                FastDateFormat newDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm");
                try {
                    String oldCustomStartTime = this.getCustomData(CUSTOM_STARTTIME);
                    if (!this.isEmptyOrRelative(oldCustomStartTime)) {
                        String newCustomStartTime = newDateFormat.format(oldDateFormat.parse(oldCustomStartTime));
                        this.setCustomData(CUSTOM_STARTTIME, newCustomStartTime);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Upgraded STARTTIME from \"" + oldCustomStartTime + "\" to \"" + newCustomStartTime + "\" in ExtendedInformation."));
                        }
                    }
                }
                catch (ParseException e) {
                    log.error((Object)"Unable to upgrade STARTTIME in extended user information.", (Throwable)e);
                }
                try {
                    String oldCustomEndTime = this.getCustomData(CUSTOM_ENDTIME);
                    if (!this.isEmptyOrRelative(oldCustomEndTime)) {
                        String newCustomEndTime = newDateFormat.format(oldDateFormat.parse(oldCustomEndTime));
                        this.setCustomData(CUSTOM_ENDTIME, newCustomEndTime);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Upgraded ENDTIME from \"" + oldCustomEndTime + "\" to \"" + newCustomEndTime + "\" in ExtendedInformation."));
                        }
                    }
                }
                catch (ParseException e) {
                    log.error((Object)"Unable to upgrade ENDTIME in extended user information.", (Throwable)e);
                }
            }
            if (this.getVersion() < 4.0f) {
                String oldEndTime;
                String[] timePatterns = new String[]{"yyyy-MM-dd HH:mm"};
                String oldStartTime = this.getCustomData(CUSTOM_STARTTIME);
                if (!this.isEmptyOrRelative(oldStartTime)) {
                    try {
                        String newStartTime = ValidityDate.formatAsUTC(DateUtils.parseDateStrictly((String)oldStartTime, (String[])timePatterns));
                        this.setCustomData(CUSTOM_STARTTIME, newStartTime);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Upgraded STARTTIME from \"" + oldStartTime + "\" to \"" + newStartTime + "\" in EndEntityProfile."));
                        }
                    }
                    catch (ParseException e) {
                        log.error((Object)"Unable to upgrade STARTTIME to UTC in EndEntityProfile! Manual interaction is required (edit and verify).", (Throwable)e);
                    }
                }
                if (!this.isEmptyOrRelative(oldEndTime = this.getCustomData(CUSTOM_ENDTIME))) {
                    try {
                        String newEndTime = ValidityDate.formatAsUTC(DateUtils.parseDateStrictly((String)oldEndTime, (String[])timePatterns));
                        this.setCustomData(CUSTOM_ENDTIME, newEndTime);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Upgraded ENDTIME from \"" + oldEndTime + "\" to \"" + newEndTime + "\" in EndEntityProfile."));
                        }
                    }
                    catch (ParseException e) {
                        log.error((Object)"Unable to upgrade ENDTIME to UTC in EndEntityProfile! Manual interaction is required (edit and verify).", (Throwable)e);
                    }
                }
            }
            this.data.put("version", Float.valueOf(4.0f));
        }
    }

    private boolean isEmptyOrRelative(String time) {
        return time == null || time.length() == 0 || time.matches("^\\d+:\\d?\\d:\\d?\\d$");
    }

    public int getType() {
        return (Integer)this.data.get(TYPE);
    }

    private void setType(int type) {
        this.data.put(TYPE, type);
    }
}

