/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ocsp.cache;

import java.util.HashMap;
import java.util.Properties;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.config.GlobalOcspConfiguration;
import org.cesecore.configuration.ConfigurationBase;
import org.cesecore.configuration.ConfigurationCache;

public final class GlobalOcspConfigurationCache
implements ConfigurationCache {
    private volatile GlobalOcspConfiguration ocspConfigurationCache = null;
    private volatile long lastupdatetime = -1L;

    @Override
    public boolean needsUpdate() {
        return this.ocspConfigurationCache == null || this.lastupdatetime + CesecoreConfiguration.getCacheGlobalOcspConfigurationTime() <= System.currentTimeMillis();
    }

    @Override
    public void clearCache() {
        this.ocspConfigurationCache = null;
    }

    @Override
    public String getConfigId() {
        return "OCSP";
    }

    @Override
    public void saveData() {
        this.ocspConfigurationCache.saveData();
    }

    @Override
    public ConfigurationBase getConfiguration() {
        return this.ocspConfigurationCache;
    }

    @Override
    public ConfigurationBase getConfiguration(HashMap data) {
        GlobalOcspConfiguration returnval = new GlobalOcspConfiguration();
        returnval.loadData(data);
        return returnval;
    }

    @Override
    public void updateConfiguration(ConfigurationBase configuration) {
        this.ocspConfigurationCache = (GlobalOcspConfiguration)configuration;
        this.lastupdatetime = System.currentTimeMillis();
    }

    @Override
    public ConfigurationBase getNewConfiguration() {
        return new GlobalOcspConfiguration();
    }

    @Override
    public Properties getAllProperties() {
        throw new UnsupportedOperationException("Not implemented for OCSP cache");
    }
}

