/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ocsp.cache;

import java.util.regex.Pattern;
import org.cesecore.config.OcspConfiguration;
import org.cesecore.keybind.impl.OcspKeyBinding;

public enum OcspConfigurationCache {
    INSTANCE;

    private boolean nonExistingIsGood;
    private boolean nonExistingIsRevoked;
    private Pattern nonExistingIsGoodOverideRegex;
    private Pattern nonExistingIsBadOverideRegex;
    private Pattern nonExistingIsRevokedOverideRegex;

    private OcspConfigurationCache() {
        this.reloadConfiguration();
    }

    public void reloadConfiguration() {
        this.nonExistingIsGood = OcspConfiguration.getNonExistingIsGood();
        this.nonExistingIsRevoked = OcspConfiguration.getNonExistingIsRevoked();
        String value = OcspConfiguration.getNonExistingIsGoodOverideRegex();
        this.nonExistingIsGoodOverideRegex = value != null ? Pattern.compile(value) : null;
        value = OcspConfiguration.getNonExistingIsBadOverideRegex();
        this.nonExistingIsBadOverideRegex = value != null ? Pattern.compile(value) : null;
        value = OcspConfiguration.getNonExistingIsRevokedOverideRegex();
        this.nonExistingIsRevokedOverideRegex = value != null ? Pattern.compile(value) : null;
    }

    public boolean isNonExistingGood(StringBuffer url, OcspKeyBinding ocspKeyBinding) {
        boolean nonExistingIsGood = this.nonExistingIsGood;
        if (ocspKeyBinding != null) {
            nonExistingIsGood = ocspKeyBinding.getNonExistingGood();
        }
        if (nonExistingIsGood) {
            return !this.isRegexFulFilled(url, this.nonExistingIsBadOverideRegex);
        }
        return this.isRegexFulFilled(url, this.nonExistingIsGoodOverideRegex);
    }

    public boolean isNonExistingRevoked(StringBuffer url, OcspKeyBinding ocspKeyBinding) {
        boolean nonExistingIsRevoked = this.nonExistingIsRevoked;
        if (ocspKeyBinding != null) {
            nonExistingIsRevoked = ocspKeyBinding.getNonExistingRevoked();
        }
        if (nonExistingIsRevoked) {
            return !this.isRegexFulFilled(url, this.nonExistingIsBadOverideRegex);
        }
        return this.isRegexFulFilled(url, this.nonExistingIsRevokedOverideRegex);
    }

    private boolean isRegexFulFilled(StringBuffer target, Pattern pattern) {
        if (pattern == null || target == null) {
            return false;
        }
        return pattern.matcher(target.toString()).matches();
    }
}

