/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ocsp.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cesecore.certificates.ocsp.extension.OCSPExtension;
import org.cesecore.config.OcspConfiguration;

public enum OcspExtensionsCache {
    INSTANCE;

    private static final Logger log;
    private Map<String, OCSPExtension> extensionMap;

    private OcspExtensionsCache() {
        this.reloadCache(OcspExtensionsCache.buildExtensionsMap());
    }

    public Map<String, OCSPExtension> getExtensions() {
        return this.extensionMap;
    }

    private void reloadCache(Map<String, OCSPExtension> newExtensionMap) {
        this.extensionMap = newExtensionMap;
    }

    public void reloadCache() {
        this.reloadCache(OcspExtensionsCache.buildExtensionsMap());
    }

    private static Map<String, OCSPExtension> buildExtensionsMap() {
        HashMap<String, OCSPExtension> result = new HashMap<String, OCSPExtension>();
        Iterator<String> extensionClasses = OcspConfiguration.getExtensionClasses().iterator();
        Iterator<String> extensionOids = OcspConfiguration.getExtensionOids().iterator();
        while (extensionClasses.hasNext()) {
            String clazz = extensionClasses.next();
            String oid = extensionOids.next();
            if (oid.startsWith("*")) {
                oid = oid.substring(1, oid.length());
            }
            OCSPExtension ext = null;
            try {
                ext = (OCSPExtension)Class.forName(clazz).newInstance();
                ext.init();
            }
            catch (Exception e) {
                log.error((Object)("Can not create extension with class " + clazz), (Throwable)e);
                continue;
            }
            result.put(oid, ext);
        }
        return result;
    }

    static {
        log = Logger.getLogger(OcspExtensionsCache.class);
    }
}

