/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ocsp.cache;

import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.jcajce.JcaCertificateID;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.cesecore.certificates.ocsp.cache.OcspSigningCacheEntry;
import org.cesecore.certificates.ocsp.exception.OcspFailureException;
import org.cesecore.util.CertTools;

public enum OcspSigningCache {
    INSTANCE;

    private Map<Integer, OcspSigningCacheEntry> cache = new HashMap<Integer, OcspSigningCacheEntry>();
    private Map<Integer, OcspSigningCacheEntry> staging = new HashMap<Integer, OcspSigningCacheEntry>();
    private OcspSigningCacheEntry defaultResponderCacheEntry = null;
    private final ReentrantLock lock = new ReentrantLock(false);
    private static final Logger log;
    private boolean logDefaultHasRunOnce = false;

    public OcspSigningCacheEntry getEntry(CertificateID certID) {
        return this.cache.get(OcspSigningCache.getCacheIdFromCertificateID(certID));
    }

    public OcspSigningCacheEntry getDefaultEntry() {
        return this.defaultResponderCacheEntry;
    }

    public Collection<OcspSigningCacheEntry> getEntries() {
        return this.cache.values();
    }

    public void stagingStart() {
        this.lock.lock();
        this.staging = new HashMap<Integer, OcspSigningCacheEntry>();
    }

    public void stagingAdd(OcspSigningCacheEntry ocspSigningCacheEntry) {
        List<CertificateID> certIDs = ocspSigningCacheEntry.getCertificateID();
        for (CertificateID certID : certIDs) {
            this.staging.put(OcspSigningCache.getCacheIdFromCertificateID(certID), ocspSigningCacheEntry);
        }
    }

    public void stagingCommit(String defaultResponderSubjectDn) {
        OcspSigningCacheEntry entry;
        OcspSigningCacheEntry defaultResponderCacheEntry = null;
        for (OcspSigningCacheEntry entry2 : this.staging.values()) {
            X509Certificate signingCertificate;
            if (entry2.getOcspSigningCertificate() != null) {
                signingCertificate = entry2.getOcspSigningCertificate();
                if (!CertTools.getIssuerDN(signingCertificate).equals(defaultResponderSubjectDn)) continue;
                defaultResponderCacheEntry = entry2;
                break;
            }
            if (entry2.getCaCertificateChain() == null || entry2.getCaCertificateChain().isEmpty() || !CertTools.getSubjectDN(signingCertificate = entry2.getCaCertificateChain().get(0)).equals(defaultResponderSubjectDn)) continue;
            defaultResponderCacheEntry = entry2;
            break;
        }
        HashMap<Integer, OcspSigningCacheEntry> modifiedEntries = new HashMap<Integer, OcspSigningCacheEntry>();
        ArrayList<Integer> removedEntries = new ArrayList<Integer>();
        for (Integer key : this.staging.keySet()) {
            entry = this.staging.get(key);
            if (!entry.isPlaceholder()) continue;
            if (defaultResponderCacheEntry != null) {
                entry = new OcspSigningCacheEntry(entry.getIssuerCaCertificate(), entry.getIssuerCaCertificateStatus(), defaultResponderCacheEntry.getCaCertificateChain(), defaultResponderCacheEntry.getOcspSigningCertificate(), defaultResponderCacheEntry.getPrivateKey(), defaultResponderCacheEntry.getSignatureProviderName(), defaultResponderCacheEntry.getOcspKeyBinding(), defaultResponderCacheEntry.getResponderIdType());
                modifiedEntries.put(key, entry);
                continue;
            }
            removedEntries.add(key);
        }
        this.staging.putAll(modifiedEntries);
        for (Integer removedKey : removedEntries) {
            this.staging.remove(removedKey);
        }
        this.logDefaultResponderChanges(this.defaultResponderCacheEntry, defaultResponderCacheEntry, defaultResponderSubjectDn);
        this.cache = this.staging;
        this.defaultResponderCacheEntry = defaultResponderCacheEntry;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Committing the following to OCSP cache:");
            for (Integer key : this.staging.keySet()) {
                entry = this.staging.get(key);
                log.debug((Object)(" KeyBindingId: " + key + ", SubjectDN '" + CertTools.getSubjectDN(entry.getFullCertificateChain().get(0)) + "', IssuerDN '" + CertTools.getIssuerDN(entry.getFullCertificateChain().get(0)) + "', SerialNumber " + entry.getFullCertificateChain().get(0).getSerialNumber().toString() + "/" + entry.getFullCertificateChain().get(0).getSerialNumber().toString(16)));
                if (entry.getOcspKeyBinding() == null) continue;
                log.debug((Object)("   keyPairAlias: " + entry.getOcspKeyBinding().getKeyPairAlias()));
            }
        }
    }

    public void stagingRelease() {
        this.lock.unlock();
    }

    private void logDefaultResponderChanges(OcspSigningCacheEntry currentEntry, OcspSigningCacheEntry stagedEntry, String defaultResponderSubjectDn) {
        String msg = null;
        if (!(stagedEntry != null || currentEntry == null && this.logDefaultHasRunOnce)) {
            msg = StringUtils.isEmpty((String)defaultResponderSubjectDn) ? "No default responder was defined." : "The default OCSP responder with subject '" + defaultResponderSubjectDn + "' was not found.";
            msg = msg + " OCSP requests for certificates issued by unknown CAs will return \"unauthorized\" as per RFC6960, Section 2.3";
        } else if (stagedEntry != null && currentEntry == null) {
            msg = stagedEntry.isUsingSeparateOcspSigningCertificate() ? "Setting keybinding with ID" + stagedEntry.getOcspKeyBinding().getId() + " and DN " + defaultResponderSubjectDn + " as default OCSP responder." : "Setting CA with DN " + defaultResponderSubjectDn + " as default OCSP responder.";
        } else if (stagedEntry != null && currentEntry != null) {
            if (stagedEntry.isUsingSeparateOcspSigningCertificate() != currentEntry.isUsingSeparateOcspSigningCertificate() || !CertTools.getSubjectDN(stagedEntry.getIssuerCaCertificate()).equals(CertTools.getSubjectDN(currentEntry.getIssuerCaCertificate()))) {
                msg = stagedEntry.isUsingSeparateOcspSigningCertificate() ? "Setting keybinding with ID" + stagedEntry.getOcspKeyBinding().getId() + " and DN " + defaultResponderSubjectDn + " as default OCSP responder." : "Setting CA with DN " + defaultResponderSubjectDn + " as default OCSP responder.";
            } else if (stagedEntry.isUsingSeparateOcspSigningCertificate() && stagedEntry.getOcspKeyBinding().getId() != currentEntry.getOcspKeyBinding().getId()) {
                msg = "Setting keybinding with ID" + stagedEntry.getOcspKeyBinding().getId() + " and DN " + defaultResponderSubjectDn + " as default OCSP responder.";
            }
        }
        if (msg == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No change in default responder.");
            }
        } else {
            log.info((Object)msg);
        }
        this.logDefaultHasRunOnce = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingleEntry(OcspSigningCacheEntry ocspSigningCacheEntry) {
        List<CertificateID> certIDs = ocspSigningCacheEntry.getCertificateID();
        for (CertificateID certID : certIDs) {
            int cacheId = OcspSigningCache.getCacheIdFromCertificateID(certID);
            this.lock.lock();
            try {
                if (this.cache.containsKey(cacheId)) continue;
                this.cache.put(cacheId, ocspSigningCacheEntry);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static int getCacheIdFromCertificateID(CertificateID certID) {
        int result = new BigInteger(certID.getIssuerNameHash()).hashCode() ^ new BigInteger(certID.getIssuerKeyHash()).hashCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using getIssuerNameHash " + new BigInteger(certID.getIssuerNameHash()).toString(16) + " and getIssuerKeyHash " + new BigInteger(certID.getIssuerKeyHash()).toString(16) + " to produce id " + result));
        }
        return result;
    }

    public static List<CertificateID> getCertificateIDFromCertificate(X509Certificate certificate) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Building CertificateId's from certificate with subjectDN '" + CertTools.getSubjectDN(certificate) + "'."));
            }
            ArrayList<CertificateID> ret = new ArrayList<CertificateID>();
            ret.add((CertificateID)new JcaCertificateID(new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1)), certificate, certificate.getSerialNumber()));
            ret.add((CertificateID)new JcaCertificateID(new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)), certificate, certificate.getSerialNumber()));
            return ret;
        }
        catch (OCSPException e) {
            throw new OcspFailureException(e);
        }
        catch (CertificateEncodingException e) {
            throw new OcspFailureException(e);
        }
        catch (OperatorCreationException e) {
            throw new OcspFailureException(e);
        }
    }

    static {
        log = Logger.getLogger(OcspSigningCache.class);
    }
}

