/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ocsp.cache;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.jcajce.JcaRespID;
import org.bouncycastle.operator.DigestCalculator;
import org.cesecore.certificates.certificate.CertificateStatus;
import org.cesecore.certificates.ocsp.SHA1DigestCalculator;
import org.cesecore.certificates.ocsp.cache.OcspSigningCache;
import org.cesecore.config.OcspConfiguration;
import org.cesecore.keybind.impl.OcspKeyBinding;
import org.cesecore.util.CertTools;

public class OcspSigningCacheEntry {
    private static final Logger log = Logger.getLogger(OcspSigningCacheEntry.class);
    private final List<CertificateID> certificateID;
    private final List<X509Certificate> caCertificateChain;
    private final X509Certificate ocspSigningCertificate;
    private final List<X509Certificate> fullCertificateChain;
    private final X509Certificate signingCertificate;
    private final transient PrivateKey privateKey;
    private final String signatureProviderName;
    private final OcspKeyBinding ocspKeyBinding;
    private final X509Certificate issuerCaCertificate;
    private final CertificateStatus issuerCaCertificateStatus;
    private boolean responseSignatureVerified = false;
    private final int responderIdType;
    private RespID respId;
    private final X509Certificate[] responseCertChain;
    private final boolean signingCertificateForOcspSigning;

    public OcspSigningCacheEntry(X509Certificate issuerCaCertificate, CertificateStatus issuerCaCertificateStatus, List<X509Certificate> signingCaCertificateChain, X509Certificate ocspSigningCertificate, PrivateKey privateKey, String signatureProviderName, OcspKeyBinding ocspKeyBinding, int responderIdType) {
        this.caCertificateChain = signingCaCertificateChain;
        this.ocspSigningCertificate = ocspSigningCertificate;
        if (ocspSigningCertificate == null) {
            this.fullCertificateChain = signingCaCertificateChain;
        } else {
            this.fullCertificateChain = new ArrayList<X509Certificate>();
            this.fullCertificateChain.add(ocspSigningCertificate);
            this.fullCertificateChain.addAll(signingCaCertificateChain);
        }
        this.signingCertificate = this.fullCertificateChain == null ? null : this.fullCertificateChain.get(0);
        this.privateKey = privateKey;
        this.signatureProviderName = signatureProviderName;
        this.ocspKeyBinding = ocspKeyBinding;
        this.issuerCaCertificate = issuerCaCertificate;
        this.certificateID = OcspSigningCache.getCertificateIDFromCertificate(issuerCaCertificate);
        this.issuerCaCertificateStatus = issuerCaCertificateStatus;
        this.responderIdType = responderIdType;
        if (this.signingCertificate == null) {
            this.respId = null;
            this.signingCertificateForOcspSigning = true;
        } else {
            if (responderIdType == 1) {
                this.respId = new JcaRespID(this.signingCertificate.getSubjectX500Principal());
            } else {
                try {
                    this.respId = new JcaRespID(this.signingCertificate.getPublicKey(), (DigestCalculator)SHA1DigestCalculator.buildSha1Instance());
                }
                catch (OCSPException e) {
                    log.warn((Object)"Unable to contruct responder Id of type 'hash', falling back to using 'name' as responder Id.", (Throwable)e);
                    this.respId = new JcaRespID(this.signingCertificate.getSubjectX500Principal());
                }
            }
            this.signingCertificateForOcspSigning = ocspSigningCertificate == null ? true : CertTools.isOCSPCert(this.signingCertificate);
        }
        this.responseCertChain = this.fullCertificateChain == null ? null : this.getResponseCertChain(this.fullCertificateChain.toArray(new X509Certificate[0]));
    }

    public X509Certificate getIssuerCaCertificate() {
        return this.issuerCaCertificate;
    }

    public List<CertificateID> getCertificateID() {
        return this.certificateID;
    }

    public CertificateStatus getIssuerCaCertificateStatus() {
        return this.issuerCaCertificateStatus;
    }

    public List<X509Certificate> getCaCertificateChain() {
        return this.caCertificateChain;
    }

    public X509Certificate getOcspSigningCertificate() {
        return this.ocspSigningCertificate;
    }

    public List<X509Certificate> getFullCertificateChain() {
        return this.fullCertificateChain;
    }

    public X509Certificate getSigningCertificate() {
        return this.signingCertificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getSignatureProviderName() {
        return this.signatureProviderName;
    }

    public OcspKeyBinding getOcspKeyBinding() {
        return this.ocspKeyBinding;
    }

    public int getResponderIdType() {
        return this.responderIdType;
    }

    public RespID getRespId() {
        return this.respId;
    }

    public X509Certificate[] getResponseCertChain() {
        return this.responseCertChain;
    }

    public boolean isUsingSeparateOcspSigningCertificate() {
        return this.ocspSigningCertificate != null;
    }

    public boolean isSigningCertificateForOcspSigning() {
        return this.signingCertificateForOcspSigning;
    }

    public boolean isPlaceholder() {
        return this.privateKey == null;
    }

    public boolean checkResponseSignatureVerified() {
        if (this.responseSignatureVerified) {
            return true;
        }
        this.responseSignatureVerified = true;
        return false;
    }

    private X509Certificate[] getResponseCertChain(X509Certificate[] certChain) {
        X509Certificate[] chain;
        boolean includeSignCert = OcspConfiguration.getIncludeSignCert();
        boolean includeChain = OcspConfiguration.getIncludeCertChain();
        if (this.isUsingSeparateOcspSigningCertificate()) {
            includeSignCert = this.getOcspKeyBinding().getIncludeSignCert();
            includeChain = this.getOcspKeyBinding().getIncludeCertChain();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Include signing cert: " + includeSignCert));
            log.debug((Object)("Include chain: " + includeChain));
        }
        if (includeSignCert) {
            if (includeChain) {
                if (certChain.length > 1) {
                    chain = new X509Certificate[certChain.length - 1];
                    for (int i = 0; i < chain.length; ++i) {
                        chain[i] = certChain[i];
                    }
                } else {
                    chain = certChain;
                }
            } else {
                chain = new X509Certificate[]{certChain[0]};
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"OCSP signing certificate is not included in the response");
            }
            chain = new X509Certificate[]{};
        }
        return chain;
    }
}

