/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.ocsp.logging;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public abstract class PatternLogger
implements Serializable {
    private static final long serialVersionUID = 8486004615125959046L;
    public static final String LOG_TIME = "LOG_TIME";
    public static final String LOG_ID = "LOG_ID";
    public static final String SESSION_ID = "SESSION_ID";
    public static final String REPLY_TIME = "REPLY_TIME";
    public static final String ISSUER_NAME_HASH = "ISSUER_NAME_HASH";
    public static final String ISSUER_KEY = "ISSUER_KEY";
    public static final String SERIAL_NOHEX = "SERIAL_NOHEX";
    public static final String CLIENT_IP = "CLIENT_IP";
    public static final String STATUS = "STATUS";
    public static final String PROCESS_TIME = "PROCESS_TIME";
    private final Map<String, String> valuepairs = new HashMap<String, String>();
    private final String matchString;
    private final String matchPattern;
    private transient Matcher m;
    private final String orderString;
    private final Date startTime;
    private Date startProcessTime = null;
    private boolean doLogging;
    private final Class<?> loggerClass;
    private transient Logger logger;
    private transient StringWriter sw;
    private transient PrintWriter pw;

    protected PatternLogger(boolean doLogging, Class<?> loggerClass, String matchPattern, String matchString, String logDateFormat, String timeZone) {
        this.doLogging = doLogging;
        this.matchString = matchString;
        this.matchPattern = matchPattern;
        this.orderString = matchString;
        this.loggerClass = loggerClass;
        this.startTime = new Date();
        FastDateFormat dateformat = timeZone == null ? FastDateFormat.getInstance((String)logDateFormat) : FastDateFormat.getInstance((String)logDateFormat, (TimeZone)TimeZone.getTimeZone(timeZone));
        this.paramPut(LOG_TIME, dateformat.format(new Date()));
        this.paramPut(REPLY_TIME, REPLY_TIME);
        this.paramPut(LOG_ID, "0");
    }

    private Matcher getMatcher() {
        if (this.m == null) {
            this.m = Pattern.compile(this.matchPattern).matcher(this.matchString);
        }
        return this.m;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.loggerClass);
        }
        return this.logger;
    }

    private PrintWriter getPrintWriter() {
        if (this.pw == null) {
            this.sw = new StringWriter();
            this.pw = new PrintWriter(this.sw);
        }
        return this.pw;
    }

    private String interpolate() {
        StringBuffer sb = new StringBuffer(this.orderString.length());
        Matcher matcher = this.getMatcher();
        matcher.reset();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = this.valuepairs.get(key);
            if (value != null) {
                matcher.appendReplacement(sb, value);
                continue;
            }
            matcher.appendReplacement(sb, "");
            String unknown = matcher.group(0);
            sb.append(unknown);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void paramPut(String key, byte[] value) {
        this.paramPut(key, new String(Hex.encode((byte[])value)));
    }

    public void paramPut(String key, String value) {
        if (value == null) {
            this.valuepairs.put(key, "");
        } else {
            this.valuepairs.put(key, value);
        }
        if (StringUtils.equals((String)key, (String)PROCESS_TIME)) {
            this.startProcessTime = new Date();
        }
    }

    public void paramPut(String key, Integer value) {
        if (value == null) {
            this.valuepairs.put(key, "");
        } else {
            this.valuepairs.put(key, value.toString());
        }
    }

    public void writeln() {
        if (this.doLogging) {
            this.getPrintWriter().println(this.interpolate());
        }
    }

    public void flush() {
        if (this.doLogging) {
            this.getPrintWriter().flush();
            String output = this.sw.toString();
            output = output.replaceAll(REPLY_TIME, String.valueOf(new Date().getTime() - this.startTime.getTime()));
            if (this.startProcessTime != null) {
                output = output.replaceAll(PROCESS_TIME, String.valueOf(new Date().getTime() - this.startProcessTime.getTime()));
            }
            if (output.endsWith(System.getProperty("line.separator"))) {
                output = output.substring(0, output.length() - 1);
            }
            this.getLogger().debug((Object)output);
        }
    }

    public boolean isEnabled() {
        return this.doLogging;
    }
}

