/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.util;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.cesecore.config.CesecoreConfiguration;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CardVerifiableCertificate;
import org.ejbca.cvc.OIDField;

public abstract class AlgorithmTools {
    private static final Logger log = Logger.getLogger(AlgorithmTools.class);
    public static final String KEYSPEC_UNKNOWN = "unknown";
    private static final Collection<String> SIG_ALGS_RSA = new LinkedList<String>();
    private static final Collection<String> SIG_ALGS_DSA;
    private static final Collection<String> SIG_ALGS_ECDSA;
    private static final Collection<String> SIG_ALGS_ECGOST3410;
    private static final Collection<String> SIG_ALGS_DSTU4145;

    public static String getSigningAlgFromAlgSelection(String sigalgs, PublicKey pk) {
        String sigAlg = null;
        String[] algs = StringUtils.split((String)sigalgs, (char)';');
        for (int i = 0; i < algs.length; ++i) {
            if (!AlgorithmTools.isCompatibleSigAlg(pk, algs[i])) continue;
            sigAlg = algs[i];
            break;
        }
        log.debug((Object)("Using signature algorithm for response: " + sigAlg));
        return sigAlg;
    }

    public static String getKeyAlgorithm(PublicKey publickey) {
        String keyAlg = null;
        if (publickey instanceof RSAPublicKey) {
            keyAlg = "RSA";
        } else if (publickey instanceof DSAPublicKey) {
            keyAlg = "DSA";
        } else if (publickey instanceof ECPublicKey) {
            String algo = publickey.getAlgorithm();
            keyAlg = StringUtils.equals((String)algo, (String)"ECGOST3410") ? "ECGOST3410" : (StringUtils.equals((String)algo, (String)"DSTU4145") ? "DSTU4145" : "ECDSA");
        }
        return keyAlg;
    }

    public static Collection<String> getSignatureAlgorithms(PublicKey publickey) {
        String algo;
        Collection<String> ret = publickey instanceof RSAPublicKey ? SIG_ALGS_RSA : (publickey instanceof DSAPublicKey ? SIG_ALGS_DSA : (publickey instanceof ECPublicKey ? (StringUtils.equals((String)(algo = publickey.getAlgorithm()), (String)"ECGOST3410") ? SIG_ALGS_ECGOST3410 : (StringUtils.equals((String)algo, (String)"DSTU4145") ? SIG_ALGS_DSTU4145 : SIG_ALGS_ECDSA)) : Collections.emptyList()));
        return ret;
    }

    public static String getKeyAlgorithmFromSigAlg(String signatureAlgorithm) {
        String ret = signatureAlgorithm.contains("ECDSA") ? "ECDSA" : (signatureAlgorithm.contains("GOST3410") ? "ECGOST3410" : (signatureAlgorithm.contains("DSTU4145") ? "DSTU4145" : (signatureAlgorithm.contains("DSA") ? "DSA" : "RSA")));
        return ret;
    }

    public static String getKeySpecification(PublicKey publicKey) {
        if (log.isTraceEnabled()) {
            log.trace((Object)">getKeySpecification");
        }
        String keyspec = null;
        if (publicKey instanceof RSAPublicKey) {
            keyspec = Integer.toString(((RSAPublicKey)publicKey).getModulus().bitLength());
        } else if (publicKey instanceof DSAPublicKey) {
            keyspec = Integer.toString(((DSAPublicKey)publicKey).getParams().getP().bitLength());
        } else if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            if (ecPublicKey.getParams() instanceof ECNamedCurveSpec) {
                keyspec = ((ECNamedCurveSpec)ecPublicKey.getParams()).getName();
                for (String keySpecAlias : AlgorithmTools.getEcKeySpecAliases(keyspec)) {
                    if (!AlgorithmTools.isNamedECKnownInDefaultProvider(keySpecAlias)) continue;
                    keyspec = keySpecAlias;
                    break;
                }
            } else {
                keyspec = KEYSPEC_UNKNOWN;
                ECParameterSpec namedCurve = ecPublicKey.getParams();
                if (namedCurve != null) {
                    int c1 = namedCurve.getCofactor();
                    EllipticCurve ec1 = namedCurve.getCurve();
                    BigInteger a1 = ec1.getA();
                    BigInteger b1 = ec1.getB();
                    int fs1 = ec1.getField().getFieldSize();
                    ECPoint g1 = namedCurve.getGenerator();
                    BigInteger ax1 = g1.getAffineX();
                    BigInteger ay1 = g1.getAffineY();
                    BigInteger o1 = namedCurve.getOrder();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("a1=" + a1 + " b1=" + b1 + " fs1=" + fs1 + " ax1=" + ax1 + " ay1=" + ay1 + " o1=" + o1 + " c1=" + c1));
                    }
                    Enumeration ecNamedCurves = org.bouncycastle.jce.ECNamedCurveTable.getNames();
                    while (ecNamedCurves.hasMoreElements()) {
                        String ecNamedCurveBc = (String)ecNamedCurves.nextElement();
                        ECNamedCurveParameterSpec parameterSpec2 = org.bouncycastle.jce.ECNamedCurveTable.getParameterSpec((String)ecNamedCurveBc);
                        ECCurve ec2 = parameterSpec2.getCurve();
                        BigInteger a2 = ec2.getA().toBigInteger();
                        BigInteger b2 = ec2.getB().toBigInteger();
                        int fs2 = ec2.getFieldSize();
                        org.bouncycastle.math.ec.ECPoint g2 = parameterSpec2.getG();
                        BigInteger ax2 = g2.getAffineXCoord().toBigInteger();
                        BigInteger ay2 = g2.getAffineYCoord().toBigInteger();
                        BigInteger h2 = parameterSpec2.getH();
                        BigInteger n2 = parameterSpec2.getN();
                        if (!a1.equals(a2) || !ax1.equals(ax2) || !b1.equals(b2) || !ay1.equals(ay2) || fs1 != fs2 || !o1.equals(n2) || c1 != h2.intValue()) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("a2=" + a2 + " b2=" + b2 + " fs2=" + fs2 + " ax2=" + ax2 + " ay2=" + ay2 + " h2=" + h2 + " n2=" + n2 + " " + ecNamedCurveBc));
                        }
                        if (!AlgorithmTools.isNamedECKnownInDefaultProvider(ecNamedCurveBc)) continue;
                        keyspec = ecNamedCurveBc;
                        break;
                    }
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getKeySpecification: " + keyspec));
        }
        return keyspec;
    }

    public static boolean isNamedECKnownInDefaultProvider(String ecNamedCurveBc) {
        Provider[] providers = Security.getProviders("KeyPairGenerator.EC");
        String providerName = providers[0].getName();
        try {
            for (Provider ecProvider : providers) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found EC capable provider named: " + ecProvider.getName()));
                }
                if (!ecProvider.getName().startsWith("SunPKCS11-") || ecProvider.getName().startsWith("SunPKCS11-NSS")) continue;
                providerName = ecProvider.getName();
                break;
            }
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", providerName);
            kpg.initialize(new ECGenParameterSpec(AlgorithmTools.getEcKeySpecOidFromBcName(ecNamedCurveBc)));
            return true;
        }
        catch (InvalidAlgorithmParameterException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(ecNamedCurveBc + " is not available in provider " + providerName));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("EC capable provider " + providerName + " could no longer handle elliptic curve algorithm..", e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("EC capable provider " + providerName + " disappeard unexpectedly.", e);
        }
        return false;
    }

    public static String getEcKeySpecOidFromBcName(String ecNamedCurveBc) {
        ASN1ObjectIdentifier oid = ECNamedCurveTable.getOID((String)ecNamedCurveBc);
        if (oid == null) {
            return ecNamedCurveBc;
        }
        return oid.getId();
    }

    public static List<String> getEcKeySpecAliases(String namedEllipticCurve) {
        ECNamedCurveParameterSpec parameterSpec = org.bouncycastle.jce.ECNamedCurveTable.getParameterSpec((String)namedEllipticCurve);
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(namedEllipticCurve);
        if (parameterSpec != null) {
            Enumeration ecNamedCurves = org.bouncycastle.jce.ECNamedCurveTable.getNames();
            while (ecNamedCurves.hasMoreElements()) {
                ECNamedCurveParameterSpec parameterSpec2;
                String currentCurve = (String)ecNamedCurves.nextElement();
                if (namedEllipticCurve.equals(currentCurve) || !parameterSpec.equals((Object)(parameterSpec2 = org.bouncycastle.jce.ECNamedCurveTable.getParameterSpec((String)currentCurve)))) continue;
                ret.add(currentCurve);
            }
        }
        return ret;
    }

    public static String getEncSigAlgFromSigAlg(String signatureAlgorithm) {
        String encSigAlg = signatureAlgorithm;
        if (signatureAlgorithm.equals("SHA512withECDSA")) {
            encSigAlg = "SHA256WithRSA";
        } else if (signatureAlgorithm.equals("SHA384withECDSA")) {
            encSigAlg = "SHA256WithRSA";
        } else if (signatureAlgorithm.equals("SHA256withECDSA")) {
            encSigAlg = "SHA256WithRSA";
        } else if (signatureAlgorithm.equals("SHA224withECDSA")) {
            encSigAlg = "SHA256WithRSA";
        } else if (signatureAlgorithm.equals("SHA1withECDSA")) {
            encSigAlg = "SHA1WithRSA";
        } else if (signatureAlgorithm.equals("SHA1WithDSA")) {
            encSigAlg = "SHA1WithRSA";
        } else if (signatureAlgorithm.equals("GOST3411withECGOST3410")) {
            encSigAlg = "SHA1WithRSA";
        } else if (signatureAlgorithm.equals("GOST3411withDSTU4145")) {
            encSigAlg = "SHA1WithRSA";
        }
        return encSigAlg;
    }

    public static boolean isCompatibleSigAlg(PublicKey publicKey, String signatureAlgorithm) {
        String algname = publicKey.getAlgorithm();
        if (algname == null) {
            algname = "";
        }
        boolean isGost3410 = algname.contains("GOST3410");
        boolean isDstu4145 = algname.contains("DSTU4145");
        boolean isSpecialECC = isGost3410 || isDstu4145;
        boolean ret = false;
        if (StringUtils.contains((String)signatureAlgorithm, (String)"RSA")) {
            if (publicKey instanceof RSAPublicKey) {
                ret = true;
            }
        } else if (StringUtils.contains((String)signatureAlgorithm, (String)"ECDSA")) {
            if (publicKey instanceof ECPublicKey && !isSpecialECC) {
                ret = true;
            }
        } else if (StringUtils.contains((String)signatureAlgorithm, (String)"DSA")) {
            if (publicKey instanceof DSAPublicKey) {
                ret = true;
            }
        } else if (StringUtils.contains((String)signatureAlgorithm, (String)"ECGOST3410")) {
            if (publicKey instanceof ECPublicKey && isGost3410) {
                ret = true;
            }
        } else if (StringUtils.contains((String)signatureAlgorithm, (String)"DSTU4145") && publicKey instanceof ECPublicKey && isDstu4145) {
            ret = true;
        }
        return ret;
    }

    public static String getCertSignatureAlgorithmNameAsString(Certificate cert) {
        X509Certificate x509cert;
        String certSignatureAlgorithm = null;
        if (cert instanceof X509Certificate) {
            x509cert = (X509Certificate)cert;
            certSignatureAlgorithm = x509cert.getSigAlgName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("certSignatureAlgorithm is: " + certSignatureAlgorithm));
            }
        } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            try {
                CVCPublicKey cvcpk = cvccert.getCVCertificate().getCertificateBody().getPublicKey();
                OIDField oid = cvcpk.getObjectIdentifier();
                certSignatureAlgorithm = AlgorithmUtil.getAlgorithmName((OIDField)oid);
            }
            catch (NoSuchFieldException e) {
                log.error((Object)"NoSuchFieldException: ", (Throwable)e);
            }
        }
        if (certSignatureAlgorithm.equalsIgnoreCase("1.2.840.113549.1.1.10") && cert instanceof X509Certificate) {
            x509cert = (X509Certificate)cert;
            certSignatureAlgorithm = x509cert.getSigAlgName();
            byte[] params = x509cert.getSigAlgParams();
            certSignatureAlgorithm = params != null && params.length == 2 ? "SHA1withRSAandMGF1" : "SHA256withRSAandMGF1";
        }
        if (certSignatureAlgorithm.equalsIgnoreCase("1.2.840.10045.4.3.2")) {
            certSignatureAlgorithm = "SHA256withECDSA";
        }
        if (AlgorithmTools.isGost3410Enabled() && certSignatureAlgorithm.equalsIgnoreCase(CesecoreConfiguration.getOidGost3410())) {
            certSignatureAlgorithm = "GOST3411withECGOST3410";
        }
        if (AlgorithmTools.isDstu4145Enabled() && certSignatureAlgorithm.startsWith(CesecoreConfiguration.getOidDstu4145() + ".")) {
            certSignatureAlgorithm = "GOST3411withDSTU4145";
        }
        return certSignatureAlgorithm;
    }

    public static String getSignatureAlgorithm(Certificate cert) {
        String signatureAlgorithm = null;
        String certSignatureAlgorithm = AlgorithmTools.getCertSignatureAlgorithmNameAsString(cert);
        PublicKey publickey = cert.getPublicKey();
        if (publickey instanceof RSAPublicKey) {
            if (certSignatureAlgorithm.indexOf("MGF1") == -1) {
                if (certSignatureAlgorithm.indexOf("MD5") != -1) {
                    signatureAlgorithm = "MD5WithRSA";
                } else if (certSignatureAlgorithm.indexOf("SHA1") != -1) {
                    signatureAlgorithm = "SHA1WithRSA";
                } else if (certSignatureAlgorithm.indexOf("256") != -1) {
                    signatureAlgorithm = "SHA256WithRSA";
                } else if (certSignatureAlgorithm.indexOf("384") != -1) {
                    signatureAlgorithm = "SHA384WithRSA";
                } else if (certSignatureAlgorithm.indexOf("512") != -1) {
                    signatureAlgorithm = "SHA512WithRSA";
                }
            } else {
                signatureAlgorithm = certSignatureAlgorithm.indexOf("SHA1") != -1 ? "SHA1withRSAandMGF1" : "SHA256withRSAandMGF1";
            }
        } else if (publickey instanceof DSAPublicKey) {
            signatureAlgorithm = "SHA1WithDSA";
        } else if (certSignatureAlgorithm.indexOf("256") != -1) {
            signatureAlgorithm = "SHA256withECDSA";
        } else if (certSignatureAlgorithm.indexOf("224") != -1) {
            signatureAlgorithm = "SHA224withECDSA";
        } else if (certSignatureAlgorithm.indexOf("384") != -1) {
            signatureAlgorithm = "SHA384withECDSA";
        } else if (certSignatureAlgorithm.indexOf("512") != -1) {
            signatureAlgorithm = "SHA512withECDSA";
        } else if (certSignatureAlgorithm.indexOf("ECDSA") != -1) {
            signatureAlgorithm = "SHA1withECDSA";
        } else if (AlgorithmTools.isGost3410Enabled() && certSignatureAlgorithm.equalsIgnoreCase("GOST3411withECGOST3410")) {
            signatureAlgorithm = "GOST3411withECGOST3410";
        } else if (AlgorithmTools.isDstu4145Enabled() && certSignatureAlgorithm.equalsIgnoreCase("GOST3411withDSTU4145")) {
            signatureAlgorithm = "GOST3411withDSTU4145";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSignatureAlgorithm: " + signatureAlgorithm));
        }
        return signatureAlgorithm;
    }

    public static String getDigestFromSigAlg(String sigAlg) {
        if (sigAlg.toUpperCase().contains("GOST") || sigAlg.toUpperCase().contains("DSTU")) {
            return CMSSignedGenerator.DIGEST_GOST3411;
        }
        if (sigAlg.equals(X9ObjectIdentifiers.ecdsa_with_SHA1.getId()) || sigAlg.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            return CMSSignedGenerator.DIGEST_SHA1;
        }
        if (sigAlg.equals(X9ObjectIdentifiers.ecdsa_with_SHA224.getId()) || sigAlg.equals(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId())) {
            return CMSSignedGenerator.DIGEST_SHA224;
        }
        if (sigAlg.equals(X9ObjectIdentifiers.ecdsa_with_SHA256.getId()) || sigAlg.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            return CMSSignedGenerator.DIGEST_SHA256;
        }
        if (sigAlg.equals(X9ObjectIdentifiers.ecdsa_with_SHA384.getId()) || sigAlg.equals(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId())) {
            return CMSSignedGenerator.DIGEST_SHA384;
        }
        if (sigAlg.equals(X9ObjectIdentifiers.ecdsa_with_SHA512.getId()) || sigAlg.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId())) {
            return CMSSignedGenerator.DIGEST_SHA512;
        }
        if (sigAlg.equals(PKCSObjectIdentifiers.md5WithRSAEncryption.getId())) {
            return CMSSignedGenerator.DIGEST_MD5;
        }
        if (sigAlg.equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001.getId())) {
            return CMSSignedGenerator.DIGEST_GOST3411;
        }
        return CMSSignedGenerator.DIGEST_SHA1;
    }

    public static ASN1ObjectIdentifier getSignAlgOidFromDigestAndKey(String digestAlg, String keyAlg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">getSignAlg(" + digestAlg + "," + keyAlg + ")"));
        }
        ASN1ObjectIdentifier oid = PKCSObjectIdentifiers.sha1WithRSAEncryption;
        if (keyAlg.equals("EC") || keyAlg.equals("ECDSA")) {
            oid = X9ObjectIdentifiers.ecdsa_with_SHA1;
        } else if (keyAlg.equals("DSA")) {
            oid = X9ObjectIdentifiers.id_dsa_with_sha1;
        } else if (keyAlg.equals("ECGOST3410")) {
            oid = CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001;
        } else if (keyAlg.equals("DSTU4145")) {
            oid = new ASN1ObjectIdentifier(CesecoreConfiguration.getOidDstu4145());
        }
        if (digestAlg != null) {
            if (digestAlg.equals(CMSSignedGenerator.DIGEST_SHA256) && keyAlg.equals("RSA")) {
                oid = PKCSObjectIdentifiers.sha256WithRSAEncryption;
            } else if (digestAlg.equals(CMSSignedGenerator.DIGEST_SHA512) && keyAlg.equals("RSA")) {
                oid = PKCSObjectIdentifiers.sha512WithRSAEncryption;
            } else if (digestAlg.equals(CMSSignedGenerator.DIGEST_MD5) && keyAlg.equals("RSA")) {
                oid = PKCSObjectIdentifiers.md5WithRSAEncryption;
            } else if (digestAlg.equals(CMSSignedGenerator.DIGEST_SHA256) && (keyAlg.equals("ECDSA") || keyAlg.equals("EC"))) {
                oid = X9ObjectIdentifiers.ecdsa_with_SHA256;
            } else if (digestAlg.equals(CMSSignedGenerator.DIGEST_SHA224) && (keyAlg.equals("ECDSA") || keyAlg.equals("EC"))) {
                oid = X9ObjectIdentifiers.ecdsa_with_SHA224;
            } else if (digestAlg.equals(CMSSignedGenerator.DIGEST_SHA384) && (keyAlg.equals("ECDSA") || keyAlg.equals("EC"))) {
                oid = X9ObjectIdentifiers.ecdsa_with_SHA384;
            } else if (digestAlg.equals(CMSSignedGenerator.DIGEST_SHA512) && (keyAlg.equals("ECDSA") || keyAlg.equals("EC"))) {
                oid = X9ObjectIdentifiers.ecdsa_with_SHA512;
            } else if (digestAlg.equals(CMSSignedGenerator.DIGEST_SHA256) && keyAlg.equals("DSA")) {
                oid = NISTObjectIdentifiers.dsa_with_sha256;
            } else if (digestAlg.equals(CMSSignedGenerator.DIGEST_SHA512) && keyAlg.equals("DSA")) {
                oid = NISTObjectIdentifiers.dsa_with_sha512;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSignAlgOidFromDigestAndKey: " + oid.getId()));
        }
        return oid;
    }

    public static String getAlgorithmNameFromDigestAndKey(String digestAlg, String keyAlg) {
        return AlgorithmTools.getAlgorithmNameFromOID(AlgorithmTools.getSignAlgOidFromDigestAndKey(digestAlg, keyAlg));
    }

    public static boolean isGost3410Enabled() {
        return CesecoreConfiguration.getOidGost3410() != null;
    }

    public static boolean isDstu4145Enabled() {
        return CesecoreConfiguration.getOidDstu4145() != null;
    }

    public static boolean isSigAlgEnabled(String sigAlg) {
        if ("GOST3411withECGOST3410".equals(sigAlg)) {
            return AlgorithmTools.isGost3410Enabled();
        }
        if ("GOST3411withDSTU4145".equals(sigAlg)) {
            return AlgorithmTools.isDstu4145Enabled();
        }
        return true;
    }

    public static String getAlgorithmNameFromOID(ASN1ObjectIdentifier sigAlgOid) {
        if (sigAlgOid.equals((Object)PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            return "MD5WithRSA";
        }
        if (sigAlgOid.equals((Object)PKCSObjectIdentifiers.sha1WithRSAEncryption)) {
            return "SHA1WithRSA";
        }
        if (sigAlgOid.equals((Object)PKCSObjectIdentifiers.sha256WithRSAEncryption)) {
            return "SHA256WithRSA";
        }
        if (sigAlgOid.equals((Object)PKCSObjectIdentifiers.sha384WithRSAEncryption)) {
            return "SHA384WithRSA";
        }
        if (sigAlgOid.equals((Object)PKCSObjectIdentifiers.sha512WithRSAEncryption)) {
            return "SHA512WithRSA";
        }
        if (sigAlgOid.equals((Object)X9ObjectIdentifiers.ecdsa_with_SHA1)) {
            return "SHA1withECDSA";
        }
        if (sigAlgOid.equals((Object)X9ObjectIdentifiers.ecdsa_with_SHA224)) {
            return "SHA224withECDSA";
        }
        if (sigAlgOid.equals((Object)X9ObjectIdentifiers.ecdsa_with_SHA256)) {
            return "SHA256withECDSA";
        }
        if (sigAlgOid.equals((Object)X9ObjectIdentifiers.ecdsa_with_SHA384)) {
            return "SHA384withECDSA";
        }
        if (sigAlgOid.equals((Object)X9ObjectIdentifiers.ecdsa_with_SHA512)) {
            return "SHA512withECDSA";
        }
        if (AlgorithmTools.isGost3410Enabled() && sigAlgOid.getId().equalsIgnoreCase(CesecoreConfiguration.getOidGost3410())) {
            return "GOST3411withECGOST3410";
        }
        if (AlgorithmTools.isDstu4145Enabled() && sigAlgOid.getId().startsWith(CesecoreConfiguration.getOidDstu4145() + ".")) {
            return "GOST3411withDSTU4145";
        }
        return null;
    }

    static {
        SIG_ALGS_RSA.add("SHA1WithRSA");
        SIG_ALGS_RSA.add("SHA1withRSAandMGF1");
        SIG_ALGS_RSA.add("SHA256WithRSA");
        SIG_ALGS_RSA.add("SHA256withRSAandMGF1");
        SIG_ALGS_DSA = new LinkedList<String>();
        SIG_ALGS_DSA.add("SHA1WithDSA");
        SIG_ALGS_ECDSA = new LinkedList<String>();
        SIG_ALGS_ECDSA.add("SHA1withECDSA");
        SIG_ALGS_ECDSA.add("SHA224withECDSA");
        SIG_ALGS_ECDSA.add("SHA256withECDSA");
        SIG_ALGS_ECDSA.add("SHA384withECDSA");
        SIG_ALGS_ECDSA.add("SHA512withECDSA");
        SIG_ALGS_ECGOST3410 = new LinkedList<String>();
        SIG_ALGS_ECGOST3410.add("GOST3411withECGOST3410");
        SIG_ALGS_DSTU4145 = new LinkedList<String>();
        SIG_ALGS_DSTU4145.add("GOST3411withDSTU4145");
    }
}

