/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.cesecore.certificates.util.DnComponents;
import org.ietf.ldap.LDAPDN;

public class DNFieldExtractor
implements Serializable {
    private static final long serialVersionUID = -1313839342568999844L;
    private static final Logger log = Logger.getLogger(DNFieldExtractor.class);
    public static final int TYPE_SUBJECTDN = 0;
    public static final int TYPE_SUBJECTALTNAME = 1;
    public static final int TYPE_SUBJECTDIRATTR = 2;
    public static final int E = 0;
    public static final int UID = 1;
    public static final int CN = 2;
    public static final int SN = 3;
    public static final int GIVENNAME = 4;
    public static final int INITIALS = 5;
    public static final int SURNAME = 6;
    public static final int T = 7;
    public static final int OU = 8;
    public static final int O = 9;
    public static final int L = 10;
    public static final int ST = 11;
    public static final int DC = 12;
    public static final int C = 13;
    public static final int UNSTRUCTUREDADDRESS = 14;
    public static final int UNSTRUCTUREDNAME = 15;
    public static final int POSTALCODE = 32;
    public static final int BUSINESSCATEGORY = 33;
    public static final int DN = 34;
    public static final int POSTALADDRESS = 35;
    public static final int TELEPHONENUMBER = 36;
    public static final int PSEUDONYM = 37;
    public static final int STREET = 38;
    public static final int NAME = 55;
    public static final int OTHERNAME = 16;
    public static final int RFC822NAME = 17;
    public static final int DNSNAME = 18;
    public static final int IPADDRESS = 19;
    public static final int X400ADDRESS = 20;
    public static final int DIRECTORYNAME = 21;
    public static final int EDIPARTYNAME = 22;
    public static final int URI = 23;
    public static final int REGISTEREDID = 24;
    public static final int UPN = 25;
    public static final int GUID = 26;
    public static final int KRB5PRINCIPAL = 52;
    public static final int PERMANTIDENTIFIER = 56;
    public static final int DATEOFBIRTH = 27;
    public static final int PLACEOFBIRTH = 28;
    public static final int GENDER = 29;
    public static final int COUNTRYOFCITIZENSHIP = 30;
    public static final int COUNTRYOFRESIDENCE = 31;
    private static final int BOUNDRARY = 100;
    private HashMap<Integer, Integer> fieldnumbers;
    private HashMap<Integer, String> dnfields = new HashMap();
    private boolean existsother = false;
    private boolean illegal = false;
    private int type;

    public DNFieldExtractor(String dn, int type) {
        this.setDN(dn, type);
    }

    public static Integer[] getUseFields(int type) {
        if (type == 0) {
            return DnComponents.getDnDnIds().toArray(new Integer[0]);
        }
        if (type == 1) {
            return DnComponents.getAltNameDnIds().toArray(new Integer[0]);
        }
        if (type == 2) {
            return DnComponents.getDirAttrDnIds().toArray(new Integer[0]);
        }
        return new Integer[0];
    }

    public static String getFieldComponent(int field, int type) {
        String ret = type == 0 ? DnComponents.getDnExtractorFieldFromDnId(field) : (type == 1 ? DnComponents.getAltNameExtractorFieldFromDnId(field) : DnComponents.getDirAttrExtractorFieldFromDnId(field));
        return ret;
    }

    public final void setDN(String dn, int type) {
        block11: {
            this.type = type;
            ArrayList<Integer> ids = type == 0 ? DnComponents.getDnDnIds() : (type == 1 ? DnComponents.getAltNameDnIds() : (type == 2 ? DnComponents.getDirAttrDnIds() : new ArrayList()));
            this.fieldnumbers = new HashMap();
            for (Integer id : ids) {
                this.fieldnumbers.put(id, 0);
            }
            if (dn != null && !dn.equalsIgnoreCase("null")) {
                this.dnfields = new HashMap();
                try {
                    String[] dnexploded = LDAPDN.explodeDN((String)dn, (boolean)false);
                    for (int i = 0; i < dnexploded.length; ++i) {
                        boolean exists = false;
                        for (Integer id : ids) {
                            Integer number = this.fieldnumbers.get(id);
                            String field = type == 0 ? DnComponents.getDnExtractorFieldFromDnId(id) : (type == 1 ? DnComponents.getAltNameExtractorFieldFromDnId(id) : DnComponents.getDirAttrExtractorFieldFromDnId(id));
                            String dnex = dnexploded[i].toUpperCase();
                            if (id == 23) {
                                if (dnex.indexOf("uniformResourceIdentifier".toUpperCase(Locale.ENGLISH) + "=") > -1) {
                                    field = "uniformResourceIdentifier".toUpperCase(Locale.ENGLISH) + "=";
                                }
                                if (dnex.indexOf("uri".toUpperCase(Locale.ENGLISH) + "=") > -1) {
                                    field = "uri".toUpperCase(Locale.ENGLISH) + "=";
                                }
                            }
                            if (!dnex.startsWith(field)) continue;
                            exists = true;
                            String tmp = dnexploded[i].charAt(dnexploded[i].length() - 1) != '=' ? LDAPDN.unescapeRDN((String)dnexploded[i]) : dnexploded[i];
                            String rdn = tmp.toUpperCase().startsWith(field) ? tmp.substring(field.length(), tmp.length()) : tmp;
                            this.dnfields.put(id * 100 + number, rdn);
                            number = number + 1;
                            this.fieldnumbers.put(id, number);
                        }
                        if (exists) continue;
                        this.existsother = true;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"setDN: ", (Throwable)e);
                    this.illegal = true;
                    if (type == 0) {
                        this.dnfields.put(200, "Illegal DN : " + dn);
                    }
                    if (type == 1) {
                        this.dnfields.put(1700, "Illegal Subjectaltname : " + dn);
                    }
                    if (type != 2) break block11;
                    this.dnfields.put(2800, "Illegal Subjectdirectory attribute : " + dn);
                }
            }
        }
    }

    public String getField(int field, int number) {
        String returnval = this.dnfields.get(field * 100 + number);
        if (returnval == null) {
            returnval = "";
        }
        return returnval;
    }

    public String getFieldString(int field) {
        String retval = "";
        String fieldname = DnComponents.getDnExtractorFieldFromDnId(field);
        if (this.type != 0) {
            fieldname = DnComponents.getAltNameExtractorFieldFromDnId(field);
        }
        int num = this.getNumberOfFields(field);
        for (int i = 0; i < num; ++i) {
            retval = retval.length() == 0 ? retval + LDAPDN.escapeRDN((String)(fieldname + this.getField(field, i))) : retval + "," + LDAPDN.escapeRDN((String)(fieldname + this.getField(field, i)));
        }
        return retval;
    }

    public boolean existsOther() {
        return this.existsother;
    }

    public int getNumberOfFields(int field) {
        Integer ret = this.fieldnumbers.get(field);
        if (ret == null) {
            log.error((Object)("Not finding fieldnumber value for " + field));
            ret = 0;
        }
        return ret;
    }

    public HashMap<Integer, Integer> getNumberOfFields() {
        return this.fieldnumbers;
    }

    public boolean isIllegal() {
        return this.illegal;
    }
}

