/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.cesecore.util.CeSecoreNameStyle;

public class DnComponents {
    private static Logger log = Logger.getLogger(DnComponents.class);
    private static DnComponents obj = new DnComponents();
    private static HashMap<String, ASN1ObjectIdentifier> oids = new HashMap();
    private static String[] dNObjectsForward;
    private static String[] dNObjectsReverse;
    public static final String DNEMAILADDRESS = "EMAILADDRESS";
    public static final String DNQUALIFIER = "DNQUALIFIER";
    public static final String UID = "UID";
    public static final String COMMONNAME = "COMMONNAME";
    public static final String DNSERIALNUMBER = "SERIALNUMBER";
    public static final String GIVENNAME = "GIVENNAME";
    public static final String INITIALS = "INITIALS";
    public static final String SURNAME = "SURNAME";
    public static final String TITLE = "TITLE";
    public static final String ORGANIZATIONALUNIT = "ORGANIZATIONALUNIT";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String LOCALITY = "LOCALITY";
    public static final String STATEORPROVINCE = "STATEORPROVINCE";
    public static final String DOMAINCOMPONENT = "DOMAINCOMPONENT";
    public static final String COUNTRY = "COUNTRY";
    public static final String UNSTRUCTUREDADDRESS = "UNSTRUCTUREDADDRESS";
    public static final String UNSTRUCTUREDNAME = "UNSTRUCTUREDNAME";
    public static final String POSTALCODE = "POSTALCODE";
    public static final String BUSINESSCATEGORY = "BUSINESSCATEGORY";
    public static final String POSTALADDRESS = "POSTALADDRESS";
    public static final String TELEPHONENUMBER = "TELEPHONENUMBER";
    public static final String PSEUDONYM = "PSEUDONYM";
    public static final String STREETADDRESS = "STREETADDRESS";
    public static final String NAME = "NAME";
    public static final String RFC822NAME = "RFC822NAME";
    public static final String DNSNAME = "DNSNAME";
    public static final String IPADDRESS = "IPADDRESS";
    public static final String UNIFORMRESOURCEID = "UNIFORMRESOURCEID";
    public static final String DIRECTORYNAME = "DIRECTORYNAME";
    public static final String UPN = "UPN";
    public static final String GUID = "GUID";
    public static final String KRB5PRINCIPAL = "KRB5PRINCIPAL";
    public static final String PERMANENTIDENTIFIER = "PERMANENTIDENTIFIER";
    public static final String OTHERNAME = "OTHERNAME";
    public static final String X400ADDRESS = "X400ADDRESS";
    public static final String EDIPARTYNAME = "EDIPARTYNAME";
    public static final String REGISTEREDID = "REGISTEREDID";
    public static final String DATEOFBIRTH = "DATEOFBIRTH";
    public static final String PLACEOFBIRTH = "PLACEOFBIRTH";
    public static final String GENDER = "GENDER";
    public static final String COUNTRYOFCITIZENSHIP = "COUNTRYOFCITIZENSHIP";
    public static final String COUNTRYOFRESIDENCE = "COUNTRYOFRESIDENCE";
    private static HashMap<String, Integer> dnNameIdMap;
    private static HashMap<String, Integer> profileNameIdMap;
    private static HashMap<Integer, String> dnIdToProfileNameMap;
    private static HashMap<Integer, Integer> dnIdToProfileIdMap;
    private static HashMap<Integer, Integer> profileIdToDnIdMap;
    private static HashMap<Integer, String> dnErrorTextMap;
    private static HashMap<String, String> profileNameLanguageMap;
    private static HashMap<Integer, String> profileIdLanguageMap;
    private static HashMap<Integer, String> dnIdErrorMap;
    private static HashMap<Integer, String> dnIdToExtractorFieldMap;
    private static HashMap<Integer, String> altNameIdToExtractorFieldMap;
    private static HashMap<Integer, String> dirAttrIdToExtractorFieldMap;
    private static ArrayList<String> dnProfileFields;
    private static final TreeSet<String> dnProfileFieldsHashSet;
    private static ArrayList<String> dnLanguageTexts;
    private static ArrayList<Integer> dnDnIds;
    private static ArrayList<String> altNameFields;
    private static final TreeSet<String> altNameFieldsHashSet;
    private static ArrayList<String> altNameLanguageTexts;
    private static ArrayList<Integer> altNameDnIds;
    private static ArrayList<String> dirAttrFields;
    private static final TreeSet<String> dirAttrFieldsHashSet;
    private static ArrayList<String> dirAttrLanguageTexts;
    private static ArrayList<Integer> dirAttrDnIds;
    private static ArrayList<String> dnExtractorFields;
    private static ArrayList<String> altNameExtractorFields;
    private static ArrayList<String> dirAttrExtractorFields;

    public static ASN1ObjectIdentifier getOid(String o) {
        return oids.get(o.toLowerCase());
    }

    public static ArrayList<String> getDnProfileFields() {
        return dnProfileFields;
    }

    public static boolean isDnProfileField(String field) {
        return dnProfileFieldsHashSet.contains(field);
    }

    public static ArrayList<String> getDnLanguageTexts() {
        return dnLanguageTexts;
    }

    public static ArrayList<String> getAltNameFields() {
        return altNameFields;
    }

    public static boolean isAltNameField(String field) {
        return altNameFieldsHashSet.contains(field);
    }

    public static ArrayList<String> getAltNameLanguageTexts() {
        return altNameLanguageTexts;
    }

    public static ArrayList<String> getDirAttrFields() {
        return dirAttrFields;
    }

    public static boolean isDirAttrField(String field) {
        return dirAttrFieldsHashSet.contains(field);
    }

    public static ArrayList<Integer> getDirAttrDnIds() {
        return dirAttrDnIds;
    }

    public static ArrayList<Integer> getAltNameDnIds() {
        return altNameDnIds;
    }

    public static ArrayList<Integer> getDnDnIds() {
        return dnDnIds;
    }

    protected static ArrayList<String> getDnExtractorFields() {
        return dnExtractorFields;
    }

    protected static String getDnExtractorFieldFromDnId(int field) {
        String val = dnIdToExtractorFieldMap.get(field);
        return val;
    }

    protected static ArrayList<String> getAltNameExtractorFields() {
        return altNameExtractorFields;
    }

    protected static String getAltNameExtractorFieldFromDnId(int field) {
        String val = altNameIdToExtractorFieldMap.get(field);
        return val;
    }

    protected static ArrayList<String> getDirAttrExtractorFields() {
        return dirAttrExtractorFields;
    }

    protected static String getDirAttrExtractorFieldFromDnId(int field) {
        String val = dirAttrIdToExtractorFieldMap.get(field);
        return val;
    }

    public static String dnIdToProfileName(int dnid) {
        String val = dnIdToProfileNameMap.get(dnid);
        return val;
    }

    public static int dnIdToProfileId(int dnid) {
        Integer val = dnIdToProfileIdMap.get(dnid);
        return val;
    }

    public static String getLanguageConstantFromProfileName(String name) {
        String ret = profileNameLanguageMap.get(name);
        return ret;
    }

    public static String getLanguageConstantFromProfileId(int id) {
        String ret = profileIdLanguageMap.get(id);
        return ret;
    }

    public static String getErrTextFromDnId(int id) {
        String ret = dnIdErrorMap.get(id);
        return ret;
    }

    public static HashMap<String, Integer> getProfilenameIdMap() {
        return profileNameIdMap;
    }

    public static int profileIdToDnId(int profileid) {
        Integer val = profileIdToDnIdMap.get(profileid);
        if (val == null) {
            log.error((Object)("No dn id mapping from profile id " + profileid));
        }
        return val;
    }

    public static String[] getDnObjects(boolean ldaporder) {
        if (ldaporder) {
            return dNObjectsForward;
        }
        return DnComponents.getDnObjectsReverse();
    }

    protected static String[] getDnObjectsReverse() {
        if (dNObjectsReverse == null) {
            dNObjectsReverse = (String[])dNObjectsForward.clone();
            ArrayUtils.reverse((Object[])dNObjectsReverse);
        }
        return dNObjectsReverse;
    }

    private static void load() {
        DnComponents.loadOrdering();
        DnComponents.loadMappings();
    }

    private static void loadMappings() {
        DnComponents.loadProfileMappingsFromFile("/profilemappings.properties");
        DnComponents.loadProfileMappingsFromFile("/profilemappings_enterprise.properties");
    }

    public static boolean enterpriseMappingsExist() {
        return obj.getClass().getResourceAsStream("/profilemappings_enterprise.properties") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProfileMappingsFromFile(String propertiesFile) {
        BufferedReader in = null;
        InputStreamReader inf = null;
        try {
            InputStream is = obj.getClass().getResourceAsStream(propertiesFile);
            if (is != null) {
                String line;
                inf = new InputStreamReader(is);
                in = new BufferedReader(inf);
                if (!in.ready()) {
                    throw new IOException("Couldn't read " + propertiesFile);
                }
                String[] splits = null;
                int lines = 0;
                ArrayList<Integer> dnids = new ArrayList<Integer>();
                ArrayList<Integer> profileids = new ArrayList<Integer>();
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#") || (splits = StringUtils.split((String)line, (char)';')) == null || splits.length <= 5) continue;
                    String type = splits[0];
                    String dnname = splits[1];
                    Integer dnid = Integer.valueOf(splits[2]);
                    String profilename = splits[3];
                    Integer profileid = Integer.valueOf(splits[4]);
                    String errstr = splits[5];
                    String langstr = splits[6];
                    if (dnids.contains(dnid)) {
                        log.error((Object)("Duplicated DN Id " + dnid + " detected in mapping file."));
                    } else {
                        dnids.add(dnid);
                    }
                    if (profileids.contains(profileid)) {
                        log.error((Object)("Duplicated Profile Id " + profileid + " detected in mapping file."));
                    } else {
                        profileids.add(profileid);
                    }
                    dnNameIdMap.put(dnname, dnid);
                    profileNameIdMap.put(profilename, profileid);
                    dnIdToProfileNameMap.put(dnid, profilename);
                    dnIdToProfileIdMap.put(dnid, profileid);
                    dnIdErrorMap.put(dnid, errstr);
                    profileIdToDnIdMap.put(profileid, dnid);
                    dnErrorTextMap.put(dnid, errstr);
                    profileNameLanguageMap.put(profilename, langstr);
                    profileIdLanguageMap.put(profileid, langstr);
                    if (type.equals("DN")) {
                        dnProfileFields.add(profilename);
                        dnProfileFieldsHashSet.add(profilename);
                        dnLanguageTexts.add(langstr);
                        dnDnIds.add(dnid);
                        dnExtractorFields.add(dnname + "=");
                        dnIdToExtractorFieldMap.put(dnid, dnname + "=");
                    }
                    if (type.equals("ALTNAME")) {
                        altNameFields.add(dnname);
                        altNameFieldsHashSet.add(dnname);
                        altNameLanguageTexts.add(langstr);
                        altNameDnIds.add(dnid);
                        altNameExtractorFields.add(dnname + "=");
                        altNameIdToExtractorFieldMap.put(dnid, dnname + "=");
                    }
                    if (type.equals("DIRATTR")) {
                        dirAttrFields.add(dnname);
                        dirAttrFieldsHashSet.add(dnname);
                        dirAttrLanguageTexts.add(langstr);
                        dirAttrDnIds.add(dnid);
                        dirAttrExtractorFields.add(dnname + "=");
                        dirAttrIdToExtractorFieldMap.put(dnid, dnname + "=");
                    }
                    ++lines;
                }
                in.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read profile maps with " + lines + " lines."));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Properties file " + propertiesFile + " was not found."));
            }
        }
        catch (IOException e) {
            log.error((Object)"Can not load profile mappings: ", (Throwable)e);
        }
        finally {
            try {
                if (inf != null) {
                    inf.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadOrdering() {
        LinkedHashMap<String, ASN1ObjectIdentifier> map = new LinkedHashMap<String, ASN1ObjectIdentifier>();
        BufferedReader in = null;
        InputStreamReader inf = null;
        try {
            InputStream is = obj.getClass().getResourceAsStream("/dncomponents.properties");
            if (is != null) {
                String line;
                inf = new InputStreamReader(is);
                in = new BufferedReader(inf);
                if (!in.ready()) {
                    throw new IOException();
                }
                String[] splits = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#") || (splits = StringUtils.split((String)line, (char)'=')) == null || splits.length <= 1) continue;
                    String name = splits[0].toLowerCase();
                    ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(splits[1]);
                    map.put(name, oid);
                }
                in.close();
                log.info((Object)"Using DN components from properties file");
                oids.clear();
                oids.putAll(map);
                Set keys = map.keySet();
                dNObjectsForward = keys.toArray(new String[keys.size()]);
            } else {
                log.debug((Object)"Using default values for DN components");
            }
        }
        catch (IOException e) {
            log.debug((Object)"Using default values for DN components");
        }
        finally {
            try {
                if (inf != null) {
                    inf.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static {
        oids.put("c", CeSecoreNameStyle.C);
        oids.put("dc", CeSecoreNameStyle.DC);
        oids.put("st", CeSecoreNameStyle.ST);
        oids.put("l", CeSecoreNameStyle.L);
        oids.put("o", CeSecoreNameStyle.O);
        oids.put("ou", CeSecoreNameStyle.OU);
        oids.put("t", CeSecoreNameStyle.T);
        oids.put("surname", CeSecoreNameStyle.SURNAME);
        oids.put("initials", CeSecoreNameStyle.INITIALS);
        oids.put("givenname", CeSecoreNameStyle.GIVENNAME);
        oids.put("gn", CeSecoreNameStyle.GIVENNAME);
        oids.put("sn", CeSecoreNameStyle.SN);
        oids.put("serialnumber", CeSecoreNameStyle.SERIALNUMBER);
        oids.put("cn", CeSecoreNameStyle.CN);
        oids.put("uid", CeSecoreNameStyle.UID);
        oids.put("dn", CeSecoreNameStyle.DN_QUALIFIER);
        oids.put("emailaddress", CeSecoreNameStyle.EmailAddress);
        oids.put("e", CeSecoreNameStyle.EmailAddress);
        oids.put("email", CeSecoreNameStyle.EmailAddress);
        oids.put("unstructuredname", CeSecoreNameStyle.UnstructuredName);
        oids.put("unstructuredaddress", CeSecoreNameStyle.UnstructuredAddress);
        oids.put("postalcode", CeSecoreNameStyle.POSTAL_CODE);
        oids.put("businesscategory", CeSecoreNameStyle.BUSINESS_CATEGORY);
        oids.put("postaladdress", CeSecoreNameStyle.POSTAL_ADDRESS);
        oids.put("telephonenumber", CeSecoreNameStyle.TELEPHONE_NUMBER);
        oids.put("pseudonym", CeSecoreNameStyle.PSEUDONYM);
        oids.put("street", CeSecoreNameStyle.STREET);
        oids.put("name", CeSecoreNameStyle.NAME);
        oids.put("jurisdictionlocality", CeSecoreNameStyle.JURISDICTION_LOCALITY);
        oids.put("jurisdictionstate", CeSecoreNameStyle.JURISDICTION_STATE);
        oids.put("jurisdictioncountry", CeSecoreNameStyle.JURISDICTION_COUNTRY);
        dNObjectsForward = new String[]{"jurisdictioncountry", "jurisdictionstate", "jurisdictionlocality", "street", "pseudonym", "telephonenumber", "postaladdress", "businesscategory", "postalcode", "unstructuredaddress", "unstructuredname", "emailaddress", "e", "email", "dn", "uid", "cn", "name", "sn", "serialnumber", "gn", "givenname", "initials", "surname", "t", "ou", "o", "l", "st", "dc", "c"};
        dNObjectsReverse = null;
        dnNameIdMap = new HashMap();
        profileNameIdMap = new HashMap();
        dnIdToProfileNameMap = new HashMap();
        dnIdToProfileIdMap = new HashMap();
        profileIdToDnIdMap = new HashMap();
        dnErrorTextMap = new HashMap();
        profileNameLanguageMap = new HashMap();
        profileIdLanguageMap = new HashMap();
        dnIdErrorMap = new HashMap();
        dnIdToExtractorFieldMap = new HashMap();
        altNameIdToExtractorFieldMap = new HashMap();
        dirAttrIdToExtractorFieldMap = new HashMap();
        dnProfileFields = new ArrayList();
        dnProfileFieldsHashSet = new TreeSet();
        dnLanguageTexts = new ArrayList();
        dnDnIds = new ArrayList();
        altNameFields = new ArrayList();
        altNameFieldsHashSet = new TreeSet();
        altNameLanguageTexts = new ArrayList();
        altNameDnIds = new ArrayList();
        dirAttrFields = new ArrayList();
        dirAttrFieldsHashSet = new TreeSet();
        dirAttrLanguageTexts = new ArrayList();
        dirAttrDnIds = new ArrayList();
        dnExtractorFields = new ArrayList();
        altNameExtractorFields = new ArrayList();
        dirAttrExtractorFields = new ArrayList();
        DnComponents.load();
    }
}

