/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.util.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.cesecore.certificates.crl.RevokedCertInfo;

public class CrlExtensions {
    private static Logger log = Logger.getLogger(CrlExtensions.class);

    public static BigInteger getCrlNumber(X509CRL crl) {
        BigInteger ret = BigInteger.valueOf(0L);
        try {
            CRLNumber crlnum;
            ASN1Primitive obj = CrlExtensions.getExtensionValue(crl, Extension.cRLNumber.getId());
            if (obj != null && (crlnum = CRLNumber.getInstance((Object)obj)) != null) {
                ret = crlnum.getCRLNumber();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error reading CRL number extension: ", (Throwable)e);
        }
        return ret;
    }

    public static BigInteger getDeltaCRLIndicator(X509CRL crl) {
        BigInteger ret = BigInteger.valueOf(-1L);
        try {
            CRLNumber crlnum;
            ASN1Primitive obj = CrlExtensions.getExtensionValue(crl, Extension.deltaCRLIndicator.getId());
            if (obj != null && (crlnum = CRLNumber.getInstance((Object)obj)) != null) {
                ret = crlnum.getCRLNumber();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error reading CRL number extension: ", (Throwable)e);
        }
        return ret;
    }

    protected static ASN1Primitive getExtensionValue(X509CRL crl, String oid) throws IOException {
        if (crl == null) {
            return null;
        }
        byte[] bytes = crl.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    public static int extractReasonCode(X509CRLEntry crlEntry) {
        int reasonCode = RevokedCertInfo.REVOCATION_REASON_UNSPECIFIED;
        if (crlEntry.hasExtensions()) {
            byte[] extensionValue = crlEntry.getExtensionValue(Extension.reasonCode.getId());
            try {
                ASN1Enumerated reasonCodeExtension = ASN1Enumerated.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue));
                if (reasonCodeExtension != null) {
                    reasonCode = reasonCodeExtension.getValue().intValue();
                }
            }
            catch (IOException e) {
                log.debug((Object)("Failed to parse reason code of CRLEntry: " + e.getMessage()));
            }
        }
        return reasonCode;
    }

    public static List<String> extractFreshestCrlDistributionPoints(X509CRL crl) {
        ASN1Sequence asn1Sequence;
        ASN1OctetString asn1OctetString;
        ArrayList<String> freshestCdpUrls = new ArrayList<String>();
        byte[] extensionValue = crl.getExtensionValue(Extension.freshestCRL.getId());
        if (extensionValue != null && (asn1OctetString = CrlExtensions.getAsn1ObjectFromBytes(extensionValue, ASN1OctetString.class)) != null && (asn1Sequence = CrlExtensions.getAsn1ObjectFromBytes(asn1OctetString.getOctets(), ASN1Sequence.class)) != null) {
            CRLDistPoint cdp = CRLDistPoint.getInstance((Object)asn1Sequence);
            for (DistributionPoint distributionPoint : cdp.getDistributionPoints()) {
                freshestCdpUrls.add(((DERIA5String)((GeneralNames)distributionPoint.getDistributionPoint().getName()).getNames()[0].getName()).getString());
            }
        }
        return freshestCdpUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getAsn1ObjectFromBytes(byte[] bytes, Class<T> clazz) {
        ASN1Primitive ret = null;
        ASN1InputStream asn1InputStream = null;
        try {
            if (bytes != null) {
                asn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
                ret = asn1InputStream.readObject();
            }
        }
        catch (ClassCastException e) {
            log.info((Object)"Failed to extract expected ASN1 object from bytes array.", (Throwable)e);
        }
        catch (IOException e) {
            log.info((Object)"Failed to extract ASN1 object from bytes array.", (Throwable)e);
        }
        finally {
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    log.info((Object)"Failed to extract expected ASN1 object from bytes array.", (Throwable)e);
                }
            }
        }
        return (T)ret;
    }
}

