/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.util.cert;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.RFC3739QCObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.SemanticsInformation;
import org.cesecore.util.CertTools;

public final class QCStatementExtension
extends CertTools {
    private static final Logger log = Logger.getLogger(QCStatementExtension.class);

    private QCStatementExtension() {
    }

    public static boolean hasQcStatement(Certificate cert) throws IOException {
        X509Certificate x509cert;
        ASN1Primitive obj;
        boolean ret = false;
        if (cert instanceof X509Certificate && (obj = QCStatementExtension.getExtensionValue(x509cert = (X509Certificate)cert, Extension.qCStatements.getId())) != null) {
            ret = true;
        }
        return ret;
    }

    public static Collection<String> getQcStatementIds(Certificate cert) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        if (cert instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)cert;
            ASN1Primitive obj = QCStatementExtension.getExtensionValue(x509cert, Extension.qCStatements.getId());
            if (obj == null) {
                return ret;
            }
            ASN1Sequence seq = (ASN1Sequence)obj;
            for (int i = 0; i < seq.size(); ++i) {
                QCStatement qc = QCStatement.getInstance((Object)seq.getObjectAt(i));
                ASN1ObjectIdentifier oid = qc.getStatementId();
                if (oid == null) continue;
                ret.add(oid.getId());
            }
        }
        return ret;
    }

    public static String getQcStatementValueLimit(Certificate cert) throws IOException {
        String ret = null;
        if (cert instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)cert;
            ASN1Primitive obj = QCStatementExtension.getExtensionValue(x509cert, Extension.qCStatements.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence seq = (ASN1Sequence)obj;
            MonetaryValue mv = null;
            for (int i = 0; i < seq.size(); ++i) {
                ASN1Encodable enc;
                QCStatement qc = QCStatement.getInstance((Object)seq.getObjectAt(i));
                ASN1ObjectIdentifier oid = qc.getStatementId();
                if (oid == null || !oid.equals((Object)ETSIQCObjectIdentifiers.id_etsi_qcs_LimiteValue) || (enc = qc.getStatementInfo()) == null) continue;
                mv = MonetaryValue.getInstance((Object)enc);
                break;
            }
            if (mv != null) {
                String curr;
                BigInteger amount = mv.getAmount();
                BigInteger exp = mv.getExponent();
                BigInteger ten = BigInteger.valueOf(10L);
                long value = amount.longValue() * ten.pow(exp.intValue()).longValue();
                if (value < 0L) {
                    log.error((Object)"ETSI LimitValue amount is < 0.");
                }
                if ((curr = mv.getCurrency().getAlphabetic()) == null) {
                    log.error((Object)"ETSI LimitValue currency is null");
                }
                if (value >= 0L && curr != null) {
                    ret = value + " " + curr;
                }
            }
        }
        return ret;
    }

    public static String getQcStatementAuthorities(Certificate cert) throws IOException {
        String ret = null;
        if (cert instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)cert;
            ASN1Primitive obj = QCStatementExtension.getExtensionValue(x509cert, Extension.qCStatements.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence seq = (ASN1Sequence)obj;
            SemanticsInformation si = null;
            for (int i = 0; i < seq.size(); ++i) {
                ASN1Encodable enc;
                QCStatement qc = QCStatement.getInstance((Object)seq.getObjectAt(i));
                ASN1ObjectIdentifier oid = qc.getStatementId();
                if (oid == null || !oid.equals((Object)RFC3739QCObjectIdentifiers.id_qcs_pkixQCSyntax_v1) && !oid.equals((Object)RFC3739QCObjectIdentifiers.id_qcs_pkixQCSyntax_v2) || (enc = qc.getStatementInfo()) == null) continue;
                si = SemanticsInformation.getInstance((Object)enc);
                break;
            }
            if (si != null) {
                GeneralName[] gns = si.getNameRegistrationAuthorities();
                if (gns == null) {
                    return null;
                }
                StringBuilder strBuf = new StringBuilder();
                for (int i = 0; i < gns.length; ++i) {
                    String str;
                    GeneralName gn = gns[i];
                    if (strBuf.length() != 0) {
                        strBuf.append(", ");
                    }
                    if ((str = QCStatementExtension.getGeneralNameString(gn.getTagNo(), gn.getName())) == null) continue;
                    strBuf.append(str);
                }
                if (strBuf.length() > 0) {
                    ret = strBuf.toString();
                }
            }
        }
        return ret;
    }
}

