/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.util.cert;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.cesecore.util.CertTools;

public class SubjectDirAttrExtension
extends CertTools {
    private static final Logger log = Logger.getLogger(SubjectDirAttrExtension.class);

    private SubjectDirAttrExtension() {
    }

    public static String getSubjectDirectoryAttributes(Certificate certificate) throws Exception {
        log.debug((Object)"Search for SubjectAltName");
        String result = "";
        if (certificate instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)certificate;
            ASN1Primitive obj = CertTools.getExtensionValue(x509cert, Extension.subjectDirectoryAttributes.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence seq = (ASN1Sequence)obj;
            String prefix = "";
            SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMdd");
            for (int i = 0; i < seq.size(); ++i) {
                String g;
                ASN1Set set;
                Attribute attr = Attribute.getInstance((Object)seq.getObjectAt(i));
                if (!StringUtils.isEmpty((String)result)) {
                    prefix = ", ";
                }
                if (attr.getAttrType().getId().equals("1.3.6.1.5.5.7.9.1")) {
                    set = attr.getAttrValues();
                    ASN1GeneralizedTime time = ASN1GeneralizedTime.getInstance((Object)set.getObjectAt(0));
                    Date date = time.getDate();
                    String dateStr = dateF.format(date);
                    result = result + prefix + "dateOfBirth=" + dateStr;
                }
                if (attr.getAttrType().getId().equals("1.3.6.1.5.5.7.9.2")) {
                    set = attr.getAttrValues();
                    String pb = ((ASN1String)set.getObjectAt(0)).getString();
                    result = result + prefix + "placeOfBirth=" + pb;
                }
                if (attr.getAttrType().getId().equals("1.3.6.1.5.5.7.9.3")) {
                    set = attr.getAttrValues();
                    g = ((ASN1String)set.getObjectAt(0)).getString();
                    result = result + prefix + "gender=" + g;
                }
                if (attr.getAttrType().getId().equals("1.3.6.1.5.5.7.9.4")) {
                    set = attr.getAttrValues();
                    g = ((ASN1String)set.getObjectAt(0)).getString();
                    result = result + prefix + "countryOfCitizenship=" + g;
                }
                if (!attr.getAttrType().getId().equals("1.3.6.1.5.5.7.9.5")) continue;
                set = attr.getAttrValues();
                g = ((ASN1String)set.getObjectAt(0)).getString();
                result = result + prefix + "countryOfResidence=" + g;
            }
        }
        if (StringUtils.isEmpty((String)result)) {
            return null;
        }
        return result;
    }

    public static Collection<Attribute> getSubjectDirectoryAttributes(String dirAttr) {
        ASN1EncodableVector vec;
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        Attribute attr = null;
        String value = CertTools.getPartFromDN(dirAttr, "countryOfResidence");
        if (!StringUtils.isEmpty((String)value)) {
            vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new DERPrintableString(value));
            attr = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.5"), (ASN1Set)new DERSet(vec));
            ret.add(attr);
        }
        if (!StringUtils.isEmpty((String)(value = CertTools.getPartFromDN(dirAttr, "countryOfCitizenship")))) {
            vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new DERPrintableString(value));
            attr = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.4"), (ASN1Set)new DERSet(vec));
            ret.add(attr);
        }
        if (!StringUtils.isEmpty((String)(value = CertTools.getPartFromDN(dirAttr, "gender")))) {
            vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new DERPrintableString(value));
            attr = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.3"), (ASN1Set)new DERSet(vec));
            ret.add(attr);
        }
        if (!StringUtils.isEmpty((String)(value = CertTools.getPartFromDN(dirAttr, "placeOfBirth")))) {
            vec = new ASN1EncodableVector();
            X509DefaultEntryConverter conv = new X509DefaultEntryConverter();
            ASN1Primitive obj = conv.getConvertedValue(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.2"), value);
            vec.add((ASN1Encodable)obj);
            attr = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.2"), (ASN1Set)new DERSet(vec));
            ret.add(attr);
        }
        if (!StringUtils.isEmpty((String)(value = CertTools.getPartFromDN(dirAttr, "dateOfBirth")))) {
            if (value.length() == 8) {
                value = value + "120000Z";
                vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)new DERGeneralizedTime(value));
                attr = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.1"), (ASN1Set)new DERSet(vec));
                ret.add(attr);
            } else {
                log.error((Object)"Wrong length of data for 'dateOfBirth', should be of format YYYYMMDD, skipping...");
            }
        }
        return ret;
    }
}

