/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.certificates.util.dn;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class DNFieldsUtil {
    private static final Logger LOG = Logger.getLogger(DNFieldsUtil.class);
    private static final int EMPTY = -1;
    private static final String MSG_ERROR_MISSING_EQUAL = "DN field definition is missing the '=': ";

    public static String removeAllEmpties(String dn) {
        if (dn == null) {
            return null;
        }
        StringBuilder removedAllEmpties = new StringBuilder(dn.length());
        DNFieldsUtil.removeEmpties(dn, removedAllEmpties, false);
        return removedAllEmpties.toString();
    }

    public static StringBuilder removeEmpties(String sDN, StringBuilder removedAllEmpties, boolean processTrailing) {
        StringBuilder removedTrailingEmpties = null;
        ArrayList<Integer> startOfPairs = new ArrayList<Integer>();
        ArrayList<Integer> startOfValues = new ArrayList<Integer>();
        char[] buf = sDN.toCharArray();
        DNFieldsUtil.populatePositionLists(startOfPairs, startOfValues, buf);
        boolean areStringBuildersEqual = true;
        for (int i = 0; i < startOfPairs.size(); ++i) {
            int startOfThisPair = (Integer)startOfPairs.get(i);
            int startOfNextPair = i == startOfPairs.size() - 1 ? buf.length : (Integer)startOfPairs.get(i + 1);
            int startOfThisValue = (Integer)startOfValues.get(i);
            boolean addOnlyNonTrailingEmpties = true;
            boolean addAllNonEmpties = true;
            if (startOfThisValue == -1) {
                addOnlyNonTrailingEmpties = false;
                addAllNonEmpties = false;
                if (processTrailing) {
                    for (int j = i + 1; j < startOfPairs.size(); ++j) {
                        int startOfThisPair2 = (Integer)startOfPairs.get(j);
                        if (!DNFieldsUtil.hasSameKey(buf, startOfThisPair, startOfThisPair2) || (Integer)startOfValues.get(j) == -1) continue;
                        addOnlyNonTrailingEmpties = true;
                        break;
                    }
                }
            }
            if (areStringBuildersEqual && addOnlyNonTrailingEmpties != addAllNonEmpties) {
                areStringBuildersEqual = false;
                if (processTrailing) {
                    removedTrailingEmpties = new StringBuilder(removedAllEmpties);
                }
            }
            if (addAllNonEmpties) {
                removedAllEmpties.append(buf, startOfThisPair, startOfNextPair - startOfThisPair);
            }
            if (!processTrailing || areStringBuildersEqual || !addOnlyNonTrailingEmpties) continue;
            removedTrailingEmpties.append(buf, startOfThisPair, startOfNextPair - startOfThisPair);
        }
        DNFieldsUtil.removeUnwatedLastChars(removedAllEmpties);
        if (!areStringBuildersEqual) {
            DNFieldsUtil.removeUnwatedLastChars(removedTrailingEmpties);
        }
        return removedTrailingEmpties;
    }

    private static void removeUnwatedLastChars(StringBuilder sb) {
        if (sb.length() > 0) {
            char c;
            for (int i = sb.length() - 1; i >= 0 && ((c = sb.charAt(i)) == ' ' || c == ',') && sb.charAt(i - 1) != '\\'; --i) {
                sb.deleteCharAt(i);
            }
        }
    }

    private static void populatePositionLists(List<Integer> startOfPairs, List<Integer> startOfValues, char[] buf) {
        if (buf.length > 0) {
            startOfPairs.add(0);
        }
        boolean notEscaped = true;
        block5: for (int i = 0; i < buf.length; ++i) {
            switch (buf[i]) {
                case '\\': {
                    notEscaped ^= true;
                    continue block5;
                }
                case ',': {
                    int j;
                    if (notEscaped) {
                        if (startOfPairs.size() > startOfValues.size()) {
                            LOG.info((Object)(MSG_ERROR_MISSING_EQUAL + new String(buf)));
                        }
                        for (j = i + 1; j < buf.length && buf[j] == ' '; ++j) {
                        }
                        startOfPairs.add(j);
                        continue block5;
                    }
                    notEscaped = true;
                    continue block5;
                }
                case '=': {
                    int j;
                    if (notEscaped) {
                        if (startOfPairs.size() <= startOfValues.size()) continue block5;
                        for (j = i + 1; j < buf.length && buf[j] == ' '; ++j) {
                        }
                        if (j >= buf.length || buf[j] == ',') {
                            startOfValues.add(-1);
                            continue block5;
                        }
                        startOfValues.add(j);
                        continue block5;
                    }
                    notEscaped = true;
                    continue block5;
                }
                default: {
                    notEscaped = true;
                }
            }
        }
    }

    private static boolean hasSameKey(char[] sb, int pos1, int pos2) {
        int len = sb.length;
        boolean notEscaped = true;
        while (len > pos1 && len > pos2) {
            char c1 = sb[pos1];
            switch (c1) {
                case '\\': {
                    notEscaped ^= true;
                    break;
                }
                case '=': {
                    if (notEscaped && c1 == sb[pos2]) {
                        return true;
                    }
                }
                default: {
                    if (c1 != sb[pos2]) {
                        return false;
                    }
                    notEscaped = true;
                }
            }
            ++pos1;
            ++pos2;
        }
        return false;
    }
}

