/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.cesecore.configuration.ConfigurationBase;

public class AvailableExtendedKeyUsagesConfiguration
extends ConfigurationBase
implements Serializable {
    private static final long serialVersionUID = -3430732247486886608L;
    public static final String CONFIGURATION_ID = "AVAILABLE_EXTENDED_KEY_USAGES";

    public AvailableExtendedKeyUsagesConfiguration(boolean ignored) {
    }

    public AvailableExtendedKeyUsagesConfiguration() {
        this.addExtKeyUsage("2.5.29.37.0", "EKU_PKIX_ANYEXTENDEDKEYUSAGE");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.1", "EKU_PKIX_SERVERAUTH");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.2", "EKU_PKIX_CLIENTAUTH");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.3", "EKU_PKIX_CODESIGNING");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.4", "EKU_PKIX_EMAILPROTECTION");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.8", "EKU_PKIX_TIMESTAMPING");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.9", "EKU_PKIX_OCSPSIGNING");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.13", "EKU_PKIX_EAPOVERPPP");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.14", "EKU_PKIX_EAPOVERLAN");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.15", "EKU_PKIX_SCVPSERVER");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.16", "EKU_PKIX_SCVPCLIENT");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.17", "EKU_PKIX_IPSECIKE");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.20", "EKU_PKIX_SIPDOMAIN");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.21", "EKU_PKIX_SSHCLIENT");
        this.addExtKeyUsage("1.3.6.1.5.5.7.3.22", "EKU_PKIX_SSHSERVER");
        this.addExtKeyUsage("1.3.6.1.4.1.311.20.2.2", "EKU_MS_SMARTCARDLOGON");
        this.addExtKeyUsage("1.3.6.1.4.1.311.10.3.12", "EKU_MS_DOCUMENTSIGNING");
        this.addExtKeyUsage("1.3.6.1.4.1.311.2.1.21", "EKU_MS_CODESIGNING_IND");
        this.addExtKeyUsage("1.3.6.1.4.1.311.2.1.22", "EKU_MS_CODESIGNING_COM");
        this.addExtKeyUsage("1.3.6.1.4.1.311.10.3.4", "EKU_MS_EFSCRYPTO");
        this.addExtKeyUsage("1.3.6.1.4.1.311.10.3.4.1", "EKU_MS_EFSRECOVERY");
        this.addExtKeyUsage("2.16.840.1.113741.1.2.3", "EKU_INTEL_AMT");
        this.addExtKeyUsage("0.4.0.2231.3.0", "EKU_ETSI_TSLSIGNING");
        this.addExtKeyUsage("1.2.840.113583.1.1.5", "EKU_ADOBE_PDFSIGNING");
        this.addExtKeyUsage("1.2.203.7064.1.1.369791.1", "EKU_CSN_TLSCLIENT");
        this.addExtKeyUsage("1.2.203.7064.1.1.369791.2", "EKU_CSN_TLSSERVER");
        this.addExtKeyUsage("1.3.6.1.5.2.3.4", "EKU_KRB_PKINIT_CLIENT");
        this.addExtKeyUsage("1.3.6.1.5.2.3.5", "EKU_KRB_PKINIT_KDC");
        this.addExtKeyUsage("2.23.136.1.1.3", "EKU_ICAO_MASTERLISTSIGNING");
        this.addExtKeyUsage("2.16.840.1.101.3.6.8", "EKU_NIST_PIVCARDAUTH");
    }

    public AvailableExtendedKeyUsagesConfiguration(Serializable dataobj) {
        LinkedHashMap d;
        this.data = d = (LinkedHashMap)dataobj;
    }

    @Override
    public String getConfigurationId() {
        return CONFIGURATION_ID;
    }

    public boolean isExtendedKeyUsageSupported(String oid) {
        return this.data.containsKey(oid.trim());
    }

    public void addExtKeyUsage(String oid, String name) {
        this.data.put(oid.trim(), name);
    }

    public void removeExtKeyUsage(String oid) {
        this.data.remove(oid.trim());
    }

    public String getExtKeyUsageName(String oid) {
        String name = (String)this.data.get(oid = oid.trim());
        if (name == null) {
            name = oid;
        }
        return name;
    }

    public List<String> getAllOIDs() {
        Set keyset = this.data.keySet();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object k : keyset) {
            if (StringUtils.equalsIgnoreCase((String)((String)k), (String)"version")) continue;
            keys.add((String)k);
        }
        return keys;
    }

    public Map<String, String> getAllEKUOidsAndNames() {
        Map ret = (Map)this.saveData();
        ret.remove("version");
        return ret;
    }

    public Properties getAsProperties() {
        Properties properties = new Properties();
        Map<String, String> allEkus = this.getAllEKUOidsAndNames();
        for (Map.Entry<String, String> eku : allEkus.entrySet()) {
            properties.setProperty(eku.getKey(), eku.getValue());
        }
        return properties;
    }

    @Override
    public void upgrade() {
    }
}

