/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.cesecore.config.ConfigurationHolder;

public final class CesecoreConfiguration {
    private static final Logger log = Logger.getLogger(CesecoreConfiguration.class);
    public static final String PERSISTENCE_UNIT = "ejbca";
    public static final String AVAILABLE_CIPHER_SUITES_SPLIT_CHAR = ";";
    private static final String TRUE = "true";
    private static final String FORBIDDEN_CARACTERS_KEY = "forbidden.characters";

    private CesecoreConfiguration() {
    }

    public static String getDataSourceJndiName() {
        String prefix = ConfigurationHolder.getString("datasource.jndi-name-prefix");
        String name = ConfigurationHolder.getString("datasource.jndi-name");
        return prefix + name;
    }

    public static String getCaKeyStorePass() {
        return ConfigurationHolder.getExpandedString("ca.keystorepass");
    }

    public static int getCaSerialNumberOctetSize() {
        String value = ConfigurationHolder.getString("ca.serialnumberoctetsize");
        if (StringUtils.isEmpty((String)value)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using default value of 8 for ca.serialnumberoctetsize");
            }
            value = "8";
        }
        return Integer.parseInt(value);
    }

    public static String getCaSerialNumberAlgorithm() {
        return ConfigurationHolder.getString("ca.rngalgorithm");
    }

    public static String getCaTooLateExpireDate() {
        return ConfigurationHolder.getExpandedString("ca.toolateexpiredate");
    }

    public static boolean isPermitExtractablePrivateKeys() {
        String value = ConfigurationHolder.getString("ca.doPermitExtractablePrivateKeys");
        return value != null && value.trim().equalsIgnoreCase(TRUE);
    }

    public static String getInternalResourcesPreferredLanguage() {
        return ConfigurationHolder.getExpandedString("intresources.preferredlanguage");
    }

    public static String getInternalResourcesSecondaryLanguage() {
        return ConfigurationHolder.getExpandedString("intresources.secondarylanguage");
    }

    public static String getEcdsaImplicitlyCaQ() {
        return ConfigurationHolder.getExpandedString("ecdsa.implicitlyca.q");
    }

    public static String getEcdsaImplicitlyCaA() {
        return ConfigurationHolder.getExpandedString("ecdsa.implicitlyca.a");
    }

    public static String getEcdsaImplicitlyCaB() {
        return ConfigurationHolder.getExpandedString("ecdsa.implicitlyca.b");
    }

    public static String getEcdsaImplicitlyCaG() {
        return ConfigurationHolder.getExpandedString("ecdsa.implicitlyca.g");
    }

    public static String getEcdsaImplicitlyCaN() {
        return ConfigurationHolder.getExpandedString("ecdsa.implicitlyca.n");
    }

    public static boolean isDevelopmentProviderInstallation() {
        return TRUE.equalsIgnoreCase(ConfigurationHolder.getString("development.provider.installation"));
    }

    public static long getCacheCaTimeInCaSession() {
        return CesecoreConfiguration.getLongValue("cainfo.cachetime", 10000L, "milliseconds to cache CA info");
    }

    public static long getCacheTimeCryptoToken() {
        return CesecoreConfiguration.getLongValue("cryptotoken.cachetime", 10000L, "milliseconds");
    }

    public static long getCacheTimeInternalKeyBinding() {
        return CesecoreConfiguration.getLongValue("internalkeybinding.cachetime", 10000L, "milliseconds");
    }

    public static long getCacheCertificateProfileTime() {
        return CesecoreConfiguration.getLongValue("certprofiles.cachetime", 1000L, "milliseconds to cache Certificate profiles");
    }

    public static long getCacheGlobalOcspConfigurationTime() {
        return CesecoreConfiguration.getLongValue("ocspconfigurationcache.cachetime", 30000L, "milliseconds to cache OCSP settings");
    }

    public static long getCacheAuthorizationTime() {
        return CesecoreConfiguration.getLongValue("authorization.cachetime", 30000L, "milliseconds to cache authorization");
    }

    private static long getLongValue(String propertyName, long defaultValue, String unit) {
        String value = ConfigurationHolder.getString(propertyName);
        long time = defaultValue;
        try {
            if (value != null) {
                time = Long.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid value for " + propertyName + ". Using default " + defaultValue + ". Value must be decimal number (" + unit + "): " + e.getMessage()));
        }
        return time;
    }

    public static Class<?> getTrustedTimeProvider() throws ClassNotFoundException {
        String providerClass = ConfigurationHolder.getString("time.provider");
        if (log.isDebugEnabled()) {
            log.debug((Object)("TrustedTimeProvider class: " + providerClass));
        }
        return Class.forName(providerClass);
    }

    public static Pattern getTrustedTimeNtpPattern() {
        String regex = ConfigurationHolder.getString("time.ntp.pattern");
        return Pattern.compile(regex);
    }

    public static String getTrustedTimeNtpCommand() {
        return ConfigurationHolder.getString("time.ntp.command");
    }

    public static boolean isKeepJbossSerializationIfUsed() {
        String value = ConfigurationHolder.getString("db.keepjbossserialization");
        return value != null && value.trim().equalsIgnoreCase(TRUE);
    }

    public static boolean isKeepInternalCAKeystores() {
        String value = ConfigurationHolder.getString("db.keepinternalcakeystores");
        return value == null || !value.trim().equalsIgnoreCase("false");
    }

    public static String getNodeIdentifier() {
        String PROPERTY_NAME = "cluster.nodeid";
        String PROPERTY_VALUE = "undefined";
        String value = ConfigurationHolder.getString("cluster.nodeid");
        if (value == null) {
            try {
                value = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.warn((Object)"cluster.nodeid is undefined on this host and was not able to resolve hostname. Using undefined which is fine if use a single node.");
                value = "undefined";
            }
            ConfigurationHolder.updateConfiguration("cluster.nodeid", value);
        }
        return value;
    }

    public static String getOidGost3410() {
        return ConfigurationHolder.getString("extraalgs.gost3410.oidtree");
    }

    public static String getOidDstu4145() {
        return ConfigurationHolder.getString("extraalgs.dstu4145.oidtree");
    }

    public static List<String> getExtraAlgs() {
        return ConfigurationHolder.getPrefixedPropertyNames("extraalgs");
    }

    public static List<String> getExtraAlgSubAlgs(String algName) {
        return ConfigurationHolder.getPrefixedPropertyNames("extraalgs." + algName + ".subalgs");
    }

    public static String getExtraAlgSubAlgTitle(String algName, String subAlg) {
        String name = ConfigurationHolder.getString("extraalgs." + algName + ".subalgs." + subAlg + ".title");
        if (name == null) {
            String end = ConfigurationHolder.getString("extraalgs." + algName + ".subalgs." + subAlg + ".name");
            if (end == null) {
                end = subAlg;
            }
            name = ConfigurationHolder.getString("extraalgs." + algName + ".title") + " " + end;
        }
        return name;
    }

    public static String getExtraAlgSubAlgName(String algName, String subAlg) {
        String name = ConfigurationHolder.getString("extraalgs." + algName + ".subalgs." + subAlg + ".name");
        if (name == null) {
            name = CesecoreConfiguration.getExtraAlgSubAlgOid(algName, subAlg);
        }
        return name;
    }

    public static String getExtraAlgSubAlgOid(String algName, String subAlg) {
        String oidTree = ConfigurationHolder.getString("extraalgs." + algName + ".oidtree");
        String oidEnd = ConfigurationHolder.getString("extraalgs." + algName + ".subalgs." + subAlg + ".oid");
        if (oidEnd != null && oidTree != null) {
            return oidTree + "." + oidEnd;
        }
        if (oidEnd != null) {
            return oidEnd;
        }
        return null;
    }

    public static boolean useBase64CertTable() {
        String value = ConfigurationHolder.getString("database.useSeparateCertificateTable");
        return value != null && Boolean.parseBoolean(value.trim());
    }

    public static boolean useDatabaseIntegrityProtection(String tableName) {
        String enableProtect = ConfigurationHolder.getString("databaseprotection.enablesign." + tableName);
        if (enableProtect != null) {
            return Boolean.TRUE.toString().equalsIgnoreCase(enableProtect);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(ConfigurationHolder.getString("databaseprotection.enablesign"));
    }

    public static boolean useDatabaseIntegrityVerification(String tableName) {
        String enableVerify = ConfigurationHolder.getString("databaseprotection.enableverify." + tableName);
        if (enableVerify != null) {
            return Boolean.TRUE.toString().equalsIgnoreCase(enableVerify);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(ConfigurationHolder.getString("databaseprotection.enableverify"));
    }

    public static boolean getCaKeepOcspExtendedService() {
        return Boolean.valueOf(ConfigurationHolder.getString("ca.keepocspextendedservice").toLowerCase());
    }

    public static int getDatabaseRevokedCertInfoFetchSize() {
        return Long.valueOf(CesecoreConfiguration.getLongValue("database.crlgenfetchsize", 500000L, "rows")).intValue();
    }

    public static char[] getForbiddenCharacters() {
        String s = ConfigurationHolder.instance().getString(FORBIDDEN_CARACTERS_KEY);
        if (s == null) {
            return ConfigurationHolder.getDefaultValue(FORBIDDEN_CARACTERS_KEY).toCharArray();
        }
        return s.toCharArray();
    }

    public static boolean p11disableHashingSignMechanisms() {
        String value = ConfigurationHolder.getString("pkcs11.disableHashingSignMechanisms");
        return value == null || Boolean.parseBoolean(value.trim());
    }

    public static boolean isKeyStoreCacheEnabled() {
        return Boolean.parseBoolean(ConfigurationHolder.getString("cryptotoken.keystorecache"));
    }

    public static String[] getAvailableCipherSuites() {
        ArrayList<String> availableCipherSuites = new ArrayList<String>();
        for (int i = 0; i < 255; ++i) {
            String key = "authkeybind.ciphersuite." + i;
            String value = ConfigurationHolder.getString(key);
            if (value == null || value.indexOf(AVAILABLE_CIPHER_SUITES_SPLIT_CHAR) == -1) continue;
            availableCipherSuites.add(value);
        }
        return availableCipherSuites.toArray(new String[0]);
    }

    public static long getCTCacheMaxEntries() {
        return CesecoreConfiguration.getLongValue("ct.cache.maxentries", 100000L, "number of entries in cache");
    }

    public static long getCTCacheCleanupInterval() {
        return CesecoreConfiguration.getLongValue("ct.cache.cleanupinterval", 10000L, "milliseconds between periodic cache cleanup");
    }

    public static boolean getCTCacheEnabled() {
        String value = ConfigurationHolder.getString("ct.cache.enabled");
        return value == null || !value.trim().equalsIgnoreCase("false");
    }

    public static boolean getCTFastFailEnabled() {
        String value = ConfigurationHolder.getString("ct.fastfail.enabled");
        return value != null && value.trim().equalsIgnoreCase(TRUE);
    }

    public static long getCTFastFailBackOff() {
        return CesecoreConfiguration.getLongValue("ct.fastfail.backoff", 1000L, "milliseconds");
    }
}

