/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.config;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;

public final class ConfigurationHolder {
    private static final Logger log = Logger.getLogger(ConfigurationHolder.class);
    private static volatile CompositeConfiguration defaultValues;
    private static CompositeConfiguration config;
    private static CompositeConfiguration configBackup;
    private static final String[] CONFIG_FILES;
    private static final String CONFIGALLOWEXTERNAL = "allow.external-dynamic.configuration";
    private static final String DEFAULT_CONFIG_FILE = "/defaultvalues.properties";

    private ConfigurationHolder() {
    }

    public static synchronized Configuration instance() {
        if (config == null) {
            PropertiesConfiguration pc;
            defaultValues = new CompositeConfiguration();
            URL defaultConfigUrl = ConfigurationHolder.class.getResource(DEFAULT_CONFIG_FILE);
            try {
                defaultValues.addConfiguration((Configuration)new PropertiesConfiguration(defaultConfigUrl));
            }
            catch (ConfigurationException e) {
                log.error((Object)("Error encountered when loading default properties. Could not load configuration from " + defaultConfigUrl), (Throwable)e);
            }
            boolean allowexternal = false;
            try {
                URL url = ConfigurationHolder.class.getResource("/conf/" + CONFIG_FILES[0]);
                if (url != null) {
                    pc = new PropertiesConfiguration(url);
                    allowexternal = "true".equalsIgnoreCase(pc.getString(CONFIGALLOWEXTERNAL, "false"));
                    log.info((Object)("Allow external re-configuration: " + allowexternal));
                }
            }
            catch (ConfigurationException e) {
                log.error((Object)"Error intializing configuration: ", (Throwable)e);
            }
            config = new CompositeConfiguration();
            if (allowexternal) {
                PropertiesConfiguration pc2;
                File f;
                int i;
                config.addConfiguration((Configuration)new SystemConfiguration());
                log.info((Object)"Added system properties to configuration source (java -Dfoo.prop=bar).");
                for (i = 0; i < CONFIG_FILES.length; ++i) {
                    f = null;
                    try {
                        f = new File("conf" + File.separator + CONFIG_FILES[i]);
                        pc2 = new PropertiesConfiguration(f);
                        pc2.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
                        config.addConfiguration((Configuration)pc2);
                        log.info((Object)("Added file to configuration source: " + f.getAbsolutePath()));
                        continue;
                    }
                    catch (ConfigurationException e) {
                        log.error((Object)("Failed to load configuration from file " + f.getAbsolutePath()));
                    }
                }
                for (i = 0; i < CONFIG_FILES.length; ++i) {
                    f = null;
                    try {
                        f = new File("/etc/cesecore/conf/" + CONFIG_FILES[i]);
                        pc2 = new PropertiesConfiguration(f);
                        pc2.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
                        config.addConfiguration((Configuration)pc2);
                        log.info((Object)("Added file to configuration source: " + f.getAbsolutePath()));
                        continue;
                    }
                    catch (ConfigurationException e) {
                        log.error((Object)("Failed to load configuration from file " + f.getAbsolutePath()));
                    }
                }
            }
            for (int i = 0; i < CONFIG_FILES.length; ++i) {
                ConfigurationHolder.addConfigurationResource("/conf/" + CONFIG_FILES[i]);
            }
            try {
                URL url = ConfigurationHolder.class.getResource("/internal.properties");
                if (url != null) {
                    pc = new PropertiesConfiguration(url);
                    config.addConfiguration((Configuration)pc);
                    log.debug((Object)("Added url to configuration source: " + url));
                }
            }
            catch (ConfigurationException e) {
                log.error((Object)"Failed to load configuration from resource internal.properties", (Throwable)e);
            }
        }
        return config;
    }

    public static void addConfigurationFile(String filename) {
        ConfigurationHolder.instance();
        File f = null;
        try {
            f = new File(filename);
            PropertiesConfiguration pc = new PropertiesConfiguration(f);
            pc.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            config.addConfiguration((Configuration)pc);
            log.info((Object)("Added file to configuration source: " + f.getAbsolutePath()));
        }
        catch (ConfigurationException e) {
            log.error((Object)("Failed to load configuration from file " + f.getAbsolutePath()));
        }
    }

    public static void addConfigurationResource(String resourcename) {
        ConfigurationHolder.instance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add resource to configuration: " + resourcename));
        }
        try {
            URL url = ConfigurationHolder.class.getResource(resourcename);
            if (url != null) {
                PropertiesConfiguration pc = new PropertiesConfiguration(url);
                config.addConfiguration((Configuration)pc);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added url to configuration source: " + url));
                }
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)("Failed to load configuration from resource " + resourcename), (Throwable)e);
        }
    }

    public static Properties getAsProperties() {
        Properties properties = new Properties();
        Iterator i = ConfigurationHolder.instance().getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            properties.setProperty(key, ConfigurationHolder.instance().getString(key));
        }
        return properties;
    }

    public static String getString(String property) {
        StringBuilder str = new StringBuilder();
        String[] rets = ConfigurationHolder.instance().getStringArray(property);
        if (rets.length == 0) {
            rets = defaultValues.getStringArray(property);
        }
        for (int i = 0; i < rets.length; ++i) {
            if (i != 0) {
                str.append(',');
            }
            str.append(rets[i]);
        }
        String ret = str.length() != 0 ? str.toString() : defaultValues.getString(property);
        return ret;
    }

    public static String getDefaultValue(String property) {
        ConfigurationHolder.instance();
        return defaultValues.getString(property);
    }

    public static String[] getDefaultValueArray(String property) {
        ConfigurationHolder.instance();
        return defaultValues.getStringArray(property);
    }

    public static String getExpandedString(String property) {
        String ret = ConfigurationHolder.getString(property);
        if (ret != null) {
            while (ret.indexOf("${") != -1) {
                ret = ConfigurationHolder.interpolate(ret);
            }
        }
        return ret;
    }

    private static String interpolate(String orderString) {
        Pattern PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher m = PATTERN.matcher(orderString);
        StringBuffer sb = new StringBuffer(orderString.length());
        m.reset();
        while (m.find()) {
            String key = m.group(1);
            String value = ConfigurationHolder.getExpandedString(key);
            if (value != null) {
                m.appendReplacement(sb, value);
                continue;
            }
            m.appendReplacement(sb, "");
            String unknown = m.group(0);
            sb.append(unknown);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static List<String> getPrefixedPropertyNames(String prefix) {
        prefix = prefix + ".";
        HashSet<String> algs = new HashSet<String>();
        Properties props = ConfigurationHolder.getAsProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            int dot = key.indexOf(".", prefix.length());
            algs.add(key.substring(prefix.length(), dot));
        }
        ArrayList<String> list = new ArrayList<String>(algs);
        Collections.sort(list);
        return list;
    }

    public static boolean backupConfiguration() {
        if (configBackup != null) {
            return false;
        }
        ConfigurationHolder.instance();
        configBackup = (CompositeConfiguration)config.clone();
        return true;
    }

    public static boolean restoreConfiguration() {
        if (configBackup == null) {
            return false;
        }
        config = configBackup;
        configBackup = null;
        return true;
    }

    public static boolean updateConfiguration(Properties properties) {
        ConfigurationHolder.backupConfiguration();
        for (Object key : properties.keySet()) {
            String value = (String)properties.get((String)key);
            config.setProperty((String)key, (Object)value);
        }
        return true;
    }

    public static boolean updateConfiguration(String key, String value) {
        ConfigurationHolder.backupConfiguration();
        config.setProperty(key, (Object)value);
        return true;
    }

    static {
        config = null;
        configBackup = null;
        CONFIG_FILES = new String[]{"cesecore.properties", "extendedkeyusage.properties", "cache.properties", "database.properties", "databaseprotection.properties", "backup.properties", "va.properties", "ocsp.properties"};
    }
}

