/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.config;

import org.cesecore.configuration.ConfigurationBase;
import org.cesecore.util.CertTools;

public class GlobalOcspConfiguration
extends ConfigurationBase {
    public static final String OCSP_CONFIGURATION_ID = "OCSP";
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_OCSP_RESPONDER_REFERENCE = "defaultOcspResponderReference";

    public String getOcspDefaultResponderReference() {
        return CertTools.stringToBCDNString((String)this.data.get(DEFAULT_OCSP_RESPONDER_REFERENCE));
    }

    public void setOcspDefaultResponderReference(String reference) {
        this.data.put(DEFAULT_OCSP_RESPONDER_REFERENCE, reference);
    }

    @Override
    public void upgrade() {
        if (Float.compare(3.0f, this.getVersion()) != 0) {
            this.data.put("version", Float.valueOf(3.0f));
        }
    }

    @Override
    public String getConfigurationId() {
        return OCSP_CONFIGURATION_ID;
    }
}

