/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.cesecore.config.ConfigurationHolder;
import org.cesecore.util.CertTools;

public class OcspConfiguration {
    private static final Logger log = Logger.getLogger(OcspConfiguration.class);
    @Deprecated
    public static final String DEFAULT_RESPONDER = "ocsp.defaultresponder";
    public static final String SIGNING_CERTD_VALID_TIME = "ocsp.signingCertsValidTime";
    public static final String SIGNING_TRUSTSTORE_VALID_TIME = "ocsp.signtrustvalidtime";
    public static final String SIGNATUREREQUIRED = "ocsp.signaturerequired";
    public static final String CARD_PASSWORD = "ocsp.keys.cardPassword";
    public static final String REKEYING_WSURL = "ocsp.rekeying.wsurl";
    public static final String WARNING_BEFORE_EXPERATION_TIME = "ocsp.warningBeforeExpirationTime";
    public static final String NONE_EXISTING_IS_GOOD = "ocsp.nonexistingisgood";
    public static final String NONE_EXISTING_IS_GOOD_URI = "ocsp.nonexistingisgood.uri.";
    public static final String NONE_EXISTING_IS_BAD_URI = "ocsp.nonexistingisbad.uri.";
    public static final String NONE_EXISTING_IS_REVOKED = "ocsp.nonexistingisrevoked";
    public static final String NONE_EXISTING_IS_REVOKED_URI = "ocsp.nonexistingisrevoked.uri.";
    public static final String REKEYING_TRIGGERING_HOSTS = "ocsp.rekeying.trigging.hosts";
    public static final String REKEYING_TRIGGERING_PASSWORD = "ocsp.rekeying.trigging.password";
    public static final String REKEYING_UPDATE_TIME_IN_SECONDS = "ocsp.rekeying.update.time.in.seconds";
    public static final String REKEYING_SAFETY_MARGIN_IN_SECONDS = "ocsp.rekeying.safety.margin.in.seconds";
    public static final String EXPIREDCERT_RETENTIONPERIOD = "ocsp.expiredcert.retentionperiod";
    public static final String UNTIL_NEXT_UPDATE = "ocsp.untilNextUpdate";
    public static final String REVOKED_UNTIL_NEXT_UPDATE = "ocsp.revoked.untilNextUpdate";
    public static final String MAX_AGE = "ocsp.maxAge";
    public static final String REVOKED_MAX_AGE = "ocsp.revoked.maxAge";
    public static final String INCLUDE_SIGNING_CERT = "ocsp.includesignercert";
    public static final String INCLUDE_CERT_CHAIN = "ocsp.includecertchain";
    public static final String RESPONDER_ID_TYPE = "ocsp.responderidtype";
    @Deprecated
    public static final int RESTRICTONISSUER = 0;
    @Deprecated
    public static final int RESTRICTONSIGNER = 1;
    public static final int RESPONDERIDTYPE_NAME = 1;
    public static final int RESPONDERIDTYPE_KEYHASH = 2;
    public static Set<String> acceptedSignatureAlgorithms = new HashSet<String>();

    public static String getSignatureAlgorithm() {
        return ConfigurationHolder.getString("ocsp.signaturealgorithm");
    }

    public static boolean isAcceptedSignatureAlgorithm(String sigAlg) {
        if (acceptedSignatureAlgorithms.size() == 0) {
            String[] algs;
            for (String alg : algs = OcspConfiguration.getSignatureAlgorithm().split(";")) {
                acceptedSignatureAlgorithms.add(alg);
            }
        }
        return acceptedSignatureAlgorithms.contains(sigAlg);
    }

    public static long getRekeyingUpdateTimeInSeconds() {
        return Long.parseLong(ConfigurationHolder.getString(REKEYING_UPDATE_TIME_IN_SECONDS));
    }

    public static long getRekeyingSafetyMarginInSeconds() {
        return Long.parseLong(ConfigurationHolder.getString(REKEYING_SAFETY_MARGIN_IN_SECONDS));
    }

    public static int getSigningCertsValidTimeInMilliseconds() {
        int timeInSeconds;
        int defaultTimeInSeconds = 300;
        try {
            timeInSeconds = Integer.parseInt(ConfigurationHolder.getString(SIGNING_CERTD_VALID_TIME));
        }
        catch (NumberFormatException e) {
            timeInSeconds = 300;
            log.warn((Object)"ocsp.signingCertsValidTime is not a decimal integer. Using default 5 minutes");
        }
        return timeInSeconds * 1000;
    }

    public static boolean getEnforceRequestSigning() {
        String value = ConfigurationHolder.getString(SIGNATUREREQUIRED);
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    @Deprecated
    public static boolean getRestrictSignatures() {
        String value = ConfigurationHolder.getString("ocsp.restrictsignatures");
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    @Deprecated
    public static int getRestrictSignaturesByMethod() {
        if ("signer".equalsIgnoreCase(ConfigurationHolder.getString("ocsp.restrictsignaturesbymethod"))) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public static String getSignTrustDir() {
        return ConfigurationHolder.getString("ocsp.signtrustdir");
    }

    public static boolean getIncludeCertChain() {
        String value = ConfigurationHolder.getString(INCLUDE_CERT_CHAIN);
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static boolean getIncludeSignCert() {
        String value = ConfigurationHolder.getString(INCLUDE_SIGNING_CERT);
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static int getResponderIdType() {
        if ("name".equalsIgnoreCase(ConfigurationHolder.getString(RESPONDER_ID_TYPE))) {
            return 1;
        }
        return 2;
    }

    public static boolean getNonExistingIsGood() {
        String value = ConfigurationHolder.getString(NONE_EXISTING_IS_GOOD);
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static boolean getNonExistingIsRevoked() {
        String value = ConfigurationHolder.getString(NONE_EXISTING_IS_REVOKED);
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    private static String getRegex(String prefix) {
        String key;
        String value;
        int i = 1;
        StringBuffer regex = new StringBuffer();
        while ((value = ConfigurationHolder.getString(key = prefix + i)) != null) {
            if (i > 1) {
                regex.append('|');
            }
            regex.append('(');
            regex.append(value);
            regex.append(')');
            ++i;
        }
        if (regex.length() < 1) {
            return null;
        }
        return regex.toString();
    }

    public static String getNonExistingIsGoodOverideRegex() {
        return OcspConfiguration.getRegex(NONE_EXISTING_IS_GOOD_URI);
    }

    public static String getNonExistingIsBadOverideRegex() {
        return OcspConfiguration.getRegex(NONE_EXISTING_IS_BAD_URI);
    }

    public static String getNonExistingIsRevokedOverideRegex() {
        return OcspConfiguration.getRegex(NONE_EXISTING_IS_REVOKED_URI);
    }

    @Deprecated
    public static String getDefaultResponderId() {
        String ret = ConfigurationHolder.getExpandedString(DEFAULT_RESPONDER);
        if (ret != null) {
            return CertTools.stringToBCDNString(ret);
        }
        return ret;
    }

    public static List<String> getExtensionOids() {
        String value = ConfigurationHolder.getString("ocsp.extensionoid");
        if ("".equals(value)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(value.split(";"));
    }

    public static List<String> getExtensionClasses() {
        String value = ConfigurationHolder.getString("ocsp.extensionclass");
        if ("".equals(value)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(value.split(";"));
    }

    public static String getUnidDataSource() {
        return ConfigurationHolder.getString("ocsp.uniddatsource");
    }

    public static String getUnidTrustDir() {
        return ConfigurationHolder.getString("ocsp.unidtrustdir");
    }

    public static String getUnidCaCert() {
        return ConfigurationHolder.getString("ocsp.unidcacert");
    }

    public static boolean getAuditLog() {
        String value = ConfigurationHolder.getString("ocsp.audit-log");
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static String getLogDateFormat() {
        return ConfigurationHolder.getString("ocsp.log-date");
    }

    public static String getLogTimeZone() {
        return ConfigurationHolder.getString("ocsp.log-timezone");
    }

    public static boolean getLogSafer() {
        String value = ConfigurationHolder.getString("ocsp.log-safer");
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static String getAuditLogPattern() {
        return ConfigurationHolder.getString("ocsp.audit-log-pattern");
    }

    public static String getAuditLogOrder() {
        String value = ConfigurationHolder.getString("ocsp.audit-log-order");
        value = value.replace("\\\"", "\"");
        return value;
    }

    public static boolean getHealthCheckSignTest() {
        return ConfigurationHolder.getString("ocsphealthcheck.signtest").toLowerCase().indexOf("false") < 0;
    }

    public static boolean getHealthCheckCertificateValidity() {
        return ConfigurationHolder.getString("ocsphealthcheck.checkSigningCertificateValidity").toLowerCase().indexOf("false") < 0;
    }

    public static boolean getTransactionLog() {
        String value = ConfigurationHolder.getString("ocsp.trx-log");
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static String getTransactionLogPattern() {
        return ConfigurationHolder.getString("ocsp.trx-log-pattern");
    }

    public static String getTransactionLogOrder() {
        String value = ConfigurationHolder.getString("ocsp.trx-log-order");
        value = value.replace("\\\"", "\"");
        return value;
    }

    public static long getExpiredArchiveCutoff() {
        Configuration config = ConfigurationHolder.instance();
        if (StringUtils.equals((String)config.getString(EXPIREDCERT_RETENTIONPERIOD), (String)"-1")) {
            return -1L;
        }
        long value = 31536000L;
        try {
            value = config.getLong(EXPIREDCERT_RETENTIONPERIOD, value) * 1000L;
        }
        catch (ConversionException e) {
            log.warn((Object)("\"ocsp.expiredcert.retentionperiod\" is not a decimal integer. Using default value: " + value));
        }
        return value;
    }

    public static long getUntilNextUpdate(int certProfileId) {
        long value = 0L;
        Configuration config = ConfigurationHolder.instance();
        String key = "ocsp." + certProfileId + ".untilNextUpdate";
        if (certProfileId == 0 || !config.containsKey(key)) {
            key = UNTIL_NEXT_UPDATE;
        }
        try {
            value = config.getLong(key, value) * 1000L;
        }
        catch (ConversionException e) {
            log.warn((Object)("\"ocsp.untilNextUpdate\" is not a decimal integer. Using default value: " + value));
        }
        return value;
    }

    public static boolean isUntilNextUpdateConfigured(int certificateProfileId) {
        if (certificateProfileId == 0) {
            return ConfigurationHolder.instance().containsKey(UNTIL_NEXT_UPDATE);
        }
        return ConfigurationHolder.instance().containsKey("ocsp." + certificateProfileId + ".untilNextUpdate");
    }

    public static long getRevokedUntilNextUpdate(int certProfileId) {
        long value = 0L;
        Configuration config = ConfigurationHolder.instance();
        String key = "ocsp." + certProfileId + ".revoked.untilNextUpdate";
        if (certProfileId == 0 || !config.containsKey(key)) {
            key = REVOKED_UNTIL_NEXT_UPDATE;
        }
        try {
            value = config.getLong(key, value) * 1000L;
        }
        catch (ConversionException e) {
            log.warn((Object)("\"ocsp.revoked.untilNextUpdate\" is not a decimal integer. Using default value: " + value));
        }
        return value;
    }

    public static boolean isRevokedUntilNextUpdateConfigured(int certificateProfileId) {
        if (certificateProfileId == 0) {
            return ConfigurationHolder.instance().containsKey(REVOKED_UNTIL_NEXT_UPDATE);
        }
        return ConfigurationHolder.instance().containsKey("ocsp." + certificateProfileId + ".revoked.untilNextUpdate");
    }

    public static long getMaxAge(int certProfileId) {
        long value = 30L;
        Configuration config = ConfigurationHolder.instance();
        String key = "ocsp." + certProfileId + ".maxAge";
        if (certProfileId == 0 || !config.containsKey(key)) {
            key = MAX_AGE;
        }
        try {
            value = config.getLong(key, value) * 1000L;
        }
        catch (ConversionException e) {
            log.warn((Object)("\"ocsp.maxAge\" is not a decimal integer. Using default value: " + (value *= 1000L)));
        }
        return value;
    }

    public static boolean isMaxAgeConfigured(int certificateProfileId) {
        if (certificateProfileId == 0) {
            return ConfigurationHolder.instance().containsKey(MAX_AGE);
        }
        return ConfigurationHolder.instance().containsKey("ocsp." + certificateProfileId + ".maxAge");
    }

    public static long getRevokedMaxAge(int certProfileId) {
        long value = 30L;
        Configuration config = ConfigurationHolder.instance();
        String key = "ocsp." + certProfileId + ".revoked.maxAge";
        if (certProfileId == 0 || !config.containsKey(key)) {
            key = REVOKED_MAX_AGE;
        }
        try {
            value = config.getLong(key, value) * 1000L;
        }
        catch (ConversionException e) {
            log.warn((Object)("\"ocsp.revoked.maxAge\" is not a decimal integer. Using default value: " + (value *= 1000L)));
        }
        return value;
    }

    public static boolean isRevokedMaxAgeConfigured(int certificateProfileId) {
        if (certificateProfileId == 0) {
            return ConfigurationHolder.instance().containsKey(REVOKED_MAX_AGE);
        }
        return ConfigurationHolder.instance().containsKey("ocsp." + certificateProfileId + ".revoked.maxAge");
    }

    @Deprecated
    public static String getSoftKeyDirectoryName() {
        return ConfigurationHolder.getString("ocsp.keys.dir");
    }

    @Deprecated
    public static String getKeyPassword() {
        String value = ConfigurationHolder.getString("ocsp.keys.keyPassword");
        if (value != null) {
            return value;
        }
        return OcspConfiguration.getStorePassword();
    }

    @Deprecated
    public static String getStorePassword() {
        return ConfigurationHolder.getString("ocsp.keys.storePassword");
    }

    public static String getCardPassword() {
        return ConfigurationHolder.getString(CARD_PASSWORD);
    }

    public static String getHardTokenClassName() {
        return ConfigurationHolder.getString("ocsp.hardToken.className");
    }

    @Deprecated
    public static String getSunP11ConfigurationFile() {
        return ConfigurationHolder.getString("ocsp.p11.sunConfigurationFile");
    }

    public static Set<String> getRekeyingTriggingHosts() {
        String sHosts = ConfigurationHolder.getString(REKEYING_TRIGGERING_HOSTS);
        if (sHosts == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(Arrays.asList(StringUtils.split((String)sHosts.trim(), (char)';')));
    }

    public static String getRekeyingTriggingPassword() {
        return ConfigurationHolder.getString(REKEYING_TRIGGERING_PASSWORD);
    }

    public static String getEjbcawsracliUrl() {
        return ConfigurationHolder.getString(REKEYING_WSURL);
    }

    @Deprecated
    public static String getP11SharedLibrary() {
        return ConfigurationHolder.getString("ocsp.p11.sharedLibrary");
    }

    @Deprecated
    public static String getP11Password() {
        return ConfigurationHolder.getString("ocsp.p11.p11password");
    }

    @Deprecated
    public static String getP11SlotIndex() {
        return ConfigurationHolder.getString("ocsp.p11.slot");
    }

    @Deprecated
    public static boolean getDoNotStorePasswordsInMemory() {
        String s = ConfigurationHolder.getString("ocsp.activation.doNotStorePasswordsInMemory");
        return s != null && s.toLowerCase().indexOf("false") < 0 && s.toLowerCase().indexOf("no") < 0;
    }

    public static long getWarningBeforeExpirationTime() {
        int timeInSeconds = 0;
        int defaultTimeInSeconds = 604800;
        try {
            String configValue = ConfigurationHolder.getString(WARNING_BEFORE_EXPERATION_TIME);
            timeInSeconds = configValue != null ? Integer.parseInt(configValue) : 604800;
        }
        catch (NumberFormatException e) {
            timeInSeconds = 604800;
            log.warn((Object)"ocsp.warningBeforeExpirationTime is not a decimal integer. Using default 1 week.");
        }
        return 1000L * (long)timeInSeconds;
    }
}

