/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.internal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.cesecore.config.CesecoreConfiguration;

public class InternalResources
implements Serializable {
    private static final Logger log = Logger.getLogger(InternalResources.class);
    private static final long serialVersionUID = -1003L;
    protected static InternalResources instance = null;
    protected Properties primaryResource = new Properties();
    protected Properties secondaryResource = new Properties();
    private String[] placeHolders = null;
    private static final String RESOURCE_PATH = "/intresources";
    private static final String RESOURCE_NAME = "/intresources.";
    private static final String RESOURCE_LOCATION = "/intresources/intresources.";

    protected InternalResources() {
        this.setupResources(RESOURCE_LOCATION);
    }

    protected InternalResources(String resPath) {
        this.setupResources(resPath + RESOURCE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupResources(String resLocation) {
        block20: {
            String primaryLanguage = CesecoreConfiguration.getInternalResourcesPreferredLanguage().toLowerCase(Locale.ENGLISH);
            String secondaryLanguage = CesecoreConfiguration.getInternalResourcesSecondaryLanguage().toLowerCase(Locale.ENGLISH);
            InputStream primaryStream = null;
            InputStream secondaryStream = null;
            try {
                primaryStream = InternalResources.class.getResourceAsStream(resLocation + primaryLanguage + ".properties");
                if (primaryStream == null) {
                    try {
                        primaryStream = new FileInputStream(resLocation + primaryLanguage + ".properties");
                    }
                    catch (FileNotFoundException e) {
                        log.error((Object)"Localization files not found", (Throwable)e);
                    }
                }
                if ((secondaryStream = InternalResources.class.getResourceAsStream(resLocation + secondaryLanguage + ".properties")) == null) {
                    try {
                        secondaryStream = new FileInputStream(resLocation + secondaryLanguage + ".properties");
                    }
                    catch (FileNotFoundException e) {
                        log.error((Object)"Localization files not found", (Throwable)e);
                    }
                }
                try {
                    if (primaryStream != null) {
                        this.primaryResource.load(primaryStream);
                    } else {
                        log.warn((Object)"primaryResourse == null");
                    }
                    if (secondaryStream != null) {
                        this.secondaryResource.load(secondaryStream);
                        break block20;
                    }
                    log.warn((Object)"secondaryResource == null");
                }
                catch (IOException e) {
                    log.error((Object)"Error reading internal resourcefile", (Throwable)e);
                }
            }
            finally {
                try {
                    if (primaryStream != null) {
                        primaryStream.close();
                    }
                    if (secondaryStream != null) {
                        secondaryStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Error closing internal resources language streams: ", (Throwable)e);
                }
            }
        }
    }

    public static synchronized InternalResources getInstance() {
        if (instance == null) {
            instance = new InternalResources();
        }
        return instance;
    }

    public String getLocalizedMessage(String key, Object ... params) {
        return this.getLocalizedMessageCs(key, params).toString();
    }

    protected CharSequence getLocalizedMessageCs(String key, Object ... params) {
        StringBuilder sb = new StringBuilder();
        return this.getLocalizedMessageInternal(sb, key, params);
    }

    protected CharSequence getLocalizedMessageInternal(StringBuilder sb, String key, Object ... params) {
        if (sb.length() == 0) {
            if (this.primaryResource.containsKey(key)) {
                sb.append(this.primaryResource.getProperty(key));
            } else if (this.secondaryResource.containsKey(key)) {
                sb.append(this.secondaryResource.getProperty(key));
            } else {
                sb.append(key);
                for (Object param : params) {
                    if (param == null) continue;
                    sb.append(", ").append(param.toString());
                }
            }
        }
        for (int i = 0; i < params.length; ++i) {
            this.replaceAll(sb, i, params[i]);
        }
        this.removeUnusedPlaceHolders(sb, params.length);
        if (log.isTraceEnabled()) {
            log.trace((Object)(key + "=" + sb.toString()));
        }
        return sb;
    }

    private String[] getPlaceHolders() {
        if (this.placeHolders == null) {
            this.placeHolders = new String[100];
            for (int i = 0; i < this.placeHolders.length; ++i) {
                this.placeHolders[i] = new StringBuilder(123).append(i).append('}').toString();
            }
        }
        return this.placeHolders;
    }

    protected void replaceAll(StringBuilder sb, int placeHolderIndex, Object replacementObject) {
        if (sb == null) {
            log.error((Object)"No StringBuilder. Unable to create localized message.");
            return;
        }
        String[] placeHolders = this.getPlaceHolders();
        if (placeHolderIndex < 0 || placeHolderIndex > placeHolders.length - 1) {
            log.error((Object)"Place holder index out of range. Unable to create localized message.");
            return;
        }
        String placeHolder = placeHolders[placeHolderIndex];
        int placeHolderLength = placeHolder.length();
        int currentIndex = -placeHolderLength;
        if (replacementObject == null) {
            while ((currentIndex = sb.indexOf(placeHolder, currentIndex + placeHolderLength)) != -1) {
                sb.delete(currentIndex - 1, currentIndex + placeHolderLength);
            }
        } else {
            String replacement = replacementObject.toString();
            while ((currentIndex = sb.indexOf(placeHolder, currentIndex + placeHolderLength)) != -1) {
                sb.replace(currentIndex - 1, currentIndex + placeHolderLength, replacement);
            }
        }
    }

    protected void removeUnusedPlaceHolders(StringBuilder sb, int startPlaceHolderIndex) {
        String[] placeHolders = this.getPlaceHolders();
        if (startPlaceHolderIndex < 0 || startPlaceHolderIndex > placeHolders.length - 1) {
            log.error((Object)"Place holder index out of range. Unable to create localized message.");
            return;
        }
        for (int i = startPlaceHolderIndex; i < placeHolders.length; ++i) {
            String placeHolder = placeHolders[i];
            int placeHolderLength = placeHolder.length();
            int currentIndex = -placeHolderLength;
            boolean someThingRemoved = false;
            while ((currentIndex = sb.indexOf(placeHolder, currentIndex + placeHolderLength)) != -1) {
                sb.delete(currentIndex - 1, currentIndex + placeHolderLength);
                someThingRemoved = true;
            }
            if (!someThingRemoved) break;
        }
    }
}

