/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cesecore.internal.IUpgradeableData;
import org.cesecore.util.Base64GetHashMap;

public abstract class UpgradeableDataHashMap
implements IUpgradeableData,
Serializable {
    private static final long serialVersionUID = -1766329888474901945L;
    protected LinkedHashMap<Object, Object> data = new LinkedHashMap();
    private boolean upgraded = false;
    public static final String VERSION = "version";

    public UpgradeableDataHashMap() {
        this.data.put(VERSION, new Float(this.getLatestVersion()));
    }

    @Override
    public abstract float getLatestVersion();

    @Override
    public float getVersion() {
        return ((Float)this.data.get(VERSION)).floatValue();
    }

    @Override
    public Object saveData() {
        return this.data.clone();
    }

    @Override
    public void loadData(Object data) {
        this.data = new Base64GetHashMap((Map<?, ?>)((HashMap)data));
        if (Float.compare(this.getLatestVersion(), this.getVersion()) > 0) {
            this.upgrade();
            this.upgraded = true;
        }
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    @Override
    public abstract void upgrade();

    public Map<Object, Object> diff(UpgradeableDataHashMap newobj) {
        Map newmap = (Map)newobj.saveData();
        return UpgradeableDataHashMap.diffMaps(this.data, newmap);
    }

    public static Map<Object, Object> diffMaps(Map<Object, Object> oldmap, Map<Object, Object> newmap) {
        Object val;
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Object key : oldmap.keySet()) {
            if (newmap.containsKey(key)) {
                Object value = oldmap.get(key);
                if (value == null) {
                    if (newmap.get(key) == null) continue;
                    result.put("addedvalue:" + key, newmap.get(key));
                    continue;
                }
                if (value.equals(newmap.get(key))) continue;
                Object val2 = newmap.get(key);
                if (val2 == null) {
                    val2 = "";
                }
                result.put("changed:" + key, UpgradeableDataHashMap.getVal(val2));
                continue;
            }
            val = oldmap.get(key);
            if (val == null) {
                val = "";
            }
            result.put("removed:" + key, UpgradeableDataHashMap.getVal(val));
        }
        for (Object key : newmap.keySet()) {
            if (oldmap.containsKey(key)) continue;
            val = newmap.get(key);
            if (val == null) {
                val = "";
            }
            result.put("added:" + key, UpgradeableDataHashMap.getVal(val));
        }
        return result;
    }

    private static String getVal(Object o) {
        StringBuilder b = new StringBuilder();
        if (o instanceof String[]) {
            String[] arr;
            b.append('[');
            for (String s : arr = (String[])o) {
                if (b.length() > 1) {
                    b.append(", ");
                }
                b.append(s);
            }
            b.append(']');
        } else {
            b.append(o);
        }
        return b.toString();
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        Boolean ret = (Boolean)this.data.get(key);
        return ret == null || !(ret instanceof Boolean) ? defaultValue : ret;
    }

    protected void putBoolean(String key, boolean value) {
        this.data.put(key, value);
    }
}

