/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class JndiHelper {
    private static final Logger log = Logger.getLogger(JndiHelper.class);
    private static Context context = null;
    private static boolean isJEE6 = false;

    private static Context getContext() throws NamingException {
        if (context == null) {
            context = new InitialContext();
        }
        return context;
    }

    public static <T> T getRemoteSession(Class<T> remoteInterface, String module) {
        Object ret;
        block8: {
            String jndiNameJEE5 = "ejbca/" + remoteInterface.getSimpleName();
            String viewClassName = remoteInterface.getName();
            String beanName = remoteInterface.getSimpleName().replace("Remote", "Bean");
            String jndiNameJEE6 = "ejb:ejbca/" + module + "//" + beanName + "!" + viewClassName;
            String jndiName = isJEE6 ? jndiNameJEE6 : jndiNameJEE5;
            ret = null;
            try {
                try {
                    ret = JndiHelper.getContext().lookup(jndiName);
                }
                catch (NamingException e) {
                    if (!isJEE6) {
                        try {
                            ret = JndiHelper.getContext().lookup(jndiNameJEE6);
                            if (ret != null) {
                                isJEE6 = true;
                            }
                            break block8;
                        }
                        catch (NamingException ne) {
                            log.error((Object)"JNDI name lookup error", (Throwable)e);
                        }
                        break block8;
                    }
                    log.error((Object)"JNDI name lookup error", (Throwable)e);
                }
            }
            catch (ClassCastException e) {
                log.error((Object)("JNDI object " + jndiName + " is not of type " + remoteInterface.getName()));
            }
        }
        return (T)ret;
    }
}

