/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind;

import java.io.Serializable;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.cesecore.config.AvailableExtendedKeyUsagesConfiguration;
import org.cesecore.internal.UpgradeableDataHashMap;
import org.cesecore.keybind.CertificateImportException;
import org.cesecore.keybind.InternalKeyBinding;
import org.cesecore.keybind.InternalKeyBindingProperty;
import org.cesecore.keybind.InternalKeyBindingStatus;
import org.cesecore.keybind.InternalKeyBindingTrustEntry;

public abstract class InternalKeyBindingBase
extends UpgradeableDataHashMap
implements InternalKeyBinding {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(InternalKeyBindingBase.class);
    private static final String PROP_NEXT_KEY_PAIR_ALIAS = "nextKeyPairAlias";
    private static final String PROP_TRUSTED_CERTIFICATE_REFERENCES = "trustedCertificateReferences";
    private static final String PROP_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    private static final String BASECLASS_PREFIX = "BASECLASS_";
    public static final String SUBCLASS_PREFIX = "SUBCLASS_";
    private int internalKeyBindingId;
    private String name;
    private InternalKeyBindingStatus status;
    private String certificateId;
    private int cryptoTokenId;
    private String keyPairAlias;
    private List<InternalKeyBindingTrustEntry> trustedCertificateReferences;
    private String signatureAlgorithm;
    private final Map<String, InternalKeyBindingProperty<? extends Serializable>> propertyTemplates = new HashMap<String, InternalKeyBindingProperty<? extends Serializable>>();
    private static final SimpleDateFormat DATE_FORMAT_MS = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final Pattern DATE_FORMAT_PATTERN = Pattern.compile("_\\d{8}\\d{6}$");
    private static final Pattern DATE_FORMAT_PATTERN_MS = Pattern.compile("_\\d{8}\\d{9}$");

    protected void addProperty(InternalKeyBindingProperty<? extends Serializable> property) {
        this.propertyTemplates.put(property.getName(), property);
    }

    @Override
    public Map<String, InternalKeyBindingProperty<? extends Serializable>> getCopyOfProperties() {
        HashMap<String, InternalKeyBindingProperty<? extends Serializable>> ret = new HashMap<String, InternalKeyBindingProperty<? extends Serializable>>();
        for (String key : this.propertyTemplates.keySet()) {
            InternalKeyBindingProperty<? extends Serializable> current = this.propertyTemplates.get(key);
            Object clone = current.clone();
            ((InternalKeyBindingProperty)clone).setValueGeneric(this.getProperty(((InternalKeyBindingProperty)clone).getName()).getValue());
            ret.put(key, (InternalKeyBindingProperty<? extends Serializable>)clone);
        }
        return ret;
    }

    @Override
    public InternalKeyBindingProperty<? extends Serializable> getProperty(String name) {
        InternalKeyBindingProperty<? extends Serializable> property = this.propertyTemplates.get(name);
        property.setValueGeneric(this.getData(name, property.getDefaultValue()));
        return property;
    }

    @Override
    public void setProperty(String name, Serializable value) {
        this.putData(name, value);
    }

    @Override
    public void init(int internalKeyBindingId, String name, InternalKeyBindingStatus status, String certificateId, int cryptoTokenId, String keyPairAlias, LinkedHashMap<Object, Object> dataMap) {
        this.internalKeyBindingId = internalKeyBindingId;
        this.setName(name);
        this.setStatus(status);
        this.setCertificateId(certificateId);
        this.setCryptoTokenId(cryptoTokenId);
        this.setKeyPairAlias(keyPairAlias);
        if (dataMap.get("version") == null) {
            dataMap.put("version", new Float(this.getLatestVersion()));
        }
        this.loadData(dataMap);
    }

    @Override
    public int getId() {
        return this.internalKeyBindingId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public InternalKeyBindingStatus getStatus() {
        if (this.status == null) {
            this.status = InternalKeyBindingStatus.DISABLED;
        }
        return this.status;
    }

    @Override
    public void setStatus(InternalKeyBindingStatus status) {
        this.status = status == null ? InternalKeyBindingStatus.DISABLED : status;
    }

    @Override
    public String getCertificateId() {
        return this.certificateId;
    }

    @Override
    public void setCertificateId(String certificateId) {
        this.certificateId = certificateId;
    }

    @Override
    public int getCryptoTokenId() {
        return this.cryptoTokenId;
    }

    @Override
    public void setCryptoTokenId(int cryptoTokenId) {
        this.cryptoTokenId = cryptoTokenId;
    }

    @Override
    public String getKeyPairAlias() {
        return this.keyPairAlias;
    }

    @Override
    public void setKeyPairAlias(String keyPairAlias) {
        this.keyPairAlias = keyPairAlias;
    }

    @Override
    public String getNextKeyPairAlias() {
        return this.getData(PROP_NEXT_KEY_PAIR_ALIAS, null);
    }

    @Override
    public void setNextKeyPairAlias(String nextKeyPairAlias) {
        this.putData(PROP_NEXT_KEY_PAIR_ALIAS, nextKeyPairAlias);
    }

    @Override
    public void updateCertificateIdAndCurrentKeyAlias(String certificateId) {
        this.setCertificateId(certificateId);
        this.setKeyPairAlias(this.getNextKeyPairAlias());
        this.setNextKeyPairAlias(null);
    }

    private String getNewAlias(String oldAlias) {
        Matcher matcherMs = DATE_FORMAT_PATTERN_MS.matcher(oldAlias);
        String newPostFix = "_" + DATE_FORMAT_MS.format(new Date());
        if (matcherMs.find()) {
            return matcherMs.replaceAll(newPostFix);
        }
        Matcher matcher = DATE_FORMAT_PATTERN.matcher(oldAlias);
        if (matcher.find()) {
            return matcher.replaceAll(newPostFix);
        }
        return oldAlias + newPostFix;
    }

    @Override
    public void generateNextKeyPairAlias() {
        String currentKeyPairAlias = this.getKeyPairAlias();
        String nextKeyPairAlias = this.getNewAlias(currentKeyPairAlias);
        if (log.isDebugEnabled()) {
            log.debug((Object)("nextKeyPairAlias for internalKeyBinding " + this.internalKeyBindingId + " will be " + nextKeyPairAlias));
        }
        this.setNextKeyPairAlias(nextKeyPairAlias);
    }

    @Override
    public List<InternalKeyBindingTrustEntry> getTrustedCertificateReferences() {
        if (this.trustedCertificateReferences == null) {
            this.trustedCertificateReferences = this.getDataInternal(PROP_TRUSTED_CERTIFICATE_REFERENCES, new ArrayList());
        }
        ArrayList<InternalKeyBindingTrustEntry> trustedCertificateReferences = new ArrayList<InternalKeyBindingTrustEntry>();
        trustedCertificateReferences.addAll(this.trustedCertificateReferences);
        return trustedCertificateReferences;
    }

    @Override
    public void setTrustedCertificateReferences(List<InternalKeyBindingTrustEntry> trustedCertificateReferences) {
        this.trustedCertificateReferences = trustedCertificateReferences;
        ArrayList<InternalKeyBindingTrustEntry> arrayList = new ArrayList<InternalKeyBindingTrustEntry>(trustedCertificateReferences.size());
        arrayList.addAll(trustedCertificateReferences);
        this.putDataInternal(PROP_TRUSTED_CERTIFICATE_REFERENCES, arrayList);
    }

    @Override
    public String getSignatureAlgorithm() {
        if (this.signatureAlgorithm == null) {
            this.signatureAlgorithm = this.getDataInternal(PROP_SIGNATURE_ALGORITHM, null);
        }
        return this.signatureAlgorithm;
    }

    @Override
    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.putDataInternal(PROP_SIGNATURE_ALGORITHM, signatureAlgorithm);
    }

    @Override
    public LinkedHashMap<Object, Object> getDataMapToPersist() {
        return (LinkedHashMap)this.saveData();
    }

    @Override
    public abstract float getLatestVersion();

    @Override
    public abstract void assertCertificateCompatability(Certificate var1, AvailableExtendedKeyUsagesConfiguration var2) throws CertificateImportException;

    @Override
    public void upgrade() {
        this.upgrade(this.getLatestVersion(), this.getVersion());
    }

    protected abstract void upgrade(float var1, float var2);

    private void putData(String key, Object value) {
        this.data.put(SUBCLASS_PREFIX + key, value);
    }

    private <T> T getData(String key, T defaultValue) {
        Object ret = this.data.get(SUBCLASS_PREFIX + key);
        return (T)(ret == null ? defaultValue : ret);
    }

    private void putDataInternal(String key, Object value) {
        this.data.put(BASECLASS_PREFIX + key, value);
    }

    private <T> T getDataInternal(String key, T defaultValue) {
        Object ret = this.data.get(BASECLASS_PREFIX + key);
        return (T)(ret == null ? defaultValue : ret);
    }
}

