/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cesecore.keybind.InternalKeyBinding;
import org.cesecore.keybind.InternalKeyBindingProperty;
import org.cesecore.keybind.InternalKeyBindingPropertyValidationWrapper;
import org.cesecore.keybind.InternalKeyBindingStatus;
import org.cesecore.keybind.impl.AuthenticationKeyBinding;
import org.cesecore.keybind.impl.OcspKeyBinding;

public enum InternalKeyBindingFactory {
    INSTANCE;

    private final Logger log = Logger.getLogger(InternalKeyBindingFactory.class);
    private final Map<String, String> aliasToImplementationMap = new HashMap<String, String>();
    private final Map<String, String> implementationToAliasMap = new HashMap<String, String>();
    private final Map<String, Map<String, InternalKeyBindingProperty<? extends Serializable>>> implementationPropertiesMap = new HashMap<String, Map<String, InternalKeyBindingProperty<? extends Serializable>>>();

    private InternalKeyBindingFactory() {
        this.addImplementation(OcspKeyBinding.class);
        this.addImplementation(AuthenticationKeyBinding.class);
    }

    public boolean existsTypeAlias(String alias) {
        return this.aliasToImplementationMap.containsKey(alias);
    }

    public InternalKeyBinding create(String type, int id, String name, InternalKeyBindingStatus status, String certificateId, int cryptoTokenId, String keyPairAlias, LinkedHashMap<Object, Object> dataMap) {
        String implementationClassName = this.aliasToImplementationMap.get(type);
        InternalKeyBinding internalKeyBinding = null;
        if (implementationClassName == null) {
            this.log.error((Object)("Unable to create Signer. Implementation for type '" + type + "' not found."));
        } else {
            try {
                internalKeyBinding = (InternalKeyBinding)Class.forName(implementationClassName).newInstance();
                String certFp = certificateId != null ? certificateId.toLowerCase(Locale.ENGLISH) : null;
                internalKeyBinding.init(id, name, status, certFp, cryptoTokenId, keyPairAlias, dataMap);
            }
            catch (InstantiationException e) {
                this.log.error((Object)("Unable to create InternalKeyBinding. Could not be instantiate implementation '" + implementationClassName + "'."), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)("Unable to create InternalKeyBinding. Not allowed to instantiate implementation '" + implementationClassName + "'."), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("Unable to create InternalKeyBinding. Could not find implementation '" + implementationClassName + "'."), (Throwable)e);
            }
        }
        return internalKeyBinding;
    }

    public String getTypeFromImplementation(InternalKeyBinding internalKeyBinding) {
        return String.valueOf(this.implementationToAliasMap.get(internalKeyBinding.getClass().getName()));
    }

    private void addImplementation(Class<? extends InternalKeyBinding> c) {
        String alias = null;
        ArrayList<String> implementationPropertyKeys = null;
        Map<String, InternalKeyBindingProperty<? extends Serializable>> implementationProperties = null;
        try {
            InternalKeyBinding temporaryInstance = c.newInstance();
            alias = temporaryInstance.getImplementationAlias();
            implementationProperties = temporaryInstance.getCopyOfProperties();
            implementationPropertyKeys = new ArrayList<String>();
            for (String name : implementationProperties.keySet()) {
                implementationPropertyKeys.add(name);
            }
        }
        catch (InstantiationException e) {
            this.log.error((Object)("Unable to create InternalKeyBinding. Could not be instantiate implementation '" + c.getName() + "'."), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)("Unable to create InternalKeyBinding. Not allowed to instantiate implementation '" + c.getName() + "'."), (Throwable)e);
        }
        if (alias != null) {
            this.aliasToImplementationMap.put(alias, c.getName());
            this.implementationToAliasMap.put(c.getName(), alias);
            this.implementationPropertiesMap.put(alias, Collections.unmodifiableMap(implementationProperties));
        }
    }

    public Map<String, Map<String, InternalKeyBindingProperty<? extends Serializable>>> getAvailableTypesAndProperties() {
        return Collections.unmodifiableMap(this.implementationPropertiesMap);
    }

    public InternalKeyBindingPropertyValidationWrapper validateProperties(String alias, Map<String, String> propertiesMap) {
        InternalKeyBindingPropertyValidationWrapper result = new InternalKeyBindingPropertyValidationWrapper();
        Map<String, InternalKeyBindingProperty<? extends Serializable>> implementationProperties = this.implementationPropertiesMap.get(alias);
        for (String key : propertiesMap.keySet()) {
            String value;
            if (!implementationProperties.containsKey(key)) {
                result.addUnknownProperty(key);
                continue;
            }
            InternalKeyBindingProperty<? extends Serializable> property = implementationProperties.get(key);
            Serializable recastValue = property.valueOf(value = propertiesMap.get(key));
            if (recastValue == null) {
                result.addInvalidValue(key, property.getType());
                continue;
            }
            result.addProperty(key, recastValue);
        }
        return result;
    }
}

