/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.cesecore.util.Base64;

public class InternalKeyBindingProperty<T extends Serializable>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String name;
    private T defaultValue;
    private T value;
    private T[] possibleValues;

    public InternalKeyBindingProperty() {
    }

    public InternalKeyBindingProperty(String name, T defaultValue, T ... possibleValues) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.possibleValues = possibleValues.length == 0 ? null : possibleValues;
    }

    public Serializable valueOf(String value) {
        if (this.defaultValue instanceof String) {
            return value;
        }
        if (this.defaultValue instanceof Integer) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.defaultValue instanceof Long) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.defaultValue instanceof Boolean) {
            if (value.equals(Boolean.TRUE.toString()) || value.equals(Boolean.FALSE.toString())) {
                return Boolean.valueOf(value);
            }
        } else if (this.defaultValue instanceof Float) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Serializable> getType() {
        return this.defaultValue.getClass();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public T[] getPossibleValues() {
        return this.possibleValues;
    }

    public boolean isMultiValued() {
        return this.possibleValues != null;
    }

    public void setValue(T object) {
        if (object == null) {
            this.value = this.defaultValue;
        } else {
            if (this.possibleValues != null) {
                for (T possibleValue : this.possibleValues) {
                    if (!possibleValue.equals(object)) continue;
                    this.value = object;
                    return;
                }
                throw new RuntimeException(object + " is not one of " + Arrays.toString(this.possibleValues));
            }
            this.value = object;
        }
    }

    public String getEncodedValue() {
        return this.getAsEncodedValue((Serializable)this.getValue());
    }

    public String getAsEncodedValue(Serializable possibleValue) {
        return new String(Base64.encode(this.getAsByteArray(possibleValue), false));
    }

    public void setEncodedValue(String encodedValue) {
        this.setValue(this.getAsObject(Base64.decode(encodedValue.getBytes())));
    }

    public void setValueGeneric(Serializable object) {
        this.value = object == null ? this.defaultValue : object;
    }

    public InternalKeyBindingProperty<T> clone() {
        return (InternalKeyBindingProperty)this.getAsObject(this.getAsByteArray(this));
    }

    private byte[] getAsByteArray(Serializable o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Serializable getAsObject(byte[] bytes) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object o = ois.readObject();
            ois.close();
            return (Serializable)o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

