/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind;

import java.util.HashMap;
import java.util.Map;

public enum InternalKeyBindingRules {
    BASE("/internalkeybinding", ""),
    DELETE(BASE.resource() + "/delete", "DELETE"),
    MODIFY(BASE.resource() + "/modify", "MODIFY"),
    VIEW(BASE.resource() + "/view", "VIEW");

    private static final Map<String, InternalKeyBindingRules> reverseResourceLookup;
    private final String resource;
    private final String reference;

    private InternalKeyBindingRules(String resource, String reference) {
        this.resource = resource;
        this.reference = reference;
    }

    public String resource() {
        return this.resource;
    }

    public String toString() {
        return this.resource;
    }

    public String getReference() {
        return this.reference;
    }

    public static InternalKeyBindingRules getFromResource(String resource) {
        return reverseResourceLookup.get(resource);
    }

    static {
        reverseResourceLookup = new HashMap<String, InternalKeyBindingRules>();
        for (InternalKeyBindingRules rule : InternalKeyBindingRules.values()) {
            reverseResourceLookup.put(rule.resource(), rule);
        }
    }
}

