/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind;

import java.io.Serializable;
import java.math.BigInteger;

public class InternalKeyBindingTrustEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int caId = 0;
    private String certificateSerialNumberDecimal = null;

    public InternalKeyBindingTrustEntry() {
    }

    public InternalKeyBindingTrustEntry(int caId, BigInteger certificateSerialNumber) {
        this.setCaId(caId);
        this.putCertificateSerialNumber(certificateSerialNumber);
    }

    public int getCaId() {
        return this.caId;
    }

    public void setCaId(int caId) {
        this.caId = caId;
    }

    public String getCertificateSerialNumberDecimal() {
        return this.certificateSerialNumberDecimal;
    }

    public void setCertificateSerialNumberDecimal(String certificateSerialNumberDecimal) {
        this.certificateSerialNumberDecimal = certificateSerialNumberDecimal;
    }

    public BigInteger fetchCertificateSerialNumber() {
        if (this.certificateSerialNumberDecimal == null) {
            return null;
        }
        return new BigInteger(this.certificateSerialNumberDecimal);
    }

    public void putCertificateSerialNumber(BigInteger certificateSerialNumber) {
        this.certificateSerialNumberDecimal = certificateSerialNumber == null ? null : certificateSerialNumber.toString();
    }

    public String toString() {
        BigInteger certificateSerialNumber = this.fetchCertificateSerialNumber();
        if (certificateSerialNumber == null) {
            return Integer.valueOf(this.caId).toString();
        }
        return Integer.valueOf(this.caId).toString() + ";" + certificateSerialNumber.toString(16);
    }

    public boolean equals(Object object) {
        if (!(object instanceof InternalKeyBindingTrustEntry)) {
            return false;
        }
        InternalKeyBindingTrustEntry other = (InternalKeyBindingTrustEntry)object;
        if (this.caId != other.caId) {
            return false;
        }
        if (this.certificateSerialNumberDecimal == null && other.certificateSerialNumberDecimal == null) {
            return true;
        }
        return this.certificateSerialNumberDecimal != null && this.certificateSerialNumberDecimal.equals(other.certificateSerialNumberDecimal);
    }
}

