/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind.impl;

import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.cesecore.config.AvailableExtendedKeyUsagesConfiguration;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.keybind.CertificateImportException;
import org.cesecore.keybind.InternalKeyBindingBase;
import org.cesecore.keybind.InternalKeyBindingProperty;
import org.cesecore.util.CertTools;

public class AuthenticationKeyBinding
extends InternalKeyBindingBase {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AuthenticationKeyBinding.class);
    public static final String IMPLEMENTATION_ALIAS = "AuthenticationKeyBinding";
    public static final String PROPERTY_PROTOCOL_AND_CIPHER_SUITE = "protocolAndCipherSuite";

    public AuthenticationKeyBinding() {
        String[] CIPHER_SUITES_SUBSET = CesecoreConfiguration.getAvailableCipherSuites();
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_PROTOCOL_AND_CIPHER_SUITE, (Serializable)((Object)CIPHER_SUITES_SUBSET[0]), (Serializable[])CIPHER_SUITES_SUBSET));
    }

    public String[] getSupportedProtocols() {
        return this.getSelectedProtocolOrSuite(0);
    }

    public String[] getSupportedCipherTextSuites() {
        return this.getSelectedProtocolOrSuite(1);
    }

    private String[] getSelectedProtocolOrSuite(int pos) {
        String value = (String)((Object)this.getProperty(PROPERTY_PROTOCOL_AND_CIPHER_SUITE).getValue());
        String[] values = value.split(";");
        if (log.isDebugEnabled() && pos == 0) {
            log.debug((Object)("Configured cipher suite for this AuthenticationKeyBinding: " + value));
        }
        if (values.length == 2) {
            return new String[]{values[pos]};
        }
        return new String[0];
    }

    @Override
    public String getImplementationAlias() {
        return IMPLEMENTATION_ALIAS;
    }

    @Override
    public float getLatestVersion() {
        return 1.0f;
    }

    @Override
    public void assertCertificateCompatability(Certificate certificate, AvailableExtendedKeyUsagesConfiguration ekuConfig) throws CertificateImportException {
        if (!AuthenticationKeyBinding.isClientSSLCertificate(certificate, ekuConfig)) {
            throw new CertificateImportException("Not a vlid Client SSL authentication certificate.");
        }
    }

    @Override
    protected void upgrade(float latestVersion, float currentVersion) {
    }

    public static boolean isClientSSLCertificate(Certificate certificate, AvailableExtendedKeyUsagesConfiguration ekuConfig) {
        if (certificate == null) {
            log.debug((Object)"No certificate provided.");
            return false;
        }
        if (!(certificate instanceof X509Certificate)) {
            log.debug((Object)"Only X509 supported.");
            return false;
        }
        try {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            log.debug((Object)("SubjectDN: " + CertTools.getSubjectDN(x509Certificate) + " IssuerDN: " + CertTools.getIssuerDN(x509Certificate)));
            boolean[] ku = x509Certificate.getKeyUsage();
            log.debug((Object)("Key usages: " + Arrays.toString(ku)));
            if (ku != null) {
                log.debug((Object)("Key usage (digitalSignature): " + x509Certificate.getKeyUsage()[0]));
                log.debug((Object)("Key usage (keyEncipherment): " + x509Certificate.getKeyUsage()[2]));
            }
            if (x509Certificate.getExtendedKeyUsage() == null) {
                log.debug((Object)"No EKU to verify.");
                return false;
            }
            for (String extendedKeyUsage : x509Certificate.getExtendedKeyUsage()) {
                log.debug((Object)("EKU: " + extendedKeyUsage + " (" + ekuConfig.getAllEKUOidsAndNames().get(extendedKeyUsage) + ")"));
            }
            if (!x509Certificate.getExtendedKeyUsage().contains(KeyPurposeId.id_kp_clientAuth.getId())) {
                log.debug((Object)"Extended Key Usage 1.3.6.1.5.5.7.3.2 (EKU_PKIX_CLIENTAUTH) is required.");
                return false;
            }
            if (!x509Certificate.getKeyUsage()[0]) {
                log.debug((Object)"Key usage digitalSignature is required.");
                return false;
            }
            if (!x509Certificate.getKeyUsage()[2]) {
                log.debug((Object)"Key usage keyEncipherment is required.");
                return false;
            }
        }
        catch (CertificateParsingException e) {
            log.debug((Object)e.getMessage());
            return false;
        }
        return true;
    }
}

