/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind.impl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509KeyManager;
import org.apache.log4j.Logger;

public class ClientX509KeyManager
implements X509KeyManager {
    private static final Logger log = Logger.getLogger(ClientX509KeyManager.class);
    private final String alias;
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;

    public ClientX509KeyManager(String alias, PrivateKey privateKey, List<X509Certificate> certificateChain) {
        this.alias = alias;
        this.privateKey = privateKey;
        this.certificateChain = certificateChain != null ? certificateChain.toArray(new X509Certificate[certificateChain.size()]) : null;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        this.logDebugIfEnabled(null, keyTypes, issuers, socket);
        return this.alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        this.logDebugIfEnabled(null, new String[]{keyType}, issuers, socket);
        log.warn((Object)"Got a request for server aliases, but implementation only supports client side of TLS negotiations.");
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        this.logDebugIfEnabled(alias, null, null, null);
        if (this.alias.equals(alias)) {
            return this.certificateChain;
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        this.logDebugIfEnabled(null, new String[]{keyType}, issuers, null);
        return new String[]{this.alias};
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        this.logDebugIfEnabled(alias, null, null, null);
        if (this.alias.equals(alias)) {
            return this.privateKey;
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        this.logDebugIfEnabled(null, new String[]{keyType}, issuers, null);
        log.warn((Object)"Got a request for server aliases, but implementation only supports client side of TLS negotiations.");
        return null;
    }

    private void logDebugIfEnabled(String alias, String[] keyTypes, Principal[] issuers, Socket socket) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread().getStackTrace()[2].getMethodName() + ":"));
            if (alias != null) {
                log.debug((Object)(" Alias: " + alias));
            }
            if (keyTypes != null) {
                log.debug((Object)(" KeyTypes: " + Arrays.toString(keyTypes)));
            }
            if (issuers != null) {
                for (Principal issuer : issuers) {
                    log.debug((Object)(" Issuer: " + issuer));
                }
            }
            if (socket != null) {
                log.debug((Object)(" RemoteSocketAddress: " + socket.getRemoteSocketAddress()));
            }
        }
    }
}

