/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind.impl;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.cesecore.util.CertTools;
import org.cesecore.util.provider.EkuPKIXCertPathChecker;

public class ClientX509TrustManager
implements X509TrustManager {
    private Collection<Collection<Certificate>> trustedCertificatesChains = null;

    public ClientX509TrustManager(Collection<Collection<Certificate>> trustedCertificates) {
        if (trustedCertificates != null) {
            this.trustedCertificatesChains = new ArrayList<Collection<Certificate>>();
            for (Collection<Certificate> col : trustedCertificates) {
                this.trustedCertificatesChains.add(col);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate cert = chain[0];
        if (!CertTools.verifyWithTrustedCertificates(cert, this.trustedCertificatesChains, new EkuPKIXCertPathChecker(KeyPurposeId.id_kp_clientAuth.getId()))) {
            String subjectdn = CertTools.getSubjectDN(cert);
            String issuerdn = CertTools.getIssuerDN(cert);
            String sn = CertTools.getSerialNumberAsString(cert);
            String errmsg = "Certificate with SubjectDN '" + subjectdn + "', IssuerDN '" + issuerdn + "' and serialnumber '" + sn + "' is NOT trusted.";
            throw new CertificateException(errmsg);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate cert = chain[0];
        if (!CertTools.verifyWithTrustedCertificates(cert, this.trustedCertificatesChains, new EkuPKIXCertPathChecker(KeyPurposeId.id_kp_serverAuth.getId()))) {
            String subjectdn = CertTools.getSubjectDN(cert);
            String issuerdn = CertTools.getIssuerDN(cert);
            String sn = CertTools.getSerialNumberAsString(cert);
            String errmsg = "Certificate with SubjectDN '" + subjectdn + "', IssuerDN '" + issuerdn + "' and serialnumber '" + sn + "' is NOT trusted.";
            throw new CertificateException(errmsg);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.trustedCertificatesChains == null) {
            return new X509Certificate[0];
        }
        ArrayList<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>();
        for (Collection<Certificate> certChain : this.trustedCertificatesChains) {
            Iterator<Certificate> itr = certChain.iterator();
            X509Certificate cert = (X509Certificate)itr.next();
            if (CertTools.isCA(cert)) {
                acceptedIssuers.add(cert);
                continue;
            }
            acceptedIssuers.add((X509Certificate)itr.next());
        }
        return acceptedIssuers.toArray(new X509Certificate[0]);
    }
}

