/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keybind.impl;

import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.cesecore.config.AvailableExtendedKeyUsagesConfiguration;
import org.cesecore.keybind.CertificateImportException;
import org.cesecore.keybind.InternalKeyBindingBase;
import org.cesecore.keybind.InternalKeyBindingProperty;
import org.cesecore.util.CertTools;

public class OcspKeyBinding
extends InternalKeyBindingBase {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(OcspKeyBinding.class);
    public static final String IMPLEMENTATION_ALIAS = "OcspKeyBinding";
    public static final String PROPERTY_NON_EXISTING_GOOD = "nonexistingisgood";
    public static final String PROPERTY_NON_EXISTING_REVOKED = "nonexistingisrevoked";
    public static final String PROPERTY_INCLUDE_CERT_CHAIN = "includecertchain";
    public static final String PROPERTY_INCLUDE_SIGN_CERT = "includesigncert";
    public static final String PROPERTY_RESPONDER_ID_TYPE = "responderidtype";
    public static final String PROPERTY_REQUIRE_TRUSTED_SIGNATURE = "requireTrustedSignature";
    public static final String PROPERTY_UNTIL_NEXT_UPDATE = "untilNextUpdate";
    public static final String PROPERTY_MAX_AGE = "maxAge";

    public OcspKeyBinding() {
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_NON_EXISTING_GOOD, (Serializable)Boolean.FALSE, (Serializable[])new Boolean[0]));
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_NON_EXISTING_REVOKED, (Serializable)Boolean.FALSE, (Serializable[])new Boolean[0]));
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_INCLUDE_CERT_CHAIN, (Serializable)Boolean.TRUE, (Serializable[])new Boolean[0]));
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_INCLUDE_SIGN_CERT, (Serializable)Boolean.TRUE, (Serializable[])new Boolean[0]));
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_RESPONDER_ID_TYPE, (Serializable)((Object)ResponderIdType.KEYHASH.name()), (Serializable[])new String[]{ResponderIdType.KEYHASH.name(), ResponderIdType.NAME.name()}));
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_REQUIRE_TRUSTED_SIGNATURE, (Serializable)Boolean.FALSE, (Serializable[])new Boolean[0]));
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_UNTIL_NEXT_UPDATE, (Serializable)Long.valueOf(0L), (Serializable[])new Long[0]));
        this.addProperty(new InternalKeyBindingProperty(PROPERTY_MAX_AGE, (Serializable)Long.valueOf(0L), (Serializable[])new Long[0]));
    }

    @Override
    public String getImplementationAlias() {
        return IMPLEMENTATION_ALIAS;
    }

    @Override
    public float getLatestVersion() {
        return 1.0f;
    }

    @Override
    protected void upgrade(float latestVersion, float currentVersion) {
    }

    @Override
    public void assertCertificateCompatability(Certificate certificate, AvailableExtendedKeyUsagesConfiguration ekuConfig) throws CertificateImportException {
        OcspKeyBinding.assertCertificateCompatabilityInternal(certificate, ekuConfig);
    }

    public boolean getNonExistingGood() {
        return (Boolean)this.getProperty(PROPERTY_NON_EXISTING_GOOD).getValue();
    }

    public void setNonExistingGood(boolean nonExistingGood) {
        this.setProperty(PROPERTY_NON_EXISTING_GOOD, Boolean.valueOf(nonExistingGood));
    }

    public boolean getNonExistingRevoked() {
        return (Boolean)this.getProperty(PROPERTY_NON_EXISTING_REVOKED).getValue();
    }

    public void setNonExistingRevoked(boolean nonExistingRevoked) {
        this.setProperty(PROPERTY_NON_EXISTING_REVOKED, Boolean.valueOf(nonExistingRevoked));
    }

    public boolean getIncludeCertChain() {
        return (Boolean)this.getProperty(PROPERTY_INCLUDE_CERT_CHAIN).getValue();
    }

    public void setIncludeCertChain(boolean includeCertChain) {
        this.setProperty(PROPERTY_INCLUDE_CERT_CHAIN, Boolean.valueOf(includeCertChain));
    }

    public boolean getIncludeSignCert() {
        return (Boolean)this.getProperty(PROPERTY_INCLUDE_SIGN_CERT).getValue();
    }

    public void setIncludeSignCert(boolean includeCertChain) {
        this.setProperty(PROPERTY_INCLUDE_SIGN_CERT, Boolean.valueOf(includeCertChain));
    }

    public ResponderIdType getResponderIdType() {
        return ResponderIdType.valueOf((String)((Object)this.getProperty(PROPERTY_RESPONDER_ID_TYPE).getValue()));
    }

    public void setResponderIdType(ResponderIdType responderIdType) {
        this.setProperty(PROPERTY_RESPONDER_ID_TYPE, (Serializable)((Object)responderIdType.name()));
    }

    public boolean getRequireTrustedSignature() {
        return (Boolean)this.getProperty(PROPERTY_REQUIRE_TRUSTED_SIGNATURE).getValue();
    }

    public void setRequireTrustedSignature(boolean requireTrustedSignature) {
        this.setProperty(PROPERTY_REQUIRE_TRUSTED_SIGNATURE, Boolean.valueOf(requireTrustedSignature));
    }

    public long getUntilNextUpdate() {
        return (Long)this.getProperty(PROPERTY_UNTIL_NEXT_UPDATE).getValue();
    }

    public void setUntilNextUpdate(long untilNextUpdate) {
        this.setProperty(PROPERTY_UNTIL_NEXT_UPDATE, Long.valueOf(untilNextUpdate));
    }

    public long getMaxAge() {
        return (Long)this.getProperty(PROPERTY_MAX_AGE).getValue();
    }

    public void setMaxAge(long maxAge) {
        this.setProperty(PROPERTY_MAX_AGE, Long.valueOf(maxAge));
    }

    public static boolean isOcspSigningCertificate(Certificate certificate, AvailableExtendedKeyUsagesConfiguration ekuConfig) {
        try {
            OcspKeyBinding.assertCertificateCompatabilityInternal(certificate, ekuConfig);
        }
        catch (CertificateImportException e) {
            return false;
        }
        return true;
    }

    private static void assertCertificateCompatabilityInternal(Certificate certificate, AvailableExtendedKeyUsagesConfiguration ekuConfig) throws CertificateImportException {
        if (certificate == null) {
            throw new CertificateImportException("No certificate provided.");
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new CertificateImportException("Only X509 certificates are supported for OCSP.");
        }
        try {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            if (log.isDebugEnabled()) {
                log.debug((Object)("SubjectDN: " + CertTools.getSubjectDN(x509Certificate) + " IssuerDN: " + CertTools.getIssuerDN(x509Certificate)));
                boolean[] ku = x509Certificate.getKeyUsage();
                log.debug((Object)("Key usages: " + Arrays.toString(ku)));
                if (ku != null) {
                    log.debug((Object)("Key usage (digitalSignature): " + x509Certificate.getKeyUsage()[0]));
                    log.debug((Object)("Key usage (nonRepudiation):   " + x509Certificate.getKeyUsage()[1]));
                    log.debug((Object)("Key usage (keyEncipherment):  " + x509Certificate.getKeyUsage()[2]));
                }
            }
            if (x509Certificate.getExtendedKeyUsage() == null) {
                throw new CertificateImportException("No Extended Key Usage present in certificate.");
            }
            for (String extendedKeyUsage : x509Certificate.getExtendedKeyUsage()) {
                log.debug((Object)("EKU: " + extendedKeyUsage + " (" + ekuConfig.getAllEKUOidsAndNames().get(extendedKeyUsage) + ")"));
            }
            if (!x509Certificate.getExtendedKeyUsage().contains(KeyPurposeId.id_kp_OCSPSigning.getId())) {
                throw new CertificateImportException("Extended Key Usage 1.3.6.1.5.5.7.3.9 (EKU_PKIX_OCSPSIGNING) is required.");
            }
            if (!x509Certificate.getKeyUsage()[0] && !x509Certificate.getKeyUsage()[1]) {
                throw new CertificateImportException("Key Usage digitalSignature is required (nonRepudiation would also be accepted).");
            }
        }
        catch (CertificateParsingException e) {
            throw new CertificateImportException(e.getMessage(), (Exception)e);
        }
    }

    public static enum ResponderIdType {
        KEYHASH,
        NAME;

    }
}

