/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.jce.ECKeyUtil;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.internal.InternalResources;
import org.cesecore.keys.token.CachingKeyStoreWrapper;
import org.cesecore.keys.token.CryptoToken;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.keys.token.PrivateKeyNotExtractableException;
import org.cesecore.keys.util.KeyTools;
import org.cesecore.util.StringTools;

public abstract class BaseCryptoToken
implements CryptoToken {
    private static final long serialVersionUID = 2133644669863292622L;
    private static final Logger log = Logger.getLogger(BaseCryptoToken.class);
    private static final InternalResources intres = InternalResources.getInstance();
    private String mJcaProviderName = null;
    private String mJceProviderName = null;
    private char[] mAuthCode;
    private Properties properties;
    private int id;
    protected transient CachingKeyStoreWrapper keyStore;

    protected void setKeyStore(KeyStore keystore) throws KeyStoreException {
        this.keyStore = keystore == null ? null : new CachingKeyStoreWrapper(keystore, CesecoreConfiguration.isKeyStoreCacheEnabled());
    }

    protected CachingKeyStoreWrapper getKeyStore() throws CryptoTokenOfflineException {
        this.autoActivate();
        if (this.keyStore == null) {
            String msg = intres.getLocalizedMessage("token.errorinstansiate", this.mJcaProviderName, "keyStore (" + this.id + ") == null");
            throw new CryptoTokenOfflineException(msg);
        }
        return this.keyStore;
    }

    protected void autoActivate() {
        if (this.mAuthCode != null && this.keyStore == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to autoactivate CryptoToken");
                }
                this.activate(this.mAuthCode);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
    }

    @Override
    public boolean doPermitExtractablePrivateKey() {
        return this.getProperties().containsKey("allow.extractable.privatekey") && Boolean.parseBoolean(this.getProperties().getProperty("allow.extractable.privatekey"));
    }

    public abstract boolean permitExtractablePrivateKeyForTest();

    @Override
    public void testKeyPair(String alias) throws InvalidKeyException, CryptoTokenOfflineException {
        PrivateKey privateKey = this.getPrivateKey(alias);
        PublicKey publicKey = this.getPublicKey(alias);
        this.testKeyPair(alias, publicKey, privateKey);
    }

    @Override
    public void testKeyPair(String alias, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException {
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            KeyTools.printPublicKeyInfo(publicKey, ps);
            ps.flush();
            log.debug((Object)("Testing key of type " + baos.toString()));
        }
        if (!this.permitExtractablePrivateKeyForTest() && KeyTools.isPrivateKeyExtractable(privateKey)) {
            String msg = intres.getLocalizedMessage("token.extractablekey", CesecoreConfiguration.isPermitExtractablePrivateKeys());
            if (!CesecoreConfiguration.isPermitExtractablePrivateKeys()) {
                throw new InvalidKeyException(msg);
            }
            log.info((Object)msg);
        }
        KeyTools.testKey(privateKey, publicKey, this.getSignProviderName());
    }

    protected PublicKey readPublicKey(String alias, boolean warn) throws KeyStoreException, CryptoTokenOfflineException {
        try {
            Certificate cert = this.getKeyStore().getCertificate(alias);
            PublicKey pubk = null;
            if (cert != null) {
                pubk = cert.getPublicKey();
            } else if (warn) {
                log.warn((Object)intres.getLocalizedMessage("token.nopublic", alias));
                if (log.isDebugEnabled()) {
                    Enumeration<String> en = this.getKeyStore().aliases();
                    while (en.hasMoreElements()) {
                        log.debug((Object)("Existing alias: " + en.nextElement()));
                    }
                }
            }
            return pubk;
        }
        catch (ProviderException e) {
            throw new CryptoTokenOfflineException(e);
        }
    }

    protected void init(Properties properties, boolean doAutoActivate, int id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(">init: doAutoActivate=" + doAutoActivate));
        }
        this.id = id;
        this.setProperties(properties);
        if (doAutoActivate) {
            this.autoActivate();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("<init: doAutoActivate=" + doAutoActivate));
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getTokenName() {
        return this.properties.getProperty("tokenName");
    }

    @Override
    public void setTokenName(String tokenName) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty("tokenName", tokenName);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        if (properties == null) {
            this.properties = new Properties();
        } else {
            if (log.isDebugEnabled()) {
                if (properties.containsKey("pin") || properties.containsKey("PIN")) {
                    Properties prop = new Properties();
                    prop.putAll((Map<?, ?>)properties);
                    if (properties.containsKey("pin")) {
                        prop.setProperty("pin", "hidden");
                    }
                    if (properties.containsKey("PIN")) {
                        prop.setProperty("PIN", "hidden");
                    }
                    log.debug((Object)("Prop: " + (prop != null ? prop.toString() : "null")));
                } else {
                    log.debug((Object)("Properties: " + (properties != null ? properties.toString() : "null")));
                }
            }
            this.properties = properties;
            String authCode = BaseCryptoToken.getAutoActivatePin(properties);
            this.mAuthCode = authCode == null ? null : authCode.toCharArray();
        }
    }

    public static String getAutoActivatePin(Properties properties) {
        String pin = properties.getProperty("pin");
        if (pin != null) {
            return StringTools.passwordDecryption(pin, "autoactivation pin");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Not using autoactivation pin");
        }
        return null;
    }

    public static String setAutoActivatePin(Properties properties, String pin, boolean encrypt) {
        String ret = null;
        if (StringUtils.isNotEmpty((String)pin)) {
            String authcode = pin;
            if (encrypt) {
                try {
                    authcode = StringTools.pbeEncryptStringWithSha256Aes192(pin);
                }
                catch (Exception e) {
                    log.error((Object)intres.getLocalizedMessage("token.nopinencrypt", new Object[0]), (Throwable)e);
                    authcode = pin;
                }
            }
            if (properties != null) {
                properties.setProperty("pin", authcode);
            }
            ret = "pin " + authcode;
        }
        return ret;
    }

    protected void setProviders(String jcaProviderClassName, String jceProviderClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Provider jcaProvider = (Provider)Class.forName(jcaProviderClassName).newInstance();
        this.setProvider(jcaProvider);
        this.mJcaProviderName = jcaProvider.getName();
        if (jceProviderClassName != null) {
            try {
                Provider jceProvider = (Provider)Class.forName(jceProviderClassName).newInstance();
                this.setProvider(jceProvider);
                this.mJceProviderName = jceProvider.getName();
            }
            catch (Exception e) {
                log.error((Object)intres.getLocalizedMessage("token.jceinitfail", new Object[0]), (Throwable)e);
            }
        } else {
            this.mJceProviderName = null;
        }
    }

    @Override
    public void storeKey(String alias, Key key, Certificate[] chain, char[] password) throws KeyStoreException {
        this.keyStore.setKeyEntry(alias, key, password, chain);
    }

    protected void setJCAProvider(Provider prov) {
        this.setProvider(prov);
        this.mJcaProviderName = prov != null ? prov.getName() : null;
    }

    protected void setJCAProviderName(String pName) {
        this.mJcaProviderName = pName;
    }

    private void setProvider(Provider prov) {
        if (prov != null) {
            String pName = prov.getName();
            if (pName.startsWith("LunaJCA")) {
                prov.put("Alg.Alias.Cipher.RSA/NONE/NoPadding", "RSA//NoPadding");
                prov.put("Alg.Alias.Cipher.1.2.840.113549.1.1.1", "RSA//NoPadding");
                prov.put("Alg.Alias.Cipher.RSA/ECB/PKCS1Padding", "RSA//PKCS1v1_5");
                prov.put("Alg.Alias.Cipher.1.2.840.113549.3.7", "DES3/CBC/PKCS5Padding");
            }
            if (Security.getProvider(pName) == null) {
                Security.addProvider(prov);
            }
            if (Security.getProvider(pName) == null) {
                throw new ProviderException("Not possible to install provider: " + pName);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No provider passed to setProvider()");
        }
    }

    @Override
    public String getSignProviderName() {
        return this.mJcaProviderName;
    }

    @Override
    public String getEncProviderName() {
        if (this.mJceProviderName == null) {
            return this.mJcaProviderName;
        }
        return this.mJceProviderName;
    }

    @Override
    public boolean isAliasUsed(String alias) {
        boolean aliasInUse = false;
        try {
            this.getPublicKey(alias, false);
            aliasInUse = true;
        }
        catch (CryptoTokenOfflineException e) {
            try {
                this.getPrivateKey(alias, false);
                aliasInUse = true;
            }
            catch (CryptoTokenOfflineException e2) {
                try {
                    this.getKey(alias, false);
                    aliasInUse = true;
                }
                catch (CryptoTokenOfflineException cryptoTokenOfflineException) {
                    // empty catch block
                }
            }
        }
        return aliasInUse;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) throws CryptoTokenOfflineException {
        return this.getPrivateKey(alias, true);
    }

    private PrivateKey getPrivateKey(String alias, boolean warn) throws CryptoTokenOfflineException {
        try {
            PrivateKey privateK = (PrivateKey)this.getKeyStore().getKey(alias, this.mAuthCode != null && this.mAuthCode.length > 0 ? this.mAuthCode : null);
            if (privateK == null) {
                if (warn) {
                    log.warn((Object)intres.getLocalizedMessage("token.noprivate", alias));
                    if (log.isDebugEnabled()) {
                        Enumeration<String> aliases = this.getKeyStore().aliases();
                        while (aliases.hasMoreElements()) {
                            log.debug((Object)("Existing alias: " + aliases.nextElement()));
                        }
                    }
                }
                String msg = intres.getLocalizedMessage("token.errornosuchkey", alias);
                throw new CryptoTokenOfflineException(msg);
            }
            return privateK;
        }
        catch (KeyStoreException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (ProviderException e) {
            throw new CryptoTokenOfflineException(e);
        }
    }

    @Override
    public PublicKey getPublicKey(String alias) throws CryptoTokenOfflineException {
        return this.getPublicKey(alias, true);
    }

    private PublicKey getPublicKey(String alias, boolean warn) throws CryptoTokenOfflineException {
        try {
            PublicKey publicK = this.readPublicKey(alias, warn);
            if (publicK == null) {
                String msg = intres.getLocalizedMessage("token.errornosuchkey", alias);
                throw new CryptoTokenOfflineException(msg);
            }
            String str = this.getProperties().getProperty("explicit.ecc.publickey.parameters");
            boolean explicitEccParameters = Boolean.parseBoolean(str);
            if (explicitEccParameters && publicK.getAlgorithm().equals("EC")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Using explicit parameter encoding for ECC key.");
                }
                publicK = ECKeyUtil.publicToExplicitParameters((PublicKey)publicK, (String)"BC");
            }
            return publicK;
        }
        catch (KeyStoreException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (IllegalArgumentException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoTokenOfflineException(e);
        }
    }

    @Override
    public Key getKey(String alias) throws CryptoTokenOfflineException {
        return this.getKey(alias, true);
    }

    private Key getKey(String alias, boolean warn) throws CryptoTokenOfflineException {
        try {
            Key key = this.getKeyStore().getKey(alias, this.mAuthCode != null && this.mAuthCode.length > 0 ? this.mAuthCode : null);
            if (key == null && (key = this.getKeyFromProperties(alias)) == null) {
                if (warn) {
                    log.warn((Object)intres.getLocalizedMessage("token.errornosuchkey", alias));
                    if (log.isDebugEnabled()) {
                        Enumeration<String> aliases = this.getKeyStore().aliases();
                        while (aliases.hasMoreElements()) {
                            log.debug((Object)("Existing alias: " + aliases.nextElement()));
                        }
                    }
                }
                String msg = intres.getLocalizedMessage("token.errornosuchkey", alias);
                throw new CryptoTokenOfflineException(msg);
            }
            return key;
        }
        catch (KeyStoreException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoTokenOfflineException(e);
        }
        catch (ProviderException e) {
            throw new CryptoTokenOfflineException(e);
        }
    }

    private Key getKeyFromProperties(String alias) {
        Key key = null;
        Properties prop = this.getProperties();
        String str = prop.getProperty(alias);
        if (StringUtils.isNotEmpty((String)str)) {
            try {
                PrivateKey privK = this.getPrivateKey("symwrap");
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", this.getEncProviderName());
                cipher.init(4, privK);
                byte[] bytes = Hex.decode((String)str);
                key = cipher.unwrap(bytes, "AES", 3);
            }
            catch (CryptoTokenOfflineException e) {
                log.debug((Object)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.debug((Object)e);
            }
            catch (NoSuchProviderException e) {
                log.debug((Object)e);
            }
            catch (NoSuchPaddingException e) {
                log.debug((Object)e);
            }
            catch (InvalidKeyException e) {
                log.debug((Object)e);
            }
        }
        return key;
    }

    @Override
    public void reset() {
    }

    @Override
    public int getTokenStatus() {
        int ret = 2;
        try {
            this.getKeyStore();
            ret = 1;
        }
        catch (CryptoTokenOfflineException cryptoTokenOfflineException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public byte[] extractKey(String privKeyTransform, String encryptionKeyAlias, String privateKeyAlias) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, CryptoTokenOfflineException, PrivateKeyNotExtractableException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParam = null;
        if (privKeyTransform.matches(".+\\/CBC\\/.+")) {
            byte[] cbcIv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            ivParam = new IvParameterSpec(cbcIv);
        }
        return this.extractKey(privKeyTransform, ivParam, encryptionKeyAlias, privateKeyAlias);
    }

    @Override
    public byte[] extractKey(String privKeyTransform, AlgorithmParameterSpec spec, String encryptionKeyAlias, String privateKeyAlias) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, CryptoTokenOfflineException, PrivateKeyNotExtractableException, InvalidAlgorithmParameterException {
        if (this.doPermitExtractablePrivateKey()) {
            byte[] encryptedKey;
            Key encryptionKey = this.getKey(encryptionKeyAlias);
            PrivateKey privateKey = this.getPrivateKey(privateKeyAlias);
            if (privateKey == null) {
                throw new PrivateKeyNotExtractableException("Extracting key with alias '" + privateKeyAlias + "' return null.");
            }
            Cipher c = null;
            c = Cipher.getInstance(privKeyTransform, this.getEncProviderName());
            if (spec == null) {
                c.init(1, encryptionKey);
            } else {
                c.init(1, encryptionKey, spec);
            }
            try {
                byte[] data = privateKey.getEncoded();
                if (StringUtils.containsIgnoreCase((String)privKeyTransform, (String)"NoPadding")) {
                    PKCS7Padding padding = new PKCS7Padding();
                    int rem = data.length % c.getBlockSize();
                    int padlen = c.getBlockSize() - rem;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Padding key data with " + padlen + " bytes, using PKCS7/5Padding. Total len: " + (data.length + padlen)));
                    }
                    byte[] newdata = Arrays.copyOf(data, data.length + padlen);
                    padding.addPadding(newdata, data.length);
                    data = newdata;
                }
                encryptedKey = c.doFinal(data);
            }
            catch (BadPaddingException e) {
                throw new PrivateKeyNotExtractableException("Extracting key with alias '" + privateKeyAlias + "' failed.");
            }
            return encryptedKey;
        }
        String msg = intres.getLocalizedMessage("token.errornotextractable", privateKeyAlias, encryptionKeyAlias);
        throw new PrivateKeyNotExtractableException(msg);
    }

    @Override
    public List<String> getAliases() throws KeyStoreException, CryptoTokenOfflineException {
        return Collections.list(this.getKeyStore().aliases());
    }

    @Override
    public boolean isAutoActivationPinPresent() {
        return BaseCryptoToken.getAutoActivatePin(this.getProperties()) != null;
    }
}

