/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;

public class CachingKeyStoreWrapper {
    private static final Logger log = Logger.getLogger(CachingKeyStoreWrapper.class);
    private final ReentrantLock updateLock = new ReentrantLock(false);
    private final KeyStore keyStore;
    private final boolean cachingEnabled;
    private HashMap<String, KeyStoreMapEntry> keyStoreCache = new HashMap();

    @Deprecated
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public CachingKeyStoreWrapper(KeyStore keyStore, boolean cachingEnabled) throws KeyStoreException {
        this.keyStore = keyStore;
        this.cachingEnabled = cachingEnabled;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cachingEnabled: " + cachingEnabled));
        }
        if (cachingEnabled) {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate certificate;
                String alias = aliases.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("KeyStore has alias: " + alias));
                }
                KeyStoreMapEntry keyStoreMapEntry = new KeyStoreMapEntry();
                keyStoreMapEntry.certificateChain = keyStore.getCertificateChain(alias);
                if (keyStoreMapEntry.certificateChain == null && (certificate = keyStore.getCertificate(alias)) != null) {
                    keyStoreMapEntry.certificateChain = new Certificate[]{certificate};
                }
                this.keyStoreCache.put(alias, keyStoreMapEntry);
            }
        }
    }

    public Certificate getCertificate(String alias) throws KeyStoreException {
        if (this.cachingEnabled) {
            KeyStoreMapEntry keyStoreMapEntry = this.keyStoreCache.get(alias);
            if (keyStoreMapEntry == null) {
                return null;
            }
            if (keyStoreMapEntry.certificateChain == null || keyStoreMapEntry.certificateChain.length == 0) {
                return null;
            }
            return keyStoreMapEntry.certificateChain[0];
        }
        return this.keyStore.getCertificate(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCertificateEntry(String alias, Certificate certificate) throws KeyStoreException {
        this.keyStore.setCertificateEntry(alias, certificate);
        if (this.cachingEnabled) {
            this.updateLock.lock();
            try {
                HashMap<String, KeyStoreMapEntry> clone = new HashMap<String, KeyStoreMapEntry>(this.keyStoreCache);
                KeyStoreMapEntry keyStoreMapEntry = clone.get(alias);
                if (keyStoreMapEntry == null) {
                    keyStoreMapEntry = new KeyStoreMapEntry();
                }
                keyStoreMapEntry.certificateChain = new Certificate[]{certificate};
                clone.put(alias, keyStoreMapEntry);
                this.keyStoreCache = clone;
            }
            finally {
                this.updateLock.unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updated certificate entry in cache for alias: " + alias));
            }
        }
    }

    public Enumeration<String> aliases() throws KeyStoreException {
        if (this.cachingEnabled) {
            return new Vector<String>(this.keyStoreCache.keySet()).elements();
        }
        return this.keyStore.aliases();
    }

    public void store(OutputStream outputStream, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.keyStore.store(outputStream, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.keyStore.setKeyEntry(alias, key, password, chain);
        if (this.cachingEnabled) {
            KeyStoreMapEntry keyStoreMapEntry = new KeyStoreMapEntry();
            keyStoreMapEntry.certificateChain = chain;
            keyStoreMapEntry.key = key;
            this.updateLock.lock();
            try {
                HashMap<String, KeyStoreMapEntry> clone = new HashMap<String, KeyStoreMapEntry>(this.keyStoreCache);
                clone.put(alias, keyStoreMapEntry);
                this.keyStoreCache = clone;
            }
            finally {
                this.updateLock.unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updated key entry in cache for alias: " + alias));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntry(String alias) throws KeyStoreException {
        this.keyStore.deleteEntry(alias);
        if (this.cachingEnabled) {
            this.updateLock.lock();
            try {
                HashMap<String, KeyStoreMapEntry> clone = new HashMap<String, KeyStoreMapEntry>(this.keyStoreCache);
                clone.remove(alias);
                this.keyStoreCache = clone;
            }
            finally {
                this.updateLock.unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed entry from cache for alias: " + alias));
            }
        }
    }

    public KeyStore.Entry getEntry(String alias, KeyStore.ProtectionParameter protParam) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        if (this.cachingEnabled) {
            KeyStoreMapEntry keyStoreMapEntry = this.keyStoreCache.get(alias);
            if (keyStoreMapEntry == null) {
                return null;
            }
            if (keyStoreMapEntry.key instanceof PrivateKey) {
                return new KeyStore.PrivateKeyEntry((PrivateKey)keyStoreMapEntry.key, keyStoreMapEntry.certificateChain);
            }
            if (keyStoreMapEntry.key instanceof SecretKey) {
                return new KeyStore.SecretKeyEntry((SecretKey)keyStoreMapEntry.key);
            }
            if (keyStoreMapEntry.certificateChain != null && keyStoreMapEntry.certificateChain.length > 0) {
                return new KeyStore.TrustedCertificateEntry(keyStoreMapEntry.certificateChain[0]);
            }
            return null;
        }
        return this.keyStore.getEntry(alias, protParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        this.keyStore.setEntry(alias, entry, protParam);
        if (this.cachingEnabled) {
            KeyStoreMapEntry keyStoreMapEntry = new KeyStoreMapEntry();
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                keyStoreMapEntry.certificateChain = privateKeyEntry.getCertificateChain();
                keyStoreMapEntry.key = privateKeyEntry.getPrivateKey();
            } else if (entry instanceof KeyStore.SecretKeyEntry) {
                keyStoreMapEntry.certificateChain = null;
                keyStoreMapEntry.key = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            } else {
                keyStoreMapEntry.certificateChain = new Certificate[]{((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate()};
                keyStoreMapEntry.key = null;
            }
            this.updateLock.lock();
            try {
                HashMap<String, KeyStoreMapEntry> clone = new HashMap<String, KeyStoreMapEntry>(this.keyStoreCache);
                clone.put(alias, keyStoreMapEntry);
                this.keyStoreCache = clone;
            }
            finally {
                this.updateLock.unlock();
            }
        }
    }

    public Provider getProvider() {
        return this.keyStore.getProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getKey(String alias, char[] password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        if (this.cachingEnabled) {
            KeyStoreMapEntry keyStoreMapEntry = this.keyStoreCache.get(alias);
            if (keyStoreMapEntry == null) {
                return null;
            }
            if (keyStoreMapEntry.key == null) {
                this.updateLock.lock();
                try {
                    if (keyStoreMapEntry.key == null) {
                        Key key;
                        keyStoreMapEntry.key = key = this.keyStore.getKey(alias, password);
                    }
                }
                finally {
                    this.updateLock.unlock();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Caching key for alias: " + alias));
                }
            }
            return keyStoreMapEntry.key;
        }
        return this.keyStore.getKey(alias, password);
    }

    private class KeyStoreMapEntry {
        Key key;
        Certificate[] certificateChain;

        private KeyStoreMapEntry() {
        }
    }
}

