/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import java.util.Properties;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.cesecore.keys.token.CryptoTokenAuthenticationFailedException;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.keys.token.PrivateKeyNotExtractableException;

public interface CryptoToken
extends Serializable {
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_OFFLINE = 2;
    public static final String AUTOACTIVATE_PIN_PROPERTY = "pin";
    public static final String ALLOW_EXTRACTABLE_PRIVATE_KEY = "allow.extractable.privatekey";
    public static final String KEYPLACEHOLDERS_PROPERTY = "statedump.keytemplates";
    public static final String KEYPLACEHOLDERS_OUTER_SEPARATOR = "|";
    public static final String KEYPLACEHOLDERS_INNER_SEPARATOR = ";";
    public static final String EXPLICIT_ECC_PUBLICKEY_PARAMETERS = "explicit.ecc.publickey.parameters";
    public static final String TOKENNAME_PROPERTY = "tokenName";
    public static final String ALLOW_NONEXISTING_SLOT_PROPERTY = "allow.nonexisting.slot";

    public void init(Properties var1, byte[] var2, int var3) throws Exception;

    public int getId();

    public void activate(char[] var1) throws CryptoTokenOfflineException, CryptoTokenAuthenticationFailedException;

    public void deactivate();

    public boolean isAliasUsed(String var1);

    public PrivateKey getPrivateKey(String var1) throws CryptoTokenOfflineException;

    public PublicKey getPublicKey(String var1) throws CryptoTokenOfflineException;

    public Key getKey(String var1) throws CryptoTokenOfflineException;

    public void deleteEntry(String var1) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, CryptoTokenOfflineException;

    public void generateKeyPair(String var1, String var2) throws InvalidAlgorithmParameterException, CryptoTokenOfflineException;

    public void generateKeyPair(AlgorithmParameterSpec var1, String var2) throws InvalidAlgorithmParameterException, CertificateException, IOException, CryptoTokenOfflineException;

    public void generateKey(String var1, int var2, String var3) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CryptoTokenOfflineException, InvalidKeyException, InvalidAlgorithmParameterException, SignatureException, CertificateException, IOException, NoSuchPaddingException, IllegalBlockSizeException;

    public String getSignProviderName();

    public String getEncProviderName();

    public void reset();

    public String getTokenName();

    public void setTokenName(String var1);

    public int getTokenStatus();

    public Properties getProperties();

    public void setProperties(Properties var1);

    public void storeKey(String var1, Key var2, Certificate[] var3, char[] var4) throws KeyStoreException;

    public byte[] getTokenData();

    public void testKeyPair(String var1) throws InvalidKeyException, CryptoTokenOfflineException;

    public void testKeyPair(String var1, PublicKey var2, PrivateKey var3) throws InvalidKeyException;

    public byte[] extractKey(String var1, String var2, String var3) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, CryptoTokenOfflineException, PrivateKeyNotExtractableException, InvalidAlgorithmParameterException;

    public byte[] extractKey(String var1, AlgorithmParameterSpec var2, String var3, String var4) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, CryptoTokenOfflineException, PrivateKeyNotExtractableException, InvalidAlgorithmParameterException;

    public boolean doPermitExtractablePrivateKey();

    public List<String> getAliases() throws KeyStoreException, CryptoTokenOfflineException;

    public boolean isAutoActivationPinPresent();
}

