/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.cesecore.internal.InternalResources;
import org.cesecore.keys.token.AvailableCryptoToken;
import org.cesecore.keys.token.CryptoToken;
import org.cesecore.keys.token.NullCryptoToken;
import org.cesecore.keys.token.PKCS11CryptoToken;
import org.cesecore.keys.token.SoftCryptoToken;
import org.cesecore.keys.token.p11.exception.NoSuchSlotException;

public class CryptoTokenFactory {
    private static transient Logger log = Logger.getLogger(CryptoTokenFactory.class);
    private Map<String, AvailableCryptoToken> availabletokens = new HashMap<String, AvailableCryptoToken>(4);
    private static CryptoTokenFactory instance = null;

    private CryptoTokenFactory() {
    }

    public static synchronized CryptoTokenFactory instance() {
        if (instance == null) {
            instance = new CryptoTokenFactory();
            instance.addAvailableCryptoToken("se.primeKey.caToken.card.PrimeCAToken", "PrimeCAToken", false, true);
            instance.addAvailableCryptoToken(PKCS11CryptoToken.class.getName(), "PKCS#11", false, true);
            instance.addAvailableCryptoToken(SoftCryptoToken.class.getName(), "SOFT", true, true);
            instance.addAvailableCryptoToken(NullCryptoToken.class.getName(), "Null", false, false);
        }
        return instance;
    }

    public Collection<AvailableCryptoToken> getAvailableCryptoTokens() {
        return this.availabletokens.values();
    }

    public AvailableCryptoToken getAvailableCryptoToken(String classname) {
        if (classname == null) {
            return null;
        }
        return this.availabletokens.get(classname);
    }

    boolean addAvailableCryptoToken(String classname, String name, boolean translateable, boolean use) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">addAvailableCryptoToken: " + classname));
        }
        boolean retval = false;
        if (!this.availabletokens.containsKey(classname)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("CryptoTokenFactory adding available crypto token " + classname));
            }
            if (this.loadClass(classname)) {
                this.availabletokens.put(classname, new AvailableCryptoToken(classname, name, translateable, use));
                retval = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registered " + classname + " successfully."));
                }
            } else {
                log.info((Object)InternalResources.getInstance().getLocalizedMessage("token.inforegisterclasspath", classname));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<addAvailableCryptoToken: " + classname));
        }
        return retval;
    }

    private boolean loadClass(String classname) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(classname).newInstance();
            return true;
        }
        catch (ClassNotFoundException e) {
            log.info((Object)InternalResources.getInstance().getLocalizedMessage("token.classnotfound", classname));
        }
        catch (InstantiationException e) {
            log.info((Object)InternalResources.getInstance().getLocalizedMessage("token.errorinstansiate", classname, e.getMessage()));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("IllegalAccessException: " + classname), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)("NoClassDefFoundError: " + classname), (Throwable)e);
        }
        return false;
    }

    public static final CryptoToken createCryptoToken(String inClassname, Properties properties, byte[] data, int cryptoTokenId, String tokenName) throws NoSuchSlotException {
        boolean allowNonExistingSlot = Boolean.valueOf(properties.getProperty("allow.nonexisting.slot", Boolean.FALSE.toString()));
        return CryptoTokenFactory.createCryptoToken(inClassname, properties, data, cryptoTokenId, tokenName, allowNonExistingSlot);
    }

    public static final CryptoToken createCryptoToken(String inClassname, Properties properties, byte[] data, int cryptoTokenId, String tokenName, boolean allowNonExistingSlot) throws NoSuchSlotException {
        String classname;
        if (inClassname != null) {
            classname = inClassname;
        } else {
            classname = NullCryptoToken.class.getName();
            log.info((Object)"This must be an imported CA that is being upgraded. Use NullCryptoToken.");
        }
        CryptoToken token = CryptoTokenFactory.createTokenFromClass(classname);
        if (token == null) {
            log.error((Object)("No token. Classpath=" + classname));
            return null;
        }
        try {
            token.init(properties, data, cryptoTokenId);
        }
        catch (NoSuchSlotException e) {
            String msg = "Unable to access PKCS#11 slot for crypto token '" + tokenName + "' (" + cryptoTokenId + "). Perhaps the token was removed? " + e.getMessage();
            if (allowNonExistingSlot) {
                log.warn((Object)msg);
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("Error initializing Crypto Token. Classpath=" + classname), (Throwable)e);
        }
        token.setTokenName(tokenName);
        return token;
    }

    private static final CryptoToken createTokenFromClass(String classpath) {
        try {
            Class<?> implClass = Class.forName(classpath);
            Object obj = implClass.newInstance();
            return (CryptoToken)obj;
        }
        catch (Throwable e) {
            log.error((Object)("Error contructing Crypto Token (setting to null). Classpath=" + classpath), e);
            return null;
        }
    }
}

