/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token;

import java.io.Serializable;
import java.util.Properties;
import org.cesecore.keys.token.CryptoToken;
import org.cesecore.keys.token.p11.Pkcs11SlotLabelType;

public class CryptoTokenInfo
implements Serializable {
    private static final long serialVersionUID = 5025517840531557857L;
    private final Integer cryptoTokenId;
    private final String name;
    private final boolean active;
    private final boolean autoActivation;
    private final String type;
    private final Properties cryptoTokenProperties;

    public CryptoTokenInfo(Integer cryptoTokenId, String name, boolean active, boolean autoActivation, Class<? extends CryptoToken> type, Properties cryptoTokenProperties) {
        this.cryptoTokenId = cryptoTokenId;
        this.name = name;
        this.active = active;
        this.autoActivation = autoActivation;
        this.type = type.getSimpleName();
        this.cryptoTokenProperties = cryptoTokenProperties;
    }

    public Integer getCryptoTokenId() {
        return this.cryptoTokenId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAutoActivation() {
        return this.autoActivation;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAllowExportPrivateKey() {
        return Boolean.valueOf(this.cryptoTokenProperties.getProperty("allow.extractable.privatekey", Boolean.FALSE.toString()));
    }

    public String getP11Library() {
        return this.cryptoTokenProperties.getProperty("sharedLibrary", "");
    }

    public String getP11Slot() {
        return this.cryptoTokenProperties.getProperty("slotLabelValue");
    }

    public String getP11SlotLabelType() {
        Pkcs11SlotLabelType slotLabelType = Pkcs11SlotLabelType.getFromKey(this.cryptoTokenProperties.getProperty("slotLabelType"));
        if (slotLabelType != null) {
            return slotLabelType.getKey();
        }
        return null;
    }

    public String getP11SlotLabelTypeDescription() {
        Pkcs11SlotLabelType slotLabelType = Pkcs11SlotLabelType.getFromKey(this.cryptoTokenProperties.getProperty("slotLabelType"));
        if (slotLabelType != null) {
            return slotLabelType.getDescription();
        }
        return null;
    }

    public String getP11AttributeFile() {
        return this.cryptoTokenProperties.getProperty("attributesFile", "");
    }

    public Properties getCryptoTokenProperties() {
        return this.cryptoTokenProperties;
    }
}

