/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.security.auth.DestroyFailedException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.cesecore.internal.InternalResources;
import org.cesecore.keys.token.BaseCryptoToken;
import org.cesecore.keys.token.CryptoTokenAuthenticationFailedException;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.keys.token.p11.P11Slot;
import org.cesecore.keys.token.p11.P11SlotUser;
import org.cesecore.keys.token.p11.Pkcs11SlotLabelType;
import org.cesecore.keys.token.p11.exception.NoSuchSlotException;
import org.cesecore.keys.util.KeyStoreTools;

public class PKCS11CryptoToken
extends BaseCryptoToken
implements P11SlotUser {
    private static final long serialVersionUID = 7719014139640717867L;
    private static final Logger log = Logger.getLogger(PKCS11CryptoToken.class);
    private static final InternalResources intres = InternalResources.getInstance();
    public static final String SLOT_LABEL_VALUE = "slotLabelValue";
    public static final String SLOT_LABEL_TYPE = "slotLabelType";
    public static final String SHLIB_LABEL_KEY = "sharedLibrary";
    public static final String ATTRIB_LABEL_KEY = "attributesFile";
    public static final String PASSWORD_LABEL_KEY = "pin";
    @Deprecated
    public static final String SLOT_LIST_INDEX_KEY = "slotListIndex";
    @Deprecated
    public static final String SLOT_LABEL_KEY = "slot";
    public static final String TOKEN_FRIENDLY_NAME = "tokenFriendlyName";
    private transient P11Slot p11slot;
    private String sSlotLabel = null;

    public PKCS11CryptoToken() throws InstantiationException {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("sun.security.pkcs11.SunPKCS11");
        }
        catch (ClassNotFoundException t) {
            throw new InstantiationException("PKCS11 provider class sun.security.pkcs11.SunPKCS11 not found.");
        }
    }

    @Override
    public void init(Properties properties, byte[] data, int id) throws CryptoTokenOfflineException, NoSuchSlotException {
        this.setProperties(properties);
        this.init(properties, false, id);
        this.sSlotLabel = PKCS11CryptoToken.getSlotLabel(SLOT_LABEL_VALUE, properties);
        Pkcs11SlotLabelType type = Pkcs11SlotLabelType.getFromKey(PKCS11CryptoToken.getSlotLabel(SLOT_LABEL_TYPE, properties));
        String sharedLibrary = properties.getProperty(SHLIB_LABEL_KEY);
        String attributesFile = properties.getProperty(ATTRIB_LABEL_KEY);
        String friendlyName = properties.getProperty(TOKEN_FRIENDLY_NAME);
        this.p11slot = friendlyName != null ? P11Slot.getInstance(friendlyName, this.sSlotLabel, sharedLibrary, type, attributesFile, this, id) : P11Slot.getInstance(this.sSlotLabel, sharedLibrary, type, attributesFile, this, id);
        Provider provider = this.p11slot.getProvider();
        this.setJCAProvider(provider);
    }

    @Override
    public boolean isActive() {
        return this.getTokenStatus() == 1;
    }

    @Override
    public void activate(char[] authCode) throws CryptoTokenOfflineException, CryptoTokenAuthenticationFailedException {
        if (this.p11slot == null) {
            throw new CryptoTokenOfflineException("Slot not initialized.");
        }
        try {
            KeyStore keyStore = this.createKeyStore(authCode);
            this.setKeyStore(keyStore);
        }
        catch (Throwable t) {
            log.warn((Object)("Failed to initialize PKCS11 provider slot '" + this.sSlotLabel + "'."), t);
            CryptoTokenAuthenticationFailedException authfe = new CryptoTokenAuthenticationFailedException("Failed to initialize PKCS11 provider slot '" + this.sSlotLabel + "'.");
            authfe.initCause(t);
            throw authfe;
        }
        String msg = intres.getLocalizedMessage("token.activated", this.getId());
        log.info((Object)msg);
    }

    private KeyStore createKeyStore(char[] authCode) throws NoSuchAlgorithmException, CertificateException, UnsupportedEncodingException, IOException, KeyStoreException {
        KeyStore.PasswordProtection pwp = new KeyStore.PasswordProtection(authCode);
        Provider provider = this.p11slot.getProvider();
        KeyStore.Builder builder = KeyStore.Builder.newInstance("PKCS11", provider, pwp);
        KeyStore keyStore = builder.getKeyStore();
        log.debug((Object)("Loading key from slot '" + this.sSlotLabel + "' using pin."));
        if (provider.getClass().getName().equals("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) {
            keyStore.load(new ByteArrayInputStream(this.getSignProviderName().getBytes("UTF-8")), authCode);
        } else {
            keyStore.load(null, null);
        }
        try {
            pwp.destroy();
        }
        catch (DestroyFailedException e) {
            log.info((Object)"Detroy failed: ", (Throwable)e);
        }
        return keyStore;
    }

    @Override
    public void deactivate() {
        try {
            this.setKeyStore(null);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("This should never happen.");
        }
        if (this.p11slot != null) {
            this.p11slot.logoutFromSlotIfNoTokensActive();
        } else {
            log.debug((Object)"p11slot was null, token was not active trying to deactivate.");
        }
        String msg = intres.getLocalizedMessage("token.deactivate", this.getId());
        log.info((Object)msg);
    }

    @Override
    public void reset() {
        if (this.p11slot != null) {
            this.p11slot.reset();
        }
    }

    @Override
    public void deleteEntry(String alias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, CryptoTokenOfflineException {
        if (StringUtils.isNotEmpty((String)alias)) {
            KeyStoreTools cont = new KeyStoreTools(this.getKeyStore(), this.getSignProviderName());
            cont.deleteEntry(alias);
            String msg = intres.getLocalizedMessage("token.deleteentry", alias, this.getId());
            log.info((Object)msg);
        } else {
            log.debug((Object)"Trying to delete keystore entry with empty alias.");
        }
    }

    @Override
    public void generateKeyPair(String keySpec, String alias) throws InvalidAlgorithmParameterException, CryptoTokenOfflineException {
        if (StringUtils.isNotEmpty((String)alias)) {
            KeyStoreTools cont = new KeyStoreTools(this.getKeyStore(), this.getSignProviderName());
            cont.generateKeyPair(keySpec, alias);
        } else {
            log.debug((Object)"Trying to generate keys with empty alias.");
        }
    }

    @Override
    public void generateKeyPair(AlgorithmParameterSpec spec, String alias) throws InvalidAlgorithmParameterException, CertificateException, IOException, CryptoTokenOfflineException {
        if (StringUtils.isNotEmpty((String)alias)) {
            KeyStoreTools cont = new KeyStoreTools(this.getKeyStore(), this.getSignProviderName());
            cont.generateKeyPair(spec, alias);
        } else {
            log.debug((Object)"Trying to generate keys with empty alias.");
        }
    }

    @Override
    public void generateKey(String algorithm, int keysize, String alias) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CryptoTokenOfflineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate key, " + algorithm + ", " + keysize + ", " + alias));
        }
        if (StringUtils.isNotEmpty((String)alias)) {
            KeyStoreTools cont = new KeyStoreTools(this.getKeyStore(), this.getSignProviderName());
            cont.generateKey(algorithm, keysize, alias);
        } else {
            log.debug((Object)"Trying to generate keys with empty alias.");
        }
    }

    @Override
    public byte[] getTokenData() {
        return null;
    }

    protected P11Slot getP11slot() {
        return this.p11slot;
    }

    private static String getSlotLabel(String sSlotLabelKey, Properties properties) {
        String ret = null;
        if (sSlotLabelKey != null && properties != null && (ret = properties.getProperty(sSlotLabelKey)) != null) {
            ret = ret.trim();
        }
        return ret;
    }

    @Deprecated
    public static Properties upgradePropertiesFileFrom5_0_x(Properties properties) {
        Properties returnValue = new Properties();
        for (Object key : properties.keySet()) {
            String keyString = (String)key;
            if (keyString.equals(SLOT_LABEL_KEY)) {
                String keyValue = properties.getProperty(keyString);
                String oldLabelPrefix = "TOKEN_LABEL:";
                String oldIndexPrefix = "SLOT_LIST_IX:";
                String oldSlotNumberPrefix = "SLOT_ID:";
                String oldSunFilePrefix = "SUN_FILE:";
                String delimiter = ":";
                if (Pkcs11SlotLabelType.SLOT_NUMBER.validate(keyValue)) {
                    returnValue.setProperty(SLOT_LABEL_VALUE, keyValue);
                    returnValue.setProperty(SLOT_LABEL_TYPE, Pkcs11SlotLabelType.SLOT_NUMBER.getKey());
                    continue;
                }
                if (keyValue.startsWith("SLOT_ID:")) {
                    returnValue.setProperty(SLOT_LABEL_VALUE, keyValue.split(":", 2)[1]);
                    returnValue.setProperty(SLOT_LABEL_TYPE, Pkcs11SlotLabelType.SLOT_NUMBER.getKey());
                    continue;
                }
                if (keyValue.startsWith("SLOT_LIST_IX:")) {
                    returnValue.setProperty(SLOT_LABEL_VALUE, keyValue.split(":", 2)[1]);
                    returnValue.setProperty(SLOT_LABEL_TYPE, Pkcs11SlotLabelType.SLOT_INDEX.getKey());
                    continue;
                }
                if (keyValue.startsWith("TOKEN_LABEL:")) {
                    returnValue.setProperty(SLOT_LABEL_VALUE, keyValue.split(":", 2)[1]);
                    returnValue.setProperty(SLOT_LABEL_TYPE, Pkcs11SlotLabelType.SLOT_LABEL.getKey());
                    continue;
                }
                if (!keyValue.startsWith("SUN_FILE:")) continue;
                returnValue.setProperty(SLOT_LABEL_TYPE, Pkcs11SlotLabelType.SUN_FILE.getKey());
                continue;
            }
            if (((String)key).equals(SLOT_LIST_INDEX_KEY)) {
                String indexValue = properties.getProperty(keyString);
                if (indexValue.charAt(0) != 'i') {
                    indexValue = "i" + indexValue;
                }
                returnValue.setProperty(SLOT_LABEL_VALUE, indexValue);
                returnValue.setProperty(SLOT_LABEL_TYPE, Pkcs11SlotLabelType.SLOT_INDEX.getKey());
                continue;
            }
            returnValue.setProperty(keyString, properties.getProperty(keyString));
        }
        return returnValue;
    }

    @Override
    public boolean permitExtractablePrivateKeyForTest() {
        return this.doPermitExtractablePrivateKey();
    }
}

