/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;
import org.cesecore.keys.token.BaseCryptoToken;
import org.cesecore.keys.token.CryptoToken;
import org.cesecore.keys.token.CryptoTokenAuthenticationFailedException;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.keys.token.PrivateKeyNotExtractableException;

public class PublicCryptoToken
implements CryptoToken {
    private static final long serialVersionUID = 1L;
    private int id;
    private static final Logger log = Logger.getLogger(PublicCryptoToken.class);
    private PublicKey pk;
    private static final String providerName = "SunRsaSign";
    private String tokenName = "not available";

    @Override
    public void init(Properties properties, byte[] data, int _id) throws Exception {
        this.id = _id;
        if (data == null || data.length < 1) {
            String msg = "No data for public key in token with id: " + this.id;
            log.error((Object)msg);
            throw new Exception(msg);
        }
        this.pk = PublicCryptoToken.getPublicKey(data);
        if (this.pk == null) {
            String msg = "Not possible to initiate public key id: " + this.id;
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }

    private static PublicKey getPublicKey(byte[] data) {
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(data));
        }
        catch (InvalidKeySpecException e) {
            log.debug((Object)"Not an X509 key.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.debug((Object)"No RSA key factory available. Try to read key from cert instead.", (Throwable)e);
        }
        try {
            return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(data)).getPublicKey();
        }
        catch (CertificateException e) {
            log.debug((Object)"Public key data is not a certificate.", (Throwable)e);
            return null;
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void activate(char[] authenticationcode) throws CryptoTokenOfflineException, CryptoTokenAuthenticationFailedException {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public boolean isAliasUsed(String alias) {
        try {
            return this.getPublicKey(alias) != null;
        }
        catch (CryptoTokenOfflineException e) {
            return false;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) throws CryptoTokenOfflineException {
        return null;
    }

    @Override
    public PublicKey getPublicKey(String alias) throws CryptoTokenOfflineException {
        return this.pk;
    }

    @Override
    public Key getKey(String alias) throws CryptoTokenOfflineException {
        return null;
    }

    @Override
    public void deleteEntry(String alias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, CryptoTokenOfflineException {
    }

    @Override
    public void generateKeyPair(String keySpec, String alias) throws InvalidAlgorithmParameterException, CryptoTokenOfflineException {
    }

    @Override
    public void generateKeyPair(AlgorithmParameterSpec spec, String alias) throws InvalidAlgorithmParameterException, CertificateException, IOException, CryptoTokenOfflineException {
    }

    @Override
    public void generateKey(String algorithm, int keysize, String alias) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CryptoTokenOfflineException, InvalidKeyException, InvalidAlgorithmParameterException, SignatureException, CertificateException, IOException, NoSuchPaddingException, IllegalBlockSizeException {
    }

    @Override
    public String getSignProviderName() {
        return providerName;
    }

    @Override
    public String getEncProviderName() {
        return providerName;
    }

    @Override
    public void reset() {
    }

    @Override
    public int getTokenStatus() {
        if (this.pk == null) {
            return 2;
        }
        return 1;
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public byte[] getTokenData() {
        return this.pk.getEncoded();
    }

    @Override
    public byte[] extractKey(String privKeyTransform, String encryptionKeyAlias, String privateKeyAlias) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, CryptoTokenOfflineException, PrivateKeyNotExtractableException, InvalidAlgorithmParameterException {
        return null;
    }

    @Override
    public byte[] extractKey(String privKeyTransform, AlgorithmParameterSpec spec, String encryptionKeyAlias, String privateKeyAlias) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, CryptoTokenOfflineException, PrivateKeyNotExtractableException, InvalidAlgorithmParameterException {
        return null;
    }

    @Override
    public boolean doPermitExtractablePrivateKey() {
        return false;
    }

    @Override
    public List<String> getAliases() {
        return Arrays.asList("dummy");
    }

    @Override
    public void storeKey(String alias, Key key, Certificate[] chain, char[] password) throws KeyStoreException {
        if (chain == null || chain.length < 1) {
            return;
        }
        this.pk = chain[0].getPublicKey();
    }

    @Override
    public boolean isAutoActivationPinPresent() {
        return BaseCryptoToken.getAutoActivatePin(this.getProperties()) != null;
    }

    @Override
    public void testKeyPair(String alias) throws InvalidKeyException, CryptoTokenOfflineException {
        throw new CryptoTokenOfflineException("Implementation does not contain any private keys to use for test.");
    }

    @Override
    public void testKeyPair(String alias, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException {
        throw new InvalidKeyException("Implementation does not contain any private keys to use for test.");
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    @Override
    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }
}

