/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.internal.InternalResources;
import org.cesecore.keys.token.BaseCryptoToken;
import org.cesecore.keys.token.CryptoTokenAuthenticationFailedException;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.keys.token.PrivateKeyNotExtractableException;
import org.cesecore.keys.util.KeyStoreTools;
import org.cesecore.util.CryptoProviderTools;
import org.cesecore.util.StringTools;

public class SoftCryptoToken
extends BaseCryptoToken {
    private static final long serialVersionUID = 387950849444619646L;
    private static final Logger log = Logger.getLogger(SoftCryptoToken.class);
    private static final InternalResources intres = InternalResources.getInstance();
    public static final float LATEST_VERSION = 3.0f;
    public static final String NODEFAULTPWD = "NODEFAULTPWD";
    private byte[] keystoreData;
    private char[] keyStorePass;

    public SoftCryptoToken() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating SoftCryptoToken");
        }
    }

    @Override
    public void init(Properties properties, byte[] data, int cryptoTokenId) {
        String autoPwd;
        super.setJCAProviderName("BC");
        this.keystoreData = data;
        if (properties == null) {
            properties = new Properties();
        }
        if ((autoPwd = BaseCryptoToken.getAutoActivatePin(properties)) == null && properties.getProperty(NODEFAULTPWD) == null) {
            String keystorepass = StringTools.passwordDecryption(CesecoreConfiguration.getCaKeyStorePass(), "ca.keystorepass");
            boolean okPwd = this.checkSoftKeystorePassword(keystorepass.toCharArray(), cryptoTokenId);
            if (okPwd) {
                log.debug((Object)"Succeded to load keystore with password");
                BaseCryptoToken.setAutoActivatePin(properties, keystorepass, true);
            }
        } else if (autoPwd != null) {
            log.debug((Object)"Soft Crypto Token has autoactivation property set.");
        } else if (properties.getProperty(NODEFAULTPWD) != null) {
            log.debug((Object)"No default pwd allowed for this soft crypto token.");
        }
        boolean autoActivate = autoPwd != null || properties.getProperty(NODEFAULTPWD) == null;
        this.init(properties, autoActivate, cryptoTokenId);
    }

    @Override
    public void activate(char[] authCode) throws CryptoTokenAuthenticationFailedException, CryptoTokenOfflineException {
        if (this.keyStore != null) {
            log.debug((Object)("Ignoring activation request for already active CryptoToken: " + this.getId()));
            return;
        }
        String autoPwd = BaseCryptoToken.getAutoActivatePin(this.getProperties());
        if (autoPwd != null) {
            authCode = autoPwd.toCharArray();
        }
        if (this.keystoreData != null) {
            try {
                KeyStore keystore = this.loadKeyStore(this.keystoreData, authCode);
                this.setKeyStore(keystore);
                this.keyStorePass = authCode;
            }
            catch (IOException e) {
                String msg = intres.getLocalizedMessage("token.erroractivate", this.getId(), e.getMessage());
                log.info((Object)msg, (Throwable)e);
                CryptoTokenAuthenticationFailedException oe = new CryptoTokenAuthenticationFailedException(e.getMessage());
                oe.initCause(e);
                throw oe;
            }
            catch (Exception e) {
                String msg = intres.getLocalizedMessage("token.erroractivate", this.getId(), e.getMessage());
                log.info((Object)msg, (Throwable)e);
                CryptoTokenOfflineException oe = new CryptoTokenOfflineException(e.getMessage());
                oe.initCause(e);
                throw oe;
            }
            String msg = intres.getLocalizedMessage("token.activated", this.getId());
            log.info((Object)msg);
        } else {
            String msg = intres.getLocalizedMessage("token.erroractivate", this.getId(), "No keystore data available yet, creating new PKCS#12 keystore.");
            log.info((Object)msg);
            try {
                KeyStore keystore = KeyStore.getInstance("PKCS12", "BC");
                keystore.load(null, null);
                this.setKeyStore(keystore);
                this.keyStorePass = authCode;
                this.storeKeyStore();
            }
            catch (KeyStoreException e) {
                log.error((Object)e);
                throw new CryptoTokenAuthenticationFailedException(e.getMessage());
            }
            catch (NoSuchProviderException e) {
                log.error((Object)e);
                throw new CryptoTokenAuthenticationFailedException(e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)e);
                throw new CryptoTokenAuthenticationFailedException(e.getMessage());
            }
            catch (CertificateException e) {
                log.error((Object)e);
                throw new CryptoTokenAuthenticationFailedException(e.getMessage());
            }
            catch (IOException e) {
                log.error((Object)e);
                throw new CryptoTokenAuthenticationFailedException(e.getMessage());
            }
        }
    }

    public void checkPasswordBeforeExport(char[] authCode) throws CryptoTokenAuthenticationFailedException, CryptoTokenOfflineException, PrivateKeyNotExtractableException {
        if (!this.doPermitExtractablePrivateKey()) {
            String msg = intres.getLocalizedMessage("token.errornotextractable_allkeys", this.getId());
            throw new PrivateKeyNotExtractableException(msg);
        }
        try {
            if (authCode == null || authCode.length == 0) {
                String defaultpass = StringTools.passwordDecryption(CesecoreConfiguration.getCaKeyStorePass(), "ca.keystorepass");
                this.loadKeyStore(this.keystoreData, defaultpass.toCharArray());
            } else {
                this.loadKeyStore(this.keystoreData, authCode);
            }
        }
        catch (IOException e) {
            String msg = intres.getLocalizedMessage("token.wrongauthcode", this.getId(), e.getMessage());
            log.info((Object)msg, (Throwable)e);
            CryptoTokenAuthenticationFailedException oe = new CryptoTokenAuthenticationFailedException(e.getMessage());
            oe.initCause(e);
            throw oe;
        }
        catch (Exception e) {
            String msg = intres.getLocalizedMessage("token.erroractivate", this.getId(), e.getMessage());
            log.info((Object)msg, (Throwable)e);
            CryptoTokenOfflineException oe = new CryptoTokenOfflineException(e.getMessage());
            oe.initCause(e);
            throw oe;
        }
    }

    private KeyStore loadKeyStore(byte[] ksdata, char[] keystorepass) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException {
        CryptoProviderTools.installBCProviderIfNotAvailable();
        KeyStore keystore = KeyStore.getInstance("PKCS12", "BC");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading keystore data of size: " + (ksdata == null ? "null" : Integer.valueOf(ksdata.length))));
        }
        keystore.load(new ByteArrayInputStream(ksdata), keystorepass);
        return keystore;
    }

    @Override
    public void deactivate() {
        this.storeKeyStore();
        try {
            this.setKeyStore(null);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("This should never happen.");
        }
        String msg = intres.getLocalizedMessage("token.deactivate", this.getId());
        log.info((Object)msg);
    }

    void storeKeyStore() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.keyStore != null) {
                this.keyStore.store(baos, this.keyStorePass);
                this.keystoreData = baos.toByteArray();
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
        }
        catch (CertificateException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing soft keystore of size " + (this.keystoreData == null ? "null" : Integer.valueOf(this.keystoreData.length))));
        }
    }

    @Override
    public byte[] getTokenData() {
        this.storeKeyStore();
        return this.keystoreData;
    }

    private boolean checkSoftKeystorePassword(char[] authenticationCode, int cryptoTokenId) {
        try {
            if (this.keystoreData != null) {
                KeyStore keystore = KeyStore.getInstance("PKCS12", "BC");
                keystore.load(new ByteArrayInputStream(this.keystoreData), authenticationCode);
            }
            return true;
        }
        catch (Exception e) {
            log.debug((Object)"Error: ", (Throwable)e);
            log.info((Object)intres.getLocalizedMessage("token.wrongauthcode", cryptoTokenId));
            return false;
        }
    }

    @Override
    public void deleteEntry(String alias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, CryptoTokenOfflineException {
        if (StringUtils.isNotEmpty((String)alias)) {
            KeyStoreTools cont = new KeyStoreTools(this.getKeyStore(), this.getSignProviderName());
            try {
                cont.deleteEntry(alias);
                String msg = intres.getLocalizedMessage("token.deleteentry", alias, this.getId());
                log.info((Object)msg);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            this.storeKeyStore();
        } else {
            log.debug((Object)"Trying to delete keystore entry with empty alias.");
        }
    }

    @Override
    public void generateKeyPair(String keySpec, String alias) throws InvalidAlgorithmParameterException, CryptoTokenOfflineException {
        if (StringUtils.isNotEmpty((String)alias)) {
            KeyStoreTools cont = new KeyStoreTools(this.getKeyStore(), this.getSignProviderName());
            cont.generateKeyPair(keySpec, alias);
            this.storeKeyStore();
        } else {
            log.debug((Object)"Trying to generate keys with empty alias.");
        }
    }

    @Override
    public void generateKey(String algorithm, int keysize, String alias) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CryptoTokenOfflineException, InvalidKeyException, InvalidAlgorithmParameterException, SignatureException, CertificateException, IOException, NoSuchPaddingException, IllegalBlockSizeException {
        if (StringUtils.isNotEmpty((String)alias)) {
            KeyGenerator generator = KeyGenerator.getInstance(algorithm, this.getEncProviderName());
            generator.init(keysize);
            SecretKey key = generator.generateKey();
            PublicKey pubK = null;
            try {
                pubK = this.getPublicKey("symwrap");
            }
            catch (CryptoTokenOfflineException e) {
                this.generateKeyPair("2048", "symwrap");
                pubK = this.getPublicKey("symwrap");
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", this.getEncProviderName());
            cipher.init(3, pubK);
            byte[] out = cipher.wrap(key);
            String str = new String(Hex.encode((byte[])out));
            Properties prop = this.getProperties();
            prop.setProperty(alias, str);
            this.setProperties(prop);
        } else {
            log.debug((Object)"Trying to generate keys with empty alias.");
        }
    }

    @Override
    public void generateKeyPair(AlgorithmParameterSpec spec, String alias) throws InvalidAlgorithmParameterException, CertificateException, IOException, CryptoTokenOfflineException {
        if (StringUtils.isNotEmpty((String)alias)) {
            KeyStoreTools cont = new KeyStoreTools(this.getKeyStore(), this.getSignProviderName());
            cont.generateKeyPair(spec, alias);
            this.storeKeyStore();
        } else {
            log.debug((Object)"Trying to generate keys with empty alias.");
        }
    }

    @Override
    public boolean permitExtractablePrivateKeyForTest() {
        return true;
    }
}

