/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token.p11;

import java.io.File;
import java.security.AuthProvider;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.cesecore.internal.InternalResources;
import org.cesecore.keys.token.CryptoTokenOfflineException;
import org.cesecore.keys.token.p11.P11SlotUser;
import org.cesecore.keys.token.p11.Pkcs11SlotLabel;
import org.cesecore.keys.token.p11.Pkcs11SlotLabelType;
import org.cesecore.keys.token.p11.exception.NoSuchSlotException;

public class P11Slot {
    private static final Logger log = Logger.getLogger(P11Slot.class);
    private static final String ONLY_ONE = "onlyOne";
    private static final InternalResources intres = InternalResources.getInstance();
    private static final Map<String, P11Slot> slotMap = new HashMap<String, P11Slot>();
    private static final Set<String> slotsBeingCreated = new HashSet<String>();
    private static final Map<String, Set<P11Slot>> libMap = new HashMap<String, Set<P11Slot>>();
    private static final Map<Integer, P11SlotUser> tokenMap = new HashMap<Integer, P11SlotUser>();
    private final String slotNr;
    private final Pkcs11SlotLabelType slotLabelType;
    private final String sharedLibrary;
    private final String attributesFile;
    private final Set<Integer> tokenids = new HashSet<Integer>();
    private final String sunP11ConfigFileName;
    private final Provider provider;
    private boolean isSettingProvider = false;

    private P11Slot(String _slotNr, Pkcs11SlotLabelType slotLabelType, String _sharedLibrary, String _attributesFile) throws CryptoTokenOfflineException, NoSuchSlotException {
        this.slotNr = _slotNr;
        this.sharedLibrary = _sharedLibrary;
        this.attributesFile = _attributesFile;
        this.sunP11ConfigFileName = null;
        this.slotLabelType = slotLabelType;
        this.provider = this.createProvider();
    }

    private P11Slot(String configFileName) throws CryptoTokenOfflineException, NoSuchSlotException {
        this.sunP11ConfigFileName = configFileName;
        this.slotNr = null;
        this.sharedLibrary = null;
        this.attributesFile = null;
        this.slotLabelType = Pkcs11SlotLabelType.SUN_FILE;
        this.provider = this.createProvider();
    }

    public String toString() {
        if (this.slotNr == null && this.sharedLibrary == null) {
            return "P11, Sun configuration file name: " + this.sunP11ConfigFileName;
        }
        return "P11 slot " + this.slotNr + " using library " + this.sharedLibrary + '.';
    }

    public void reset() {
        String mapName = this.sharedLibrary != null ? new File(this.sharedLibrary).getName() : ONLY_ONE;
        for (P11Slot slot : libMap.get(mapName)) {
            for (Integer tokenId : slot.tokenids) {
                try {
                    tokenMap.get(tokenId).deactivate();
                }
                catch (Exception e) {
                    log.error((Object)"Not possible to deactivate token.", (Throwable)e);
                }
            }
        }
    }

    public static P11Slot getInstance(String slotLabel, String sharedLibrary, Pkcs11SlotLabelType slotLabelType, String attributesFile, P11SlotUser token, int id) throws CryptoTokenOfflineException, NoSuchSlotException {
        return P11Slot.getInstance(null, slotLabel, sharedLibrary, slotLabelType, attributesFile, token, id);
    }

    public static P11Slot getInstance(String friendlyName, String slotLabel, String sharedLibrary, Pkcs11SlotLabelType slotLabelType, String attributesFile, P11SlotUser token, int id) throws CryptoTokenOfflineException, NoSuchSlotException {
        if (sharedLibrary == null) {
            throw new IllegalArgumentException("sharedLibrary = null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("slotlabel: " + slotLabel));
            log.debug((Object)("sharedlib: " + sharedLibrary));
            log.debug((Object)("slotlabeltype: " + (Object)((Object)slotLabelType)));
            log.debug((Object)("attributesFile: " + attributesFile));
            log.debug((Object)("id: " + id));
            log.debug((Object)("P11Slot.getInstance(): '" + slotLabel + "', '" + sharedLibrary + "', " + (slotLabelType == null ? "null" : slotLabelType.toString()) + ", '" + attributesFile + "', " + id));
        }
        return P11Slot.getInstance(new SlotDataParam(friendlyName, slotLabel, sharedLibrary, slotLabelType, attributesFile), token, id);
    }

    public static P11Slot getInstance(String configFileName, P11SlotUser token, int id) throws CryptoTokenOfflineException, NoSuchSlotException {
        return P11Slot.getInstance(new SlotDataConfigFile(configFileName), token, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static P11Slot getInstance(SlotData data, P11SlotUser token, int id) throws CryptoTokenOfflineException, NoSuchSlotException {
        tokenMap.put(id, token);
        P11Slot slot = slotMap.get(data.getSlotLabel());
        if (slot == null) {
            Set<String> set = slotsBeingCreated;
            synchronized (set) {
                if (slotsBeingCreated.contains(data.getSlotLabel())) {
                    while ((slot = slotMap.get(data.getSlotLabel())) == null) {
                        if (!slotsBeingCreated.contains(data.getSlotLabel())) {
                            throw new CryptoTokenOfflineException(intres.getLocalizedMessage("token.errorcreatetoken", id));
                        }
                        try {
                            slotsBeingCreated.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException("This should never happen.", e);
                        }
                    }
                } else {
                    try {
                        slotsBeingCreated.add(data.getSlotLabel());
                        slot = data.getNewP11Slot();
                        slotMap.put(data.getSlotLabel(), slot);
                        if (slot == null) {
                            throw new CryptoTokenOfflineException(intres.getLocalizedMessage("token.errorcreatetoken", id));
                        }
                    }
                    finally {
                        if (slot == null) {
                            slotsBeingCreated.remove(data.getSlotLabel());
                        }
                        slotsBeingCreated.notifyAll();
                    }
                    Set<P11Slot> libSet = libMap.get(data.getLibName());
                    if (libSet == null) {
                        libSet = new HashSet<P11Slot>();
                        libMap.put(data.getLibName(), libSet);
                    }
                    libSet.add(slot);
                }
            }
        }
        Iterator<P11Slot> i = slotMap.values().iterator();
        while (i.hasNext()) {
            i.next().tokenids.remove(id);
        }
        slot.tokenids.add(id);
        return slot;
    }

    public void logoutFromSlotIfNoTokensActive() {
        Iterator<Integer> iTokens = this.tokenids.iterator();
        while (iTokens.hasNext()) {
            if (!tokenMap.get(iTokens.next()).isActive()) continue;
            return;
        }
        if (this.provider instanceof AuthProvider) {
            try {
                ((AuthProvider)this.provider).logout();
                log.debug((Object)("P11 session terminated for \"" + this + "\"."));
            }
            catch (LoginException e) {
                log.warn((Object)"Not possible to logout from P11 Session. HW problems?", (Throwable)e);
            }
        } else {
            log.warn((Object)("Not possible to logout from P11 provider '" + this + "'. It is not implementing '" + AuthProvider.class.getCanonicalName() + "'."));
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Provider createProvider() throws CryptoTokenOfflineException, NoSuchSlotException {
        Provider tmpProvider;
        block11: {
            while (this.isSettingProvider) {
                try {
                    this.wait();
                }
                catch (InterruptedException e1) {
                    log.fatal((Object)"This should never happened", (Throwable)e1);
                }
            }
            try {
                this.isSettingProvider = true;
                if (this.slotNr != null && this.sharedLibrary != null) {
                    tmpProvider = Pkcs11SlotLabel.getP11Provider(this.slotNr, this.slotLabelType, this.sharedLibrary, this.attributesFile);
                    break block11;
                }
                if (this.sunP11ConfigFileName != null) {
                    tmpProvider = new Pkcs11SlotLabel(Pkcs11SlotLabelType.SUN_FILE, null).getProvider(this.sunP11ConfigFileName, null, null);
                    break block11;
                }
                throw new IllegalStateException("Should never happen.");
            }
            finally {
                this.isSettingProvider = false;
                this.notifyAll();
            }
        }
        if (tmpProvider == null) {
            throw new NoSuchSlotException("Slot labeled " + this.slotNr + " could not be located.");
        }
        if (Security.getProvider(tmpProvider.getName()) != null) {
            Security.removeProvider(tmpProvider.getName());
        }
        Security.addProvider(tmpProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Provider successfully added: " + tmpProvider));
        }
        return tmpProvider;
    }

    private static class SlotDataParam
    implements SlotData {
        private final String friendlyName;
        private final String slotLabel;
        private final String sharedLibrary;
        private final String libName;
        private final Pkcs11SlotLabelType slotLabelType;
        private final String attributesFile;

        public SlotDataParam(String _friendlyName, String slotLabel, String _sharedLibrary, Pkcs11SlotLabelType slotLabelType, String _attributesFile) {
            this.slotLabel = slotLabel;
            this.sharedLibrary = _sharedLibrary;
            this.slotLabelType = slotLabelType;
            this.attributesFile = _attributesFile;
            this.libName = new File(this.sharedLibrary).getName();
            this.friendlyName = _friendlyName;
        }

        @Override
        public P11Slot getNewP11Slot() throws CryptoTokenOfflineException, NoSuchSlotException {
            return new P11Slot(this.slotLabel, this.slotLabelType, this.sharedLibrary, this.attributesFile);
        }

        @Override
        public String getSlotLabel() {
            if (this.friendlyName != null) {
                return this.friendlyName;
            }
            return this.slotLabel + this.libName + this.slotLabelType.toString();
        }

        @Override
        public String getLibName() {
            return this.libName;
        }
    }

    private static class SlotDataConfigFile
    implements SlotData {
        private final String configFileName;

        SlotDataConfigFile(String _configFileName) {
            this.configFileName = _configFileName;
        }

        @Override
        public String getLibName() {
            return P11Slot.ONLY_ONE;
        }

        @Override
        public P11Slot getNewP11Slot() throws CryptoTokenOfflineException, NoSuchSlotException {
            return new P11Slot(this.configFileName);
        }

        @Override
        public String getSlotLabel() {
            return new File(this.configFileName).getName();
        }
    }

    private static interface SlotData {
        public P11Slot getNewP11Slot() throws CryptoTokenOfflineException, NoSuchSlotException;

        public String getSlotLabel();

        public String getLibName();
    }
}

