/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token.p11;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.keys.token.p11.Pkcs11SlotLabelType;
import org.cesecore.keys.token.p11.Pkcs11Wrapper;
import org.cesecore.keys.token.p11.exception.NoSuchSlotException;
import org.cesecore.util.FileTools;

public class Pkcs11SlotLabel {
    public static final String SUN_PKCS11_CLASS = "sun.security.pkcs11.SunPKCS11";
    public static final String IAIK_PKCS11_CLASS = "iaik.pkcs.pkcs11.provider.IAIKPkcs11";
    public static final String IAIK_JCEPROVIDER_CLASS = "iaik.security.provider.IAIK";
    private static final Logger log = Logger.getLogger(Pkcs11SlotLabel.class);
    private static final String DELIMETER = ":";
    private final Pkcs11SlotLabelType type;
    private final String value;

    public Pkcs11SlotLabel(Pkcs11SlotLabelType type, String value) {
        if (type == null) {
            throw new IllegalArgumentException("Type can not be null");
        }
        this.type = type;
        this.value = value == null ? null : value.trim();
    }

    public String getTaggedString() {
        return this.type.name() + DELIMETER + this.value;
    }

    public String toString() {
        return "Slot type: '" + (Object)((Object)this.type) + "'. Slot value: '" + this.value + "'.";
    }

    public Provider getProvider(String fileName, String attributesFile, String privateKeyLabel) throws NoSuchSlotException {
        Provider prov;
        long slot;
        if (StringUtils.isEmpty((String)fileName)) {
            throw new IllegalArgumentException("A file name must be supplied.");
        }
        File libFile = new File(fileName);
        if (!libFile.isFile() || !libFile.canRead()) {
            throw new IllegalArgumentException("The file " + fileName + " can't be read.");
        }
        log.debug((Object)("slot spec: " + this.toString()));
        if (this.type == Pkcs11SlotLabelType.SUN_FILE) {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(libFile);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File " + libFile + " was not found.");
            }
            return Pkcs11SlotLabel.getSunP11Provider(fileInputStream);
        }
        Pkcs11Wrapper p11 = Pkcs11Wrapper.getInstance(libFile);
        switch (this.type) {
            case SLOT_LABEL: {
                slot = Pkcs11SlotLabel.getSlotID(this.value, p11);
                if (slot >= 0L) break;
                throw new IllegalStateException("Token label '" + this.value + "' not found.");
            }
            case SLOT_NUMBER: {
                slot = Long.parseLong(this.value);
                break;
            }
            case SLOT_INDEX: {
                slot = Long.parseLong(this.value.charAt(0) == 'i' ? this.value.substring(1) : this.value);
                break;
            }
            default: {
                throw new IllegalStateException("This should not ever happen if all type of slots are tested.");
            }
        }
        if ((prov = Pkcs11SlotLabel.getIAIKP11Provider(slot, libFile, this.type)) != null) {
            return prov;
        }
        prov = Pkcs11SlotLabel.getSunP11Provider(Pkcs11SlotLabel.getSunP11ProviderInputStream(slot, libFile, this.type, attributesFile, privateKeyLabel));
        if (prov != null) {
            return prov;
        }
        log.error((Object)"No provider available.");
        return null;
    }

    public static List<String> getExtendedTokenLabels(File libFile) {
        ArrayList<String> tokenLabels = new ArrayList<String>();
        Pkcs11Wrapper p11 = Pkcs11Wrapper.getInstance(libFile);
        long[] slots = p11.getSlotList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found numer of slots:\t" + slots.length));
        }
        for (int i = 0; i < slots.length; ++i) {
            long slotID = slots[i];
            char[] label = p11.getTokenLabel(slotID);
            if (label == null) continue;
            String tokenLabel = new String(label);
            if (log.isDebugEnabled()) {
                log.debug((Object)(i + ": Found token label:\t" + tokenLabel + "\tid=" + slotID));
            }
            tokenLabels.add(slotID + ";" + tokenLabel.trim());
        }
        return tokenLabels;
    }

    private static long getSlotID(String tokenLabel, Pkcs11Wrapper p11) throws NoSuchSlotException {
        long[] slots = p11.getSlotList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for token label:\t" + tokenLabel));
        }
        for (long slotID : slots) {
            char[] label = p11.getTokenLabel(slotID);
            if (label == null) continue;
            String candidateTokenLabel = new String(label);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Candidate token label:\t" + candidateTokenLabel));
            }
            if (!tokenLabel.equals(candidateTokenLabel.trim())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Label '" + tokenLabel + "' found. The slot ID is:\t" + slotID));
            }
            return slotID;
        }
        throw new NoSuchSlotException("Token label '" + tokenLabel + "' not found.");
    }

    private static Provider getIAIKP11Provider(long slot, File libFile, Pkcs11SlotLabelType type) {
        Properties prop = new Properties();
        try {
            prop.setProperty("PKCS11_NATIVE_MODULE", libFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Could for unknown reason not construct canonical filename.", e);
        }
        prop.setProperty("SLOT_ID", type.equals((Object)Pkcs11SlotLabelType.SLOT_INDEX) ? "[" + slot + "]" : Long.toString(slot));
        if (log.isDebugEnabled()) {
            log.debug((Object)prop.toString());
        }
        Provider ret = null;
        try {
            Class<?> implClass = Class.forName(IAIK_PKCS11_CLASS);
            log.info((Object)"Using IAIK PKCS11 provider: iaik.pkcs.pkcs11.provider.IAIKPkcs11");
            ret = (Provider)implClass.getConstructor(Properties.class).newInstance(prop);
            Class<?> jceImplClass = Class.forName(IAIK_JCEPROVIDER_CLASS);
            Provider iaikProvider = (Provider)jceImplClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (Security.getProvider(iaikProvider.getName()) == null) {
                log.info((Object)"Adding IAIK JCE provider for Delegation: iaik.security.provider.IAIK");
                Security.addProvider(iaikProvider);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ret;
    }

    private static InputStream getSunP11ProviderInputStream(long slot, File libFile, Pkcs11SlotLabelType type, String attributesFile, String privateKeyLabel) {
        String sSlot = Long.toString(slot);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("name = " + libFile.getName() + "-slot" + sSlot);
        try {
            pw.println("library = " + libFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Could for unknown reason not construct canonical filename.", e);
        }
        if (sSlot != null) {
            pw.println("slot" + (type.isEqual(Pkcs11SlotLabelType.SLOT_INDEX) ? "ListIndex" : "") + " = " + sSlot);
        }
        if (attributesFile != null) {
            byte[] attrs;
            try {
                attrs = FileTools.readFiletoBuffer(attributesFile);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File " + attributesFile + " was not found.", e);
            }
            pw.println(new String(attrs));
        } else {
            pw.println("attributes(*, CKO_PUBLIC_KEY, *) = {");
            pw.println("  CKA_TOKEN = false");
            pw.println("  CKA_ENCRYPT = true");
            pw.println("  CKA_VERIFY = true");
            pw.println("  CKA_WRAP = true");
            pw.println("}");
            pw.println("attributes(*, CKO_PRIVATE_KEY, *) = {");
            pw.println("  CKA_TOKEN = true");
            pw.println("  CKA_PRIVATE = true");
            pw.println("  CKA_SENSITIVE = true");
            pw.println("  CKA_EXTRACTABLE = false");
            pw.println("  CKA_DECRYPT = true");
            pw.println("  CKA_SIGN = true");
            if (privateKeyLabel != null && privateKeyLabel.length() > 0) {
                pw.print("  CKA_LABEL = 0h");
                pw.println(new String(Hex.encode((byte[])privateKeyLabel.getBytes())));
            }
            pw.println("  CKA_UNWRAP = true");
            pw.println("}");
            if (CesecoreConfiguration.p11disableHashingSignMechanisms()) {
                pw.println("disabledMechanisms = {");
                pw.println("  CKM_SHA1_RSA_PKCS");
                pw.println("  CKM_SHA256_RSA_PKCS");
                pw.println("  CKM_SHA384_RSA_PKCS");
                pw.println("  CKM_SHA512_RSA_PKCS");
                pw.println("  CKM_MD2_RSA_PKCS");
                pw.println("  CKM_MD5_RSA_PKCS");
                pw.println("  CKM_DSA_SHA1");
                pw.println("  CKM_ECDSA_SHA1");
                pw.println("}");
            }
            pw.println("attributes(*, CKO_SECRET_KEY, *) = {");
            pw.println("  CKA_SENSITIVE = true");
            pw.println("  CKA_EXTRACTABLE = false");
            pw.println("  CKA_ENCRYPT = true");
            pw.println("  CKA_DECRYPT = true");
            pw.println("  CKA_SIGN = true");
            pw.println("  CKA_VERIFY = true");
            pw.println("  CKA_WRAP = true");
            pw.println("  CKA_UNWRAP = true");
            pw.println("}");
        }
        pw.flush();
        pw.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)baos.toString());
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static Provider getSunP11ProviderNoExceptionHandeling(InputStream is) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> implClass = Class.forName(SUN_PKCS11_CLASS);
        log.info((Object)"Using SUN PKCS11 provider: sun.security.pkcs11.SunPKCS11");
        return (Provider)implClass.getConstructor(InputStream.class).newInstance(is);
    }

    private static Provider getSunP11Provider(InputStream is) {
        try {
            return Pkcs11SlotLabel.getSunP11ProviderNoExceptionHandeling(is);
        }
        catch (Exception e) {
            String msg = "Error constructing pkcs11 provider: " + e.getMessage();
            log.error((Object)msg);
            throw new IllegalStateException(msg, e);
        }
    }

    static void doC_Initialize(File libFile) {
        try {
            Pkcs11SlotLabel.getSunP11ProviderNoExceptionHandeling(Pkcs11SlotLabel.getSunP11ProviderInputStream(-1L, libFile, Pkcs11SlotLabelType.SLOT_NUMBER, null, null));
        }
        catch (InvocationTargetException e) {
            log.debug((Object)"Get dummy sun provider throws an exception. This is OK.", (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Error constructing pkcs11 provider: " + e.getMessage();
            log.error((Object)msg);
            throw new IllegalStateException(msg, e);
        }
    }

    public static Provider getP11Provider(String sSlot, Pkcs11SlotLabelType slotLabelType, String fileName, String attributesFile) throws NoSuchSlotException {
        return Pkcs11SlotLabel.getP11Provider(sSlot, slotLabelType, fileName, attributesFile, null);
    }

    public static Provider getP11Provider(String sSlot, Pkcs11SlotLabelType slotLabelType, String fileName, String attributesFile, String privateKeyLabel) throws NoSuchSlotException {
        if ((sSlot == null || sSlot.length() < 1) && slotLabelType != Pkcs11SlotLabelType.SUN_FILE) {
            return null;
        }
        Pkcs11SlotLabel slotSpec = new Pkcs11SlotLabel(slotLabelType, sSlot);
        return slotSpec.getProvider(fileName, attributesFile, privateKeyLabel);
    }
}

