/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token.p11;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public enum Pkcs11SlotLabelType {
    SLOT_LABEL("SLOT_LABEL", "Slot Label", LabelValidator.class),
    SLOT_INDEX("SLOT_INDEX", "Slot Index", IndexValidator.class),
    SLOT_NUMBER("SLOT_NUMBER", "Slot Number", NumberValidator.class),
    SUN_FILE("SUN_FILE", "Sun configuration file", null);

    private static final Logger log;
    private static final Map<String, Pkcs11SlotLabelType> keyLookUpMap;
    private final String description;
    private final String key;
    private final LabelTypeValidator validator;

    private Pkcs11SlotLabelType(String key, String _description, Class<? extends LabelTypeValidator> validator) {
        this.description = _description;
        this.key = key;
        if (validator == null) {
            this.validator = null;
        } else {
            try {
                this.validator = validator.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not instansiate " + validator, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not instansiate " + validator, e);
            }
        }
    }

    public String toString() {
        return this.description;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public static Pkcs11SlotLabelType getFromKey(String key) {
        return keyLookUpMap.get(key);
    }

    public boolean isEqual(Pkcs11SlotLabelType otherType) {
        return this.getKey().equals(otherType.getKey());
    }

    public boolean validate(String value) {
        if (this.validator != null) {
            return this.validator.validate(value);
        }
        return true;
    }

    static {
        log = Logger.getLogger(Pkcs11SlotLabelType.class);
        keyLookUpMap = new HashMap<String, Pkcs11SlotLabelType>();
        for (Pkcs11SlotLabelType type : Pkcs11SlotLabelType.values()) {
            keyLookUpMap.put(type.getKey(), type);
        }
    }

    protected static class LabelValidator
    implements LabelTypeValidator {
        protected LabelValidator() {
        }

        @Override
        public boolean validate(String value) {
            if (value.length() > 32) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value " + value + " was longer than the permitted 32 characters."));
                }
                return false;
            }
            return true;
        }
    }

    protected static class IndexValidator
    extends NumberValidator {
        protected IndexValidator() {
        }

        @Override
        public boolean validate(String value) {
            if (value.charAt(0) != 'i') {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(value + " did not start with 'i'"));
                }
                return false;
            }
            return super.validate(value.substring(1));
        }
    }

    protected static class NumberValidator
    implements LabelTypeValidator {
        protected NumberValidator() {
        }

        @Override
        public boolean validate(String value) {
            try {
                Long.parseLong(value);
                return true;
            }
            catch (NumberFormatException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(value + " was not a number."), (Throwable)e);
                }
                return false;
            }
        }
    }

    private static interface LabelTypeValidator {
        public boolean validate(String var1);
    }
}

