/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.token.p11;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.cesecore.keys.token.p11.Pkcs11SlotLabel;

public class Pkcs11Wrapper {
    private static final Logger log = Logger.getLogger(Pkcs11Wrapper.class);
    private static volatile Map<String, Pkcs11Wrapper> instances = new HashMap<String, Pkcs11Wrapper>();
    private static final Lock lock = new ReentrantLock();
    private final Method getSlotListMethod;
    private final Method getTokenInfoMethod;
    private final Field labelField;
    private final Object p11;
    private final HashMap<Long, char[]> labelMap;
    private final long[] slotList;

    private Pkcs11Wrapper(String fileName) {
        Method getInstanceMethod;
        Class<?> p11Class;
        try {
            p11Class = Class.forName("sun.security.pkcs11.wrapper.PKCS11");
        }
        catch (ClassNotFoundException e) {
            String msg = "Class sun.security.pkcs11.wrapper.PKCS11 was not found locally, could not wrap.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        try {
            this.getSlotListMethod = p11Class.getDeclaredMethod("C_GetSlotList", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            String msg = "Method C_GetSlotList was not found in class sun.security.pkcs11.wrapper.PKCS11, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (SecurityException e) {
            String msg = "Access was denied to method sun.security.pkcs11.wrapper.PKCS11.C_GetSlotList";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        try {
            this.getTokenInfoMethod = p11Class.getDeclaredMethod("C_GetTokenInfo", Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            String msg = "Method C_GetTokenInfo was not found in class sun.security.pkcs11.wrapper.PKCS11, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (SecurityException e) {
            String msg = "Access was denied to method sun.security.pkcs11.wrapper.PKCS11.C_GetTokenInfo";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        try {
            this.labelField = Class.forName("sun.security.pkcs11.wrapper.CK_TOKEN_INFO").getField("label");
        }
        catch (NoSuchFieldException e) {
            String msg = "Field 'label' was not found in class sun.security.pkcs11.wrapper.CK_TOKEN_INFO, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (SecurityException e) {
            String msg = "Access was denied to field sun.security.pkcs11.wrapper.CK_TOKEN_INFO.label";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (ClassNotFoundException e) {
            String msg = "Class sun.security.pkcs11.wrapper.CK_TOKEN_INFO was not found locally, could not wrap.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        try {
            getInstanceMethod = p11Class.getDeclaredMethod("getInstance", String.class, String.class, Class.forName("sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS"), Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            String msg = "Method getInstance was not found in class sun.security.pkcs11.wrapper.PKCS11.CK_C_INITIALIZE_ARGS, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (SecurityException e) {
            String msg = "Access was denied to method sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS.getInstance";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (ClassNotFoundException e) {
            String msg = "Class sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS was not found locally, could not wrap.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        try {
            this.p11 = getInstanceMethod.invoke(null, fileName, "C_GetFunctionList", null, Boolean.FALSE);
        }
        catch (IllegalAccessException e) {
            String msg = "Method sun.security.pkcs11.wrapper.PKCS11.CK_C_INITIALIZE_ARGS.getInstance was not accessible, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Wrong arguments were passed to sun.security.pkcs11.wrapper.PKCS11.CK_C_INITIALIZE_ARGS.getInstance. This may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Wrong arguments were passed to sun.security.pkcs11.wrapper.PKCS11.CK_C_INITIALIZE_ARGS.getInstance threw an exception for log.error(msg, e)";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        this.labelMap = new HashMap();
        for (long id : this.slotList = this.C_GetSlotList()) {
            this.labelMap.put(id, this.getTokenLabelLocal(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pkcs11Wrapper getInstance(File file) throws IllegalArgumentException {
        String canonicalFileName;
        try {
            canonicalFileName = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(file + " is not a valid filename.", e);
        }
        Pkcs11Wrapper storedP11 = instances.get(canonicalFileName);
        if (storedP11 != null) {
            return storedP11;
        }
        try {
            lock.lock();
            storedP11 = instances.get(canonicalFileName);
            if (storedP11 != null) {
                Pkcs11Wrapper pkcs11Wrapper = storedP11;
                return pkcs11Wrapper;
            }
            Pkcs11SlotLabel.doC_Initialize(file);
            Pkcs11Wrapper newP11 = new Pkcs11Wrapper(canonicalFileName);
            instances.put(canonicalFileName, newP11);
            Pkcs11Wrapper pkcs11Wrapper = newP11;
            return pkcs11Wrapper;
        }
        finally {
            lock.unlock();
        }
    }

    public long[] getSlotList() {
        return this.slotList;
    }

    public char[] getTokenLabel(long slotID) {
        return this.labelMap.get(slotID);
    }

    private long[] C_GetSlotList() {
        try {
            return (long[])this.getSlotListMethod.invoke(this.p11, Boolean.TRUE);
        }
        catch (IllegalAccessException e) {
            String msg = "Access was denied to method sun.security.pkcs11.wrapper.PKCS11C.GetSlotList, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Incorrect parameters sent to sun.security.pkcs11.wrapper.PKCS11C.GetSlotList, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Method sun.security.pkcs11.wrapper.PKCS11C.GetSlotList threw an unknown exception.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    private char[] getTokenLabelLocal(long slotID) {
        Object tokenInfo;
        try {
            tokenInfo = this.getTokenInfoMethod.invoke(this.p11, slotID);
        }
        catch (IllegalAccessException e) {
            String msg = "Access was denied to method sun.security.pkcs11.wrapper.PKCS11.C_GetTokenInfo, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Incorrect parameters sent to sun.security.pkcs11.wrapper.PKCS11.C_GetTokenInfo, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Method sun.security.pkcs11.wrapper.PKCS11.C_GetTokenInfo threw an unknown exception.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        if (tokenInfo == null) {
            return null;
        }
        try {
            String result = String.copyValueOf((char[])this.labelField.get(tokenInfo));
            return result.trim().toCharArray();
        }
        catch (IllegalArgumentException e) {
            String msg = "Field sun.security.pkcs11.wrapper.PKCS11.C_GetTokenInfo was not of type sun.security.pkcs11.wrapper.CK_TOKEN_INFO, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Access was denied to field sun.security.pkcs11.wrapper.CK_TOKEN_INFO.label, this may be due to a change in the underlying library.";
            log.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }
}

